/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.ianlim224.advancedlottery.listeners;

import com.gmail.ianlim224.advancedlottery.AdvancedLottery;
import com.gmail.ianlim224.advancedlottery.ItemGrabber;
import com.gmail.ianlim224.advancedlottery.gui.ConfirmHolder;
import com.gmail.ianlim224.advancedlottery.gui.HelpHolder;
import com.gmail.ianlim224.advancedlottery.gui.LotteryGUI;
import com.gmail.ianlim224.advancedlottery.gui.LotteryHolder;
import com.gmail.ianlim224.advancedlottery.gui.PlayerStatsGUI;
import com.gmail.ianlim224.utils.XMaterial;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class InventoryClick
implements Listener {
    private final ItemGrabber grabber;
    private final LotteryGUI gui;
    private final AdvancedLottery plugin;

    public InventoryClick(AdvancedLottery plugin) {
        this.grabber = ItemGrabber.getInstance(plugin);
        this.gui = LotteryGUI.getInstance();
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void inventoryClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        ItemStack item = event.getCurrentItem();
        Inventory inventory = event.getView().getTopInventory();
        if (inventory.getHolder() instanceof HelpHolder || inventory.getHolder() instanceof ConfirmHolder || inventory.getHolder() instanceof LotteryHolder) {
            event.setCancelled(true);
        }
        if (inventory.getHolder() instanceof LotteryHolder) {
            if (item == null) {
                return;
            }
            if (item.equals((Object)this.grabber.getNextArrow())) {
                this.gui.openNextPage(player);
                return;
            }
            if (item.getType() == XMaterial.PLAYER_HEAD.parseMaterial()) {
                OfflinePlayer target = this.plugin.getSkullManager().getPlayer(item);
                PlayerStatsGUI statsGui = new PlayerStatsGUI(target, this.plugin);
                statsGui.openGui(player);
                return;
            }
            if (item.equals((Object)this.grabber.getPreviousArrow())) {
                this.gui.openPreviousPage(player);
                return;
            }
            if (item.equals((Object)this.grabber.getBuyButton())) {
                Bukkit.dispatchCommand((CommandSender)player, (String)"lottery buy");
            }
        }
    }
}

