/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.ianlim224.advancedlottery.object;

import com.gmail.ianlim224.advancedlottery.AdvancedLottery;
import com.gmail.ianlim224.advancedlottery.mysql.LotterySql;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionAttachmentInfo;

public class LotteryTicket {
    private static final Pattern DONOR_PERMISSION_PATTERN = Pattern.compile("advancedlottery\\.maxtickets\\.[0-9]+");
    private static LotteryTicket instance;
    private final AdvancedLottery plugin;
    private final HashMap<UUID, Integer> ticketCounts;
    private final HashMap<UUID, Integer> maxTicketCache;
    private LotterySql sql;

    private LotteryTicket(AdvancedLottery plugin) {
        this.plugin = plugin;
        this.ticketCounts = new HashMap();
        this.maxTicketCache = new HashMap();
        this.sql = LotterySql.getInstance(plugin);
    }

    public static LotteryTicket getInstance(AdvancedLottery plugin) {
        if (instance != null) {
            return instance;
        }
        instance = new LotteryTicket(plugin);
        return instance;
    }

    public boolean isMaxTickets(Player player) {
        return this.getMaxTicketsCanBeBought(player) == 0;
    }

    public int getMaxTicketsCanBeBought(Player player) {
        if (this.maxTicketCache.containsKey(player.getUniqueId())) {
            return this.maxTicketCache.get(player.getUniqueId()) - this.getTicketsBought(player.getUniqueId());
        }
        PermissionAttachmentInfo permission = player.getEffectivePermissions().stream().filter(p -> DONOR_PERMISSION_PATTERN.matcher(p.getPermission()).matches()).findFirst().orElse(null);
        if (permission == null || !permission.getValue()) {
            int maxTickets = AdvancedLottery.getLotteryGrabber().getMaxTicketDefault();
            if (player.hasPermission("advancedlottery.donor")) {
                maxTickets = AdvancedLottery.getLotteryGrabber().getMaxTicketDonor();
            }
            this.maxTicketCache.put(player.getUniqueId(), maxTickets);
            return maxTickets;
        }
        String[] tokens = permission.getPermission().split("\\.");
        int maxTickets = Integer.parseInt(tokens[2]);
        this.maxTicketCache.put(player.getUniqueId(), maxTickets);
        return maxTickets;
    }

    public UUID selectWinner() {
        int uppBound = 0;
        for (Map.Entry<UUID, Integer> entry : this.ticketCounts.entrySet()) {
            uppBound += entry.getValue().intValue();
        }
        int winningIndex = this.plugin.getRandom().nextInt(uppBound);
        int counter = 0;
        for (Map.Entry<UUID, Integer> entry : this.ticketCounts.entrySet()) {
            if ((counter += entry.getValue().intValue()) <= winningIndex) continue;
            return entry.getKey();
        }
        throw new IllegalStateException("Invalid winner decision state");
    }

    void addPlayer(OfflinePlayer player, int tickets) {
        if (this.ticketCounts.containsKey(player.getUniqueId())) {
            this.ticketCounts.put(player.getUniqueId(), this.ticketCounts.get(player.getUniqueId()) + tickets);
        } else {
            this.ticketCounts.put(player.getUniqueId(), tickets);
        }
        this.sql.addTicketsBought(player, tickets);
    }

    public int getTicketsBought(UUID player) {
        return this.ticketCounts.getOrDefault(player, 0);
    }

    public Map<UUID, Integer> getWhoBought() {
        return this.ticketCounts;
    }

    public Set<UUID> getPlayers() {
        return this.ticketCounts.keySet();
    }

    public double getTicketCost() {
        return this.plugin.getConfig().getDouble("buy_price");
    }

    public void clear() {
        this.ticketCounts.clear();
    }

    public boolean isEmpty() {
        return this.ticketCounts.isEmpty();
    }

    public void clearCache() {
        this.maxTicketCache.clear();
    }
}

