/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.ianlim224.advancedlottery.time;

import com.gmail.ianlim224.advancedlottery.AdvancedLottery;
import com.gmail.ianlim224.advancedlottery.messages.Messages;
import com.gmail.ianlim224.advancedlottery.object.LotteryPot;
import com.gmail.ianlim224.advancedlottery.time.Time;
import com.gmail.ianlim224.advancedlottery.utils.SpigotCommons;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class Reminder
implements Comparable<Reminder> {
    public static final String NOT_ANNOUNCED = SpigotCommons.f("&c&l[NOT ANNOUNCED]");
    public static final String HAS_ANNOUNCED = SpigotCommons.f("&a&l[HAS ANNOUNCED]");
    private final Time time;
    private final AdvancedLottery plugin;
    private BukkitTask task;

    public Reminder(Time time, AdvancedLottery plugin) {
        this.time = time;
        this.task = null;
        this.plugin = plugin;
        if (plugin.getLotteryTimer().getDuration() - time.toMilis() > 0L) {
            this.schedule();
        }
    }

    public boolean hasAnnounced() {
        return this.task == null;
    }

    public void cancel() {
        if (this.task != null) {
            this.task.cancel();
        }
        this.task = null;
    }

    public void schedule() {
        if (!this.hasAnnounced()) {
            throw new IllegalStateException("Previous task have not ended yet");
        }
        this.task = new BukkitRunnable(){

            public void run() {
                for (Player p : Bukkit.getOnlinePlayers()) {
                    String msg = Messages.LOTTERY_REMINDER.getConfigValue(p).replaceAll("%time%", Reminder.this.time.toString()).replaceAll("%money%", SpigotCommons.formatMoney(LotteryPot.getInstance(Reminder.this.plugin).getMoneyInPot()));
                    for (String s : msg.split("%line%")) {
                        p.sendMessage(s);
                    }
                }
                Reminder.this.cancel();
            }
        }.runTaskLater((Plugin)this.plugin, (long)new Time(this.plugin.getLotteryTimer().getDuration() - this.time.toMilis(), false, this.plugin).toTicks());
    }

    public Time getTime() {
        return this.time;
    }

    public long getMilis() {
        return this.time.toMilis();
    }

    public String toString() {
        return this.time.toString() + " " + (this.hasAnnounced() ? HAS_ANNOUNCED : NOT_ANNOUNCED);
    }

    @Override
    public int compareTo(Reminder r) {
        return (int)(this.time.toMilis() - r.time.toMilis());
    }
}

