/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.ianlim224.advancedlottery.time;

import com.gmail.ianlim224.advancedlottery.AdvancedLottery;
import com.gmail.ianlim224.advancedlottery.time.Reminder;
import com.gmail.ianlim224.advancedlottery.time.TimeParser;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

public class ReminderManager {
    private final Map<Long, Reminder> reminders = new HashMap<Long, Reminder>();
    private final File remindersFile;
    private final AdvancedLottery plugin;

    public ReminderManager(AdvancedLottery plugin) {
        this.remindersFile = new File(plugin.getDataFolder(), "reminders.dat");
        this.plugin = plugin;
    }

    public void addReminder(Reminder reminder) {
        if (this.reminders.containsKey(reminder.getMilis())) {
            return;
        }
        this.reminders.put(reminder.getMilis(), reminder);
    }

    public void removeReminder(Reminder reminder) {
        this.reminders.remove(reminder.getMilis());
    }

    public boolean hasReminder(Reminder reminder) {
        return this.reminders.containsKey(reminder.getMilis());
    }

    public void read() {
        this.checkIfRemindersFileExists();
        try (BufferedReader reader = new BufferedReader(new FileReader(this.remindersFile));){
            String s;
            while ((s = reader.readLine()) != null) {
                TimeParser parser = new TimeParser(s, this.plugin);
                this.addReminder(new Reminder(parser.getTime(), this.plugin));
            }
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to read from reminders.dat!", e);
        }
    }

    public void clean() {
        for (Reminder reminder : this.reminders.values()) {
            reminder.cancel();
        }
        this.reminders.clear();
    }

    public void save() {
        this.checkIfRemindersFileExists();
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.remindersFile, false));){
            for (Reminder reminder : this.reminders.values()) {
                writer.write(reminder.getTime().toString() + "\n");
            }
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to write to reminders.dat!", e);
        }
    }

    private void checkIfRemindersFileExists() {
        if (!this.remindersFile.exists()) {
            try {
                this.remindersFile.createNewFile();
            }
            catch (IOException e) {
                this.plugin.getLogger().log(Level.SEVERE, "Failed to create reminders.dat!", e);
            }
        }
    }

    public void reload() {
        for (Reminder reminder : this.reminders.values()) {
            reminder.cancel();
            reminder.schedule();
        }
    }

    public Reminder[] getReminders() {
        return this.reminders.values().toArray(new Reminder[0]);
    }
}

