/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.ianlim224.advancedlottery.time;

import com.gmail.ianlim224.advancedlottery.AdvancedLottery;
import java.util.concurrent.TimeUnit;
import org.bukkit.configuration.file.FileConfiguration;

public class Time {
    private final int days;
    private final int hours;
    private final int minutes;
    private final int seconds;
    private final boolean isShort;
    private final AdvancedLottery plugin;

    public Time(int days, int hours, int minutes, int seconds, boolean isShort, AdvancedLottery plugin) {
        this.days = days;
        this.hours = hours;
        this.minutes = minutes;
        this.seconds = seconds;
        this.isShort = isShort;
        this.plugin = plugin;
    }

    public Time(long milis, boolean isShort, AdvancedLottery plugin) {
        this.days = (int)(milis / 86400000L);
        this.hours = (int)((milis - TimeUnit.DAYS.toMillis(this.days)) / 3600000L);
        this.minutes = (int)((milis - TimeUnit.HOURS.toMillis(this.hours) - TimeUnit.DAYS.toMillis(this.days)) / 60000L);
        this.seconds = (int)((milis - TimeUnit.MINUTES.toMillis(this.minutes) - TimeUnit.HOURS.toMillis(this.hours) - TimeUnit.DAYS.toMillis(this.days)) / 1000L);
        this.plugin = plugin;
        this.isShort = isShort;
    }

    public int getDays() {
        return this.days;
    }

    public int getHours() {
        return this.hours;
    }

    public int getMinutes() {
        return this.minutes;
    }

    public int getSeconds() {
        return this.seconds;
    }

    public boolean isShort() {
        return this.isShort;
    }

    public long toMilis() {
        return TimeUnit.SECONDS.toMillis(this.seconds) + TimeUnit.MINUTES.toMillis(this.minutes) + TimeUnit.HOURS.toMillis(this.hours) + TimeUnit.DAYS.toMillis(this.days);
    }

    public int toSeconds() {
        return (int)((long)this.seconds + TimeUnit.MINUTES.toSeconds(this.minutes) + TimeUnit.HOURS.toSeconds(this.hours) + TimeUnit.DAYS.toSeconds(this.days));
    }

    public int toTicks() {
        return this.toSeconds() * 20;
    }

    public String toString() {
        String seconds;
        String minutes;
        String hours;
        String days;
        FileConfiguration config = this.plugin.getConfig();
        if (!this.isShort) {
            days = this.getDays() == 0 ? "" : this.getDays() + " " + config.getString("time.days");
            hours = this.getHours() == 0 ? "" : this.getHours() + " " + config.getString("time.hours");
            minutes = this.getMinutes() == 0 ? "" : this.getMinutes() + " " + config.getString("time.minutes");
            seconds = this.getSeconds() == 0 ? "" : this.getSeconds() + " " + config.getString("time.seconds");
        } else {
            days = this.getDays() == 0 ? "" : this.getDays() + " " + config.getString("time.days_short");
            hours = this.getHours() == 0 ? "" : this.getHours() + " " + config.getString("time.hours_short");
            minutes = this.getMinutes() == 0 ? "" : this.getMinutes() + " " + config.getString("time.minutes_short");
            String string = seconds = this.getSeconds() == 0 ? "" : this.getSeconds() + " " + config.getString("time.seconds_short");
        }
        if (!"".equals(days) && !"".equals(hours)) {
            hours = ", " + hours;
        }
        if (!"".equals(hours) && !"".equals(minutes)) {
            minutes = ", " + minutes;
        }
        if (!"".equals(minutes) && !"".equals(seconds)) {
            seconds = ", " + seconds;
        }
        return days + hours + minutes + seconds;
    }
}

