/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.ianlim224.advancedlottery.time;

import com.gmail.ianlim224.advancedlottery.AdvancedLottery;
import com.gmail.ianlim224.advancedlottery.time.Time;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TimeParser {
    private final String input;
    private int seconds;
    private int minutes;
    private int hours;
    private int days;
    private boolean isValid;
    private final AdvancedLottery plugin;
    private static final Pattern TIME_PATTERN = Pattern.compile("[1-9][0-9]*[smhd]");
    private static final Pattern NUMBER_PATTERN = Pattern.compile("[1-9][0-9]*");
    private static final Pattern ALPHABET_PATTERN = Pattern.compile("[smhd]");

    public TimeParser(String input, AdvancedLottery plugin) {
        this.input = input.toLowerCase().replaceAll("\\s+", "");
        this.seconds = 0;
        this.minutes = 0;
        this.hours = 0;
        this.days = 0;
        this.plugin = plugin;
        this.parse();
    }

    private void parse() {
        Matcher matcher = TIME_PATTERN.matcher(this.input);
        if (!matcher.find()) {
            this.isValid = false;
            return;
        }
        matcher.reset();
        block6: while (matcher.find()) {
            String subString = matcher.group();
            Matcher number = NUMBER_PATTERN.matcher(subString);
            Matcher alphabet = ALPHABET_PATTERN.matcher(subString);
            int i = 0;
            if (!number.find()) {
                throw new IllegalStateException("Cannot find number value?!");
            }
            i = Integer.parseInt(number.group());
            String time = null;
            if (!alphabet.find()) {
                throw new IllegalStateException("Cannot find time value?!");
            }
            time = alphabet.group();
            switch (time.charAt(0)) {
                case 's': {
                    this.seconds += i;
                    continue block6;
                }
                case 'm': {
                    this.minutes += i;
                    continue block6;
                }
                case 'h': {
                    this.hours += i;
                    continue block6;
                }
                case 'd': {
                    this.days += i;
                    continue block6;
                }
            }
            throw new IllegalStateException("Invalid time parsed");
        }
        this.isValid = true;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public Time getTime() {
        return new Time(this.days, this.hours, this.minutes, this.seconds, false, this.plugin);
    }

    public String toString() {
        return this.input;
    }
}

