/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.ianlim224.advancedlottery.utils;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.math.NumberUtils;
import org.bukkit.plugin.java.JavaPlugin;

public final class UpdateChecker {
    public static final VersionScheme VERSION_SCHEME_DECIMAL = (first, second) -> {
        String[] firstSplit = UpdateChecker.splitVersionInfo(first);
        String[] secondSplit = UpdateChecker.splitVersionInfo(second);
        if (firstSplit == null || secondSplit == null) {
            return null;
        }
        for (int i = 0; i < Math.min(firstSplit.length, secondSplit.length); ++i) {
            int currentValue = NumberUtils.toInt((String)firstSplit[i]);
            int newestValue = NumberUtils.toInt((String)secondSplit[i]);
            if (newestValue > currentValue) {
                return second;
            }
            if (newestValue >= currentValue) continue;
            return first;
        }
        return secondSplit.length > firstSplit.length ? second : first;
    };
    private static final String USER_AGENT = "CHOCO-update-checker";
    private static final String UPDATE_URL = "https://api.spigotmc.org/simple/0.1/index.php?action=getResource&id=%d";
    private static final Pattern DECIMAL_SCHEME_PATTERN = Pattern.compile("\\d+(?:\\.\\d+)*");
    private static UpdateChecker instance;
    private UpdateResult lastResult = null;
    private final JavaPlugin plugin;
    private final int pluginID;
    private final VersionScheme versionScheme;

    private UpdateChecker(JavaPlugin plugin, int pluginID, VersionScheme versionScheme) {
        this.plugin = plugin;
        this.pluginID = pluginID;
        this.versionScheme = versionScheme;
    }

    public CompletableFuture<UpdateResult> requestUpdateCheck() {
        return CompletableFuture.supplyAsync(() -> {
            int responseCode = -1;
            try {
                URL url = new URL(String.format(UPDATE_URL, this.pluginID));
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.addRequestProperty("User-Agent", USER_AGENT);
                InputStreamReader reader = new InputStreamReader(connection.getInputStream());
                responseCode = connection.getResponseCode();
                JsonElement element = new JsonParser().parse((Reader)reader);
                reader.close();
                JsonObject versionObject = element.getAsJsonObject();
                String current = this.plugin.getDescription().getVersion();
                String newest = versionObject.get("current_version").getAsString();
                String latest = this.versionScheme.compareVersions(current, newest);
                if (latest == null) {
                    return new UpdateResult(UpdateReason.UNSUPPORTED_VERSION_SCHEME);
                }
                if (latest.equals(current)) {
                    return new UpdateResult(current.equals(newest) ? UpdateReason.UP_TO_DATE : UpdateReason.UNRELEASED_VERSION);
                }
                if (latest.equals(newest)) {
                    return new UpdateResult(UpdateReason.NEW_UPDATE, latest);
                }
            }
            catch (IOException e) {
                return new UpdateResult(UpdateReason.COULD_NOT_CONNECT);
            }
            catch (JsonSyntaxException e) {
                return new UpdateResult(UpdateReason.INVALID_JSON);
            }
            return new UpdateResult(responseCode == 401 ? UpdateReason.UNAUTHORIZED_QUERY : UpdateReason.UNKNOWN_ERROR);
        });
    }

    public UpdateResult getLastResult() {
        return this.lastResult;
    }

    private static String[] splitVersionInfo(String version) {
        Matcher matcher = DECIMAL_SCHEME_PATTERN.matcher(version);
        if (!matcher.find()) {
            return null;
        }
        return matcher.group().split("\\.");
    }

    public static UpdateChecker init(JavaPlugin plugin, int pluginID, VersionScheme versionScheme) {
        Preconditions.checkArgument((plugin != null ? 1 : 0) != 0, (Object)"Plugin cannot be null");
        Preconditions.checkArgument((pluginID > 0 ? 1 : 0) != 0, (Object)"Plugin ID must be greater than 0");
        Preconditions.checkArgument((versionScheme != null ? 1 : 0) != 0, (Object)"null version schemes are unsupported");
        return instance == null ? (instance = new UpdateChecker(plugin, pluginID, versionScheme)) : instance;
    }

    public static UpdateChecker init(JavaPlugin plugin, int pluginID) {
        return UpdateChecker.init(plugin, pluginID, VERSION_SCHEME_DECIMAL);
    }

    public static UpdateChecker get() {
        Preconditions.checkState((instance != null ? 1 : 0) != 0, (Object)"Instance has not yet been initialized. Be sure #init() has been invoked");
        return instance;
    }

    public static boolean isInitialized() {
        return instance != null;
    }

    public final class UpdateResult {
        private final UpdateReason reason;
        private final String newestVersion;

        private UpdateResult(UpdateReason reason, String newestVersion) {
            UpdateChecker.this.lastResult = this;
            this.reason = reason;
            this.newestVersion = newestVersion;
        }

        private UpdateResult(UpdateReason reason) {
            UpdateChecker.this.lastResult = this;
            Preconditions.checkArgument((reason != UpdateReason.NEW_UPDATE ? 1 : 0) != 0, (Object)"Reasons that require updates must also provide the latest version String");
            this.reason = reason;
            this.newestVersion = UpdateChecker.this.plugin.getDescription().getVersion();
        }

        public UpdateReason getReason() {
            return this.reason;
        }

        public boolean requiresUpdate() {
            return this.reason == UpdateReason.NEW_UPDATE;
        }

        public String getNewestVersion() {
            return this.newestVersion;
        }
    }

    @FunctionalInterface
    public static interface VersionScheme {
        public String compareVersions(String var1, String var2);
    }

    public static enum UpdateReason {
        NEW_UPDATE,
        COULD_NOT_CONNECT,
        INVALID_JSON,
        UNAUTHORIZED_QUERY,
        UNRELEASED_VERSION,
        UNKNOWN_ERROR,
        UNSUPPORTED_VERSION_SCHEME,
        UP_TO_DATE;

    }
}

