/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.ianlim224.advancedlottery.utils;

import com.gmail.ianlim224.advancedlottery.AdvancedLottery;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;

public class WinnerRegistry {
    private final File winnersFile;
    private final AdvancedLottery plugin;
    private OfflinePlayer winner;

    public WinnerRegistry(AdvancedLottery plugin) {
        this.winnersFile = new File(plugin.getDataFolder() + "/data", "winner.dat");
        this.plugin = plugin;
        this.winner = null;
    }

    public void read() {
        this.checkIfWinnersFileExists();
        try (BufferedReader reader = new BufferedReader(new FileReader(this.winnersFile));){
            String uid = reader.readLine();
            if (uid == null) {
                return;
            }
            this.winner = Bukkit.getOfflinePlayer((UUID)UUID.fromString(uid));
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to read from winner.dat!", e);
        }
    }

    private void checkIfWinnersFileExists() {
        this.winnersFile.getParentFile().mkdirs();
        if (!this.winnersFile.exists()) {
            try {
                this.winnersFile.createNewFile();
            }
            catch (IOException e) {
                this.plugin.getLogger().log(Level.SEVERE, "Failed to create winner.dat!", e);
            }
        }
    }

    public void save() {
        this.checkIfWinnersFileExists();
        if (this.winner == null) {
            return;
        }
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.winnersFile, false));){
            writer.write(this.winner.getUniqueId().toString() + "\n");
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to write to winner.dat!", e);
        }
    }

    public OfflinePlayer getWinner() {
        return this.winner;
    }

    public void setWinner(OfflinePlayer winner) {
        this.winner = winner;
    }
}

