/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.api;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nexmedia.engine.utils.random.Rnd;
import su.nightexpress.ama.api.type.MobFaction;

public class MobList {
    private final Map<MobFaction, Set<LivingEntity>> map = new HashMap<MobFaction, Set<LivingEntity>>();

    public boolean hasAliveEnemies() {
        return !this.getEnemies().isEmpty();
    }

    public boolean hasAliveAllies() {
        return !this.getAllies().isEmpty();
    }

    public boolean isAlly(@NotNull LivingEntity livingEntity) {
        return this.getAllies().contains(livingEntity);
    }

    public boolean isEnemy(@NotNull LivingEntity livingEntity) {
        return this.getEnemies().contains(livingEntity);
    }

    @Nullable
    public MobFaction getFaction(@NotNull LivingEntity livingEntity) {
        if (this.isAlly(livingEntity)) {
            return MobFaction.ALLY;
        }
        if (this.isEnemy(livingEntity)) {
            return MobFaction.ENEMY;
        }
        return null;
    }

    public void remove(@NotNull LivingEntity livingEntity) {
        for (MobFaction mobFaction : MobFaction.values()) {
            if (this.getAll(mobFaction).remove(livingEntity)) break;
        }
    }

    public void removeInvalid() {
        for (MobFaction mobFaction : MobFaction.values()) {
            this.removeInvalid(mobFaction);
        }
    }

    public void removeInvalid(@NotNull MobFaction mobFaction) {
        this.getAll(mobFaction).removeIf(livingEntity -> livingEntity.isDead() || !livingEntity.isValid());
    }

    public void removeAll() {
        for (MobFaction mobFaction : MobFaction.values()) {
            this.removeAll(mobFaction);
        }
    }

    public void removeAll(@NotNull MobFaction mobFaction) {
        this.getAll(mobFaction).forEach(Entity::remove);
        this.getAll(mobFaction).clear();
    }

    @Nullable
    public LivingEntity getRandom(@NotNull MobFaction mobFaction) {
        Set<LivingEntity> set = this.getAll(mobFaction);
        return set.isEmpty() ? null : (LivingEntity)Rnd.get(this.getAll(mobFaction));
    }

    @NotNull
    public Set<LivingEntity> getEnemies() {
        return this.getAll(MobFaction.ENEMY);
    }

    @NotNull
    public Set<LivingEntity> getAllies() {
        return this.getAll(MobFaction.ALLY);
    }

    @NotNull
    public Set<LivingEntity> getAll() {
        return this.getMap().entrySet().stream().flatMap(entry -> ((Set)entry.getValue()).stream()).collect(Collectors.toSet());
    }

    @NotNull
    public Set<LivingEntity> getAll(@NotNull MobFaction mobFaction2) {
        return this.getMap().computeIfAbsent(mobFaction2, mobFaction -> new HashSet());
    }

    @NotNull
    public Map<MobFaction, Set<LivingEntity>> getMap() {
        return this.map;
    }
}

