/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.api.hologram;

import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Location;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.ama.api.ArenaAPI;
import su.nightexpress.ama.api.hologram.HologramType;
import su.nightexpress.ama.api.hologram.IHologramClick;
import su.nightexpress.ama.hologram.HologramManager;

public interface HologramHolder {
    @NotNull
    public Set<Location> getHologramLocations();

    @NotNull
    public Set<UUID> getHologramIds();

    @NotNull
    public List<String> getHologramFormat();

    @NotNull
    public HologramType getHologramType();

    default public void createHolograms() {
        HologramManager holograms = ArenaAPI.PLUGIN.getHologramManager();
        if (holograms == null) {
            return;
        }
        List<String> text = this.getHologramFormat();
        if (text.isEmpty()) {
            return;
        }
        this.getHologramLocations().forEach(location -> this.getHologramIds().add(holograms.create(this.getHologramType(), (Location)location, text)));
    }

    default public void removeHolograms() {
        HologramManager holograms = ArenaAPI.PLUGIN.getHologramManager();
        if (holograms == null) {
            return;
        }
        this.getHologramIds().forEach(id -> holograms.delete(this.getHologramType(), (UUID)id));
        this.getHologramIds().clear();
    }

    default public void setHologramClick(@NotNull IHologramClick click) {
        HologramManager holograms = ArenaAPI.PLUGIN.getHologramManager();
        if (holograms == null) {
            return;
        }
        this.getHologramIds().forEach(id -> holograms.setClick(this.getHologramType(), (UUID)id, click));
    }

    default public void updateHolograms() {
        this.removeHolograms();
        this.createHolograms();
    }
}

