/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.arena;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Location;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.ama.AMA;
import su.nightexpress.ama.api.arena.ArenaChild;
import su.nightexpress.ama.api.hologram.HologramHolder;
import su.nightexpress.ama.api.hologram.HologramType;
import su.nightexpress.ama.arena.impl.ArenaConfig;
import su.nightexpress.ama.hologram.HologramManager;
import su.nightexpress.ama.stats.object.StatType;
import su.nightexpress.ama.stats.object.StatsScore;

public class ArenaStatsHologram
implements ArenaChild,
HologramHolder {
    private final ArenaConfig arenaConfig;
    private final StatType statType;
    private final Set<UUID> hologramIds;
    private final Set<Location> hologramLocations;

    public ArenaStatsHologram(@NotNull ArenaConfig arenaConfig, @NotNull StatType statType, @NotNull Set<Location> set) {
        this.arenaConfig = arenaConfig;
        this.statType = statType;
        this.hologramIds = new HashSet<UUID>();
        this.hologramLocations = new HashSet<Location>(set);
    }

    @Override
    @NotNull
    public ArenaConfig getArenaConfig() {
        return this.arenaConfig;
    }

    @NotNull
    public StatType getStatType() {
        return this.statType;
    }

    @Override
    @NotNull
    public HologramType getHologramType() {
        return HologramType.ARENA_STATS;
    }

    @Override
    @NotNull
    public Set<UUID> getHologramIds() {
        return this.hologramIds;
    }

    @Override
    @NotNull
    public Set<Location> getHologramLocations() {
        return this.hologramLocations;
    }

    @Override
    @NotNull
    public List<String> getHologramFormat() {
        List<String> list = HologramManager.getFormat(this.getHologramType());
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            if (string.contains("%score_name%")) {
                int n = 1;
                for (StatsScore statsScore : ((AMA)this.arenaConfig.plugin()).getStatsManager().getScores(this.statType, 10, this.arenaConfig.getId())) {
                    arrayList.add((String)statsScore.replacePlaceholders(n++).apply(string));
                }
                continue;
            }
            string = string.replace("%score_stat_type%", ((AMA)this.arenaConfig.plugin()).getLangManager().getEnum((Enum)this.statType));
            string = (String)this.arenaConfig.replacePlaceholders().apply(string);
            arrayList.add(string);
        }
        return arrayList;
    }
}

