/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.arena.board;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.InternalStructure;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.utils.EngineUtils;
import su.nightexpress.ama.arena.board.ArenaBoardConfig;
import su.nightexpress.ama.arena.impl.Arena;
import su.nightexpress.ama.arena.impl.ArenaPlayer;
import su.nightexpress.ama.hook.external.ProtocolLibHook;

public class ArenaBoard {
    private final ArenaPlayer arenaPlayer;
    private final Player player;
    private final String title;
    private final List<String> lines;
    private final String playerId;
    private final Map<Integer, String> scores;

    public ArenaBoard(@NotNull ArenaPlayer arenaPlayer, @NotNull ArenaBoardConfig arenaBoardConfig) {
        this.arenaPlayer = arenaPlayer;
        this.player = arenaPlayer.getPlayer();
        this.title = arenaBoardConfig.getTitle();
        this.lines = arenaBoardConfig.getLines();
        this.playerId = this.player.getUniqueId().toString().replace("-", "").substring(0, 15);
        this.scores = new HashMap<Integer, String>();
    }

    @NotNull
    private String getPlayerIdentifier() {
        return this.playerId;
    }

    @NotNull
    private String getScoreIdentifier(int n) {
        return "\u00a7" + String.join((CharSequence)String.valueOf('\u00a7'), String.valueOf(n).split(""));
    }

    public void create() {
        PacketContainer packetContainer = new PacketContainer(PacketType.Play.Server.SCOREBOARD_OBJECTIVE);
        packetContainer.getModifier().writeDefaults();
        packetContainer.getStrings().write(0, (Object)this.getPlayerIdentifier());
        packetContainer.getIntegers().write(0, (Object)0);
        packetContainer.getChatComponents().write(0, (Object)WrappedChatComponent.fromText((String)this.getPlayerIdentifier()));
        ProtocolLibHook.sendServerPacket(this.player, packetContainer);
        packetContainer = new PacketContainer(PacketType.Play.Server.SCOREBOARD_DISPLAY_OBJECTIVE);
        packetContainer.getModifier().writeDefaults();
        packetContainer.getIntegers().write(0, (Object)1);
        packetContainer.getStrings().write(0, (Object)this.getPlayerIdentifier());
        ProtocolLibHook.sendServerPacket(this.player, packetContainer);
    }

    public void remove() {
        PacketContainer packetContainer = new PacketContainer(PacketType.Play.Server.SCOREBOARD_OBJECTIVE);
        packetContainer.getModifier().writeDefaults();
        packetContainer.getStrings().write(0, (Object)this.getPlayerIdentifier());
        packetContainer.getIntegers().write(0, (Object)1);
        ProtocolLibHook.sendServerPacket(this.player, packetContainer);
        this.scores.forEach((n, string) -> {
            PacketContainer packetContainer = new PacketContainer(PacketType.Play.Server.SCOREBOARD_TEAM);
            packetContainer.getModifier().writeDefaults();
            packetContainer.getStrings().write(0, (Object)this.getScoreIdentifier((int)n));
            packetContainer.getIntegers().write(0, (Object)1);
            ProtocolLibHook.sendServerPacket(this.player, packetContainer);
        });
    }

    public void clear() {
        this.scores.forEach((n, string) -> {
            String string2 = this.getScoreIdentifier((int)n);
            PacketContainer packetContainer = new PacketContainer(PacketType.Play.Server.SCOREBOARD_TEAM);
            packetContainer.getModifier().writeDefaults();
            packetContainer.getStrings().write(0, (Object)string2);
            packetContainer.getIntegers().write(0, (Object)1);
            ProtocolLibHook.sendServerPacket(this.player, packetContainer);
            packetContainer = new PacketContainer(PacketType.Play.Server.SCOREBOARD_SCORE);
            packetContainer.getModifier().writeDefaults();
            packetContainer.getStrings().write(0, (Object)string2);
            packetContainer.getScoreboardActions().write(0, (Object)EnumWrappers.ScoreboardAction.REMOVE);
            packetContainer.getStrings().write(1, (Object)this.getPlayerIdentifier());
            ProtocolLibHook.sendServerPacket(this.player, packetContainer);
        });
        this.scores.clear();
    }

    public void update() {
        String string2 = this.title;
        ArrayList<String> arrayList = new ArrayList<String>(this.lines);
        Arena arena = this.arenaPlayer.getArena();
        arrayList.replaceAll(string -> {
            if (EngineUtils.hasPlaceholderAPI()) {
                string = PlaceholderAPI.setPlaceholders((Player)this.player, (String)string);
            }
            string = (String)arena.replacePlaceholders().apply(string);
            string = (String)this.arenaPlayer.replacePlaceholders().apply(string);
            return string;
        });
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        int n2 = arrayList.size();
        for (String string3 : arrayList) {
            hashMap.put(n2--, string3);
        }
        PacketContainer packetContainer = new PacketContainer(PacketType.Play.Server.SCOREBOARD_OBJECTIVE);
        packetContainer.getModifier().writeDefaults();
        packetContainer.getStrings().write(0, (Object)this.getPlayerIdentifier());
        packetContainer.getIntegers().write(0, (Object)2);
        packetContainer.getChatComponents().write(0, (Object)WrappedChatComponent.fromLegacyText((String)string2));
        ProtocolLibHook.sendServerPacket(this.player, packetContainer);
        hashMap.forEach((n, string) -> {
            String string2 = this.getScoreIdentifier((int)n);
            PacketContainer packetContainer = new PacketContainer(PacketType.Play.Server.SCOREBOARD_TEAM);
            packetContainer.getModifier().writeDefaults();
            packetContainer.getStrings().write(0, (Object)string2);
            Optional optional = (Optional)packetContainer.getOptionalStructures().read(0);
            if (optional.isPresent()) {
                InternalStructure internalStructure = (InternalStructure)optional.get();
                internalStructure.getChatComponents().write(0, (Object)WrappedChatComponent.fromText((String)string2));
                internalStructure.getChatComponents().write(1, (Object)WrappedChatComponent.fromLegacyText((String)string));
                packetContainer.getOptionalStructures().write(0, Optional.of(internalStructure));
            }
            if (this.scores.containsKey(n)) {
                packetContainer.getIntegers().write(0, (Object)2);
                ProtocolLibHook.sendServerPacket(this.player, packetContainer);
                return;
            }
            packetContainer.getIntegers().write(0, (Object)0);
            packetContainer.getSpecificModifier(Collection.class).write(0, Collections.singletonList(string2));
            ProtocolLibHook.sendServerPacket(this.player, packetContainer);
            packetContainer = new PacketContainer(PacketType.Play.Server.SCOREBOARD_SCORE);
            packetContainer.getModifier().writeDefaults();
            packetContainer.getStrings().write(0, (Object)string2);
            packetContainer.getScoreboardActions().write(0, (Object)EnumWrappers.ScoreboardAction.CHANGE);
            packetContainer.getStrings().write(1, (Object)this.getPlayerIdentifier());
            packetContainer.getIntegers().write(0, n);
            ProtocolLibHook.sendServerPacket(this.player, packetContainer);
        });
        this.scores.entrySet().stream().filter(entry -> !hashMap.containsKey(entry.getKey())).forEach(entry -> {
            int n = (Integer)entry.getKey();
            String string = this.getScoreIdentifier(n);
            PacketContainer packetContainer = new PacketContainer(PacketType.Play.Server.SCOREBOARD_TEAM);
            packetContainer.getModifier().writeDefaults();
            packetContainer.getStrings().write(0, (Object)string);
            packetContainer.getIntegers().write(0, (Object)1);
            ProtocolLibHook.sendServerPacket(this.player, packetContainer);
            packetContainer = new PacketContainer(PacketType.Play.Server.SCOREBOARD_SCORE);
            packetContainer.getModifier().writeDefaults();
            packetContainer.getStrings().write(0, (Object)string);
            packetContainer.getScoreboardActions().write(0, (Object)EnumWrappers.ScoreboardAction.REMOVE);
            packetContainer.getStrings().write(1, (Object)this.getPlayerIdentifier());
            ProtocolLibHook.sendServerPacket(this.player, packetContainer);
        });
        this.scores.clear();
        this.scores.putAll(hashMap);
    }
}

