/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.arena.editor.game;

import java.util.Collection;
import java.util.Map;
import java.util.function.UnaryOperator;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.menu.impl.EditorMenu;
import su.nexmedia.engine.api.menu.impl.MenuViewer;
import su.nexmedia.engine.editor.EditorManager;
import su.nexmedia.engine.utils.CollectionsUtil;
import su.nexmedia.engine.utils.ItemUtil;
import su.nexmedia.engine.utils.StringUtil;
import su.nightexpress.ama.AMA;
import su.nightexpress.ama.arena.game.ArenaGameplayManager;
import su.nightexpress.ama.config.Config;
import su.nightexpress.ama.config.Lang;
import su.nightexpress.ama.editor.EditorLocales;

public class GameplayEditor
extends EditorMenu<AMA, ArenaGameplayManager> {
    private static final String TEXTURE_TIMER = "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZGJjYjIzMGE0MTBlOTNiN2Q0YjVjMjg5NjMxZDYxNGI5MDQ1Mzg0M2Q2ZWQwM2RhZjVlNDAxNWEyZmUxZjU2YiJ9fX0=";
    private static final String TEXTURE_ARROW_UP = "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMWFkNmM4MWY4OTlhNzg1ZWNmMjZiZTFkYzQ4ZWFlMmJjZmU3NzdhODYyMzkwZjU3ODVlOTViZDgzYmQxNGQifX19";
    private static final String TEXTURE_ARROW_DOWN = "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvODgyZmFmOWE1ODRjNGQ2NzZkNzMwYjIzZjg5NDJiYjk5N2ZhM2RhZDQ2ZDRmNjVlMjg4YzM5ZWI0NzFjZTcifX19";
    private static final String TEXTURE_GLOW_SQUID = "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNmFlMTQ2MWE1NGFhNTRjZjI4ZGQ2YWVhZGFjNzJjOGQ3YzY5MTM5ODFkZWUxM2YyZTMzNTE0MjU2YWQ0YjgyNiJ9fX0=";
    private static final String TEXTURE_BONE_BAG = "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYjQ1MTg0NTk0M2ZkMGMwN2Y2Mjk3MTFlMzQwMWE3MWEzMWNkMzcxY2MzY2IzNmYzZjk2MzdiMGU3NTljYzQ4YSJ9fX0=";
    private static final String TEXTURE_BARRIER = "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvM2VkMWFiYTczZjYzOWY0YmM0MmJkNDgxOTZjNzE1MTk3YmUyNzEyYzNiOTYyYzk3ZWJmOWU5ZWQ4ZWZhMDI1In19fQ==";
    private static final String TEXTURE_SPAWN_EGG = "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZjE3ODdiNjUyYWY5MTA0YjgzYzljOGUyNmUzNzM0NGUyZmU0Y2I1OWZkYWZiMDRlZmY0ZWRkZDlkN2E5OTk5NCJ9fX0=";
    private static final String TEXTURE_STEVE = "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvOGZhMDY1ZjA0MjkwZWNmNDMxZjlhYTkwMGFiNmVhMTdiYzM1NGY3MGE1OTZmMTgyNmJiMjM1OTJmODdkZGJhNyJ9fX0=";
    private static final String TEXTURE_HEART = "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMmM4ZmI2MzdkNmUxYTdiYThmYTk3ZWU5ZDI5MTVlODQzZThlYzc5MGQ4YjdiZjYwNDhiZTYyMWVlNGQ1OWZiYSJ9fX0=";
    private static final String TEXTURE_IRON_HELMET = "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZTVlYjBiZDg1YWFkZGYwZDI5ZWQwODJlYWMwM2ZjYWRlNDNkMGVlODAzYjBlODE2MmFkZDI4YTYzNzlmYjU0ZSJ9fX0=";

    public GameplayEditor(@NotNull ArenaGameplayManager arenaGameplayManager) {
        super((NexPlugin)arenaGameplayManager.plugin(), (Object)arenaGameplayManager, "Arena Gameplay Editor", 54);
        this.addReturn(new int[]{49}).setClick((menuViewer, inventoryClickEvent) -> arenaGameplayManager.getArenaConfig().getEditor().openNextTick(menuViewer, 1));
        this.addItem(Material.CLOCK, EditorLocales.GAMEPLAY_TIMELEFT, new int[]{9}).setClick((menuViewer, inventoryClickEvent) -> {
            if (inventoryClickEvent.getClick() == ClickType.DROP) {
                arenaGameplayManager.setTimeleft(-1);
                this.save(menuViewer);
                return;
            }
            this.handleInput(menuViewer, Lang.EDITOR_GENERIC_ENTER_SECONDS, inputWrapper -> {
                arenaGameplayManager.setTimeleft(inputWrapper.asInt(0));
                arenaGameplayManager.save();
                return true;
            });
        });
        this.addItem(ItemUtil.createCustomHead((String)TEXTURE_TIMER), EditorLocales.GAMEPLAY_LOBBY_COUNTDOWN, new int[]{10}).setClick((menuViewer, inventoryClickEvent) -> this.handleInput(menuViewer, Lang.EDITOR_GENERIC_ENTER_SECONDS, inputWrapper -> {
            arenaGameplayManager.setLobbyTime(inputWrapper.asInt());
            arenaGameplayManager.save();
            return true;
        }));
        this.addItem(Material.BELL, EditorLocales.GAMEPLAY_ANNOUNCEMENTS, new int[]{11}).setClick((menuViewer, inventoryClickEvent) -> {
            arenaGameplayManager.setAnnouncesEnabled(!arenaGameplayManager.isAnnouncesEnabled());
            this.save(menuViewer);
        });
        this.addItem(Material.OAK_SIGN, EditorLocales.GAMEPLAY_SCOREBOARD, new int[]{12}).setClick((menuViewer, inventoryClickEvent) -> {
            if (inventoryClickEvent.isRightClick()) {
                EditorManager.suggestValues((Player)menuViewer.getPlayer(), ((Map)Config.SCOREBOARDS.get()).keySet(), (boolean)true);
                this.handleInput(menuViewer, Lang.EDITOR_ARENA_GAMEPLAY_ENTER_SCOREBOARD_ID, inputWrapper -> {
                    arenaGameplayManager.setScoreboardId(inputWrapper.getTextRaw());
                    arenaGameplayManager.save();
                    return true;
                });
                return;
            }
            arenaGameplayManager.setScoreboardEnabled(!arenaGameplayManager.isScoreboardEnabled());
            this.save(menuViewer);
        });
        this.addItem(Material.ROTTEN_FLESH, EditorLocales.GAMEPLAY_HUNGER, new int[]{13}).setClick((menuViewer, inventoryClickEvent) -> {
            arenaGameplayManager.setHungerEnabled(!arenaGameplayManager.isHungerEnabled());
            this.save(menuViewer);
        });
        this.addItem(Material.APPLE, EditorLocales.GAMEPLAY_REGENERATION, new int[]{14}).setClick((menuViewer, inventoryClickEvent) -> {
            arenaGameplayManager.setRegenerationEnabled(!arenaGameplayManager.isRegenerationEnabled());
            this.save(menuViewer);
        });
        this.addItem(ItemUtil.createCustomHead((String)TEXTURE_ARROW_UP), EditorLocales.GAMEPLAY_ITEM_SETTINGS, new int[]{15}).setClick((menuViewer, inventoryClickEvent) -> {
            if (inventoryClickEvent.isShiftClick()) {
                if (inventoryClickEvent.isLeftClick()) {
                    arenaGameplayManager.setItemDurabilityEnabled(!arenaGameplayManager.isItemDurabilityEnabled());
                }
            } else if (inventoryClickEvent.isLeftClick()) {
                arenaGameplayManager.setItemDropEnabled(!arenaGameplayManager.isItemDropEnabled());
            } else if (inventoryClickEvent.isRightClick()) {
                arenaGameplayManager.setItemPickupEnabled(!arenaGameplayManager.isItemPickupEnabled());
            }
            this.save(menuViewer);
        });
        this.addItem(ItemUtil.createCustomHead((String)TEXTURE_GLOW_SQUID), EditorLocales.GAMEPLAY_MOB_HIGHLIGHT, new int[]{16}).setClick((menuViewer, inventoryClickEvent) -> {
            if (inventoryClickEvent.isShiftClick()) {
                if (inventoryClickEvent.isLeftClick()) {
                    arenaGameplayManager.setMobHighlightColor((ChatColor)CollectionsUtil.next((Enum)arenaGameplayManager.getMobHighlightColor(), ChatColor::isColor));
                }
            } else {
                if (inventoryClickEvent.isLeftClick()) {
                    arenaGameplayManager.setMobHighlightEnabled(!arenaGameplayManager.isMobHighlightEnabled());
                }
                if (inventoryClickEvent.isRightClick()) {
                    this.handleInput(menuViewer, Lang.EDITOR_GENERIC_ENTER_PERCENT, inputWrapper -> {
                        arenaGameplayManager.setMobHighlightAmount(inputWrapper.asDouble(0.0));
                        arenaGameplayManager.save();
                        return true;
                    });
                    return;
                }
            }
            this.save(menuViewer);
        });
        this.addItem(ItemUtil.createCustomHead((String)TEXTURE_BONE_BAG), EditorLocales.GAMEPLAY_MOB_LOOT, new int[]{17}).setClick((menuViewer, inventoryClickEvent) -> {
            if (inventoryClickEvent.isLeftClick()) {
                arenaGameplayManager.setMobDropLootEnabled(!arenaGameplayManager.isMobDropLootEnabled());
            } else if (inventoryClickEvent.isRightClick()) {
                arenaGameplayManager.setMobDropExpEnabled(!arenaGameplayManager.isMobDropExpEnabled());
            }
            this.save(menuViewer);
        });
        this.addItem(ItemUtil.createCustomHead((String)TEXTURE_BARRIER), EditorLocales.GAMEPLAY_BANNED_ITEMS, new int[]{18}).setClick((menuViewer, inventoryClickEvent) -> {
            if (inventoryClickEvent.getClick() == ClickType.DROP) {
                arenaGameplayManager.getBannedItems().clear();
                this.save(menuViewer);
                return;
            }
            this.handleInput(menuViewer, Lang.EDITOR_ARENA_GAMEPLAY_ENTER_BANNED_ITEMS, inputWrapper -> {
                Material material = Material.getMaterial((String)inputWrapper.getTextRaw().toUpperCase());
                if (material != null) {
                    arenaGameplayManager.getBannedItems().add(material);
                }
                arenaGameplayManager.save();
                return true;
            });
        });
        this.addItem(ItemUtil.createCustomHead((String)TEXTURE_SPAWN_EGG), EditorLocales.GAMEPLAY_ALLOWED_SPAWN_REASONS, new int[]{19}).setClick((menuViewer, inventoryClickEvent) -> {
            if (inventoryClickEvent.getClick() == ClickType.DROP) {
                arenaGameplayManager.getAllowedSpawnReasons().clear();
                this.save(menuViewer);
                return;
            }
            EditorManager.suggestValues((Player)menuViewer.getPlayer(), (Collection)CollectionsUtil.getEnumsList(CreatureSpawnEvent.SpawnReason.class), (boolean)true);
            this.handleInput(menuViewer, Lang.EDITOR_ARENA_GAMEPLAY_ENTER_ALLOWED_SPAWN_REASON, inputWrapper -> {
                StringUtil.getEnum((String)inputWrapper.getTextRaw(), CreatureSpawnEvent.SpawnReason.class).ifPresent(spawnReason -> {
                    arenaGameplayManager.getAllowedSpawnReasons().add((CreatureSpawnEvent.SpawnReason)spawnReason);
                    arenaGameplayManager.save();
                });
                return true;
            });
        });
        this.addItem(ItemUtil.createCustomHead((String)TEXTURE_STEVE), EditorLocales.GAMEPLAY_PLAYER_AMOUNT, new int[]{20}).setClick((menuViewer, inventoryClickEvent) -> this.handleInput(menuViewer.getPlayer(), ((AMA)this.plugin).getMessage(Lang.EDITOR_GENERIC_ENTER_NUMBER), inputWrapper -> {
            if (inventoryClickEvent.isLeftClick()) {
                arenaGameplayManager.setPlayerMinAmount(inputWrapper.asInt(1));
            } else {
                arenaGameplayManager.setPlayerMaxAmount(inputWrapper.asInt(1));
            }
            arenaGameplayManager.save();
            return true;
        }));
        this.addItem(ItemUtil.createCustomHead((String)TEXTURE_HEART), EditorLocales.GAMEPLAY_PLAYER_LIFES, new int[]{21}).setClick((menuViewer, inventoryClickEvent) -> {
            if (inventoryClickEvent.isLeftClick()) {
                this.handleInput(menuViewer, Lang.EDITOR_GENERIC_ENTER_NUMBER, inputWrapper -> {
                    arenaGameplayManager.setPlayerLivesAmount(inputWrapper.asInt(1));
                    arenaGameplayManager.save();
                    return true;
                });
            } else if (inventoryClickEvent.isRightClick()) {
                this.handleInput(menuViewer, Lang.EDITOR_GENERIC_ENTER_SECONDS, inputWrapper -> {
                    arenaGameplayManager.setPlayerReviveTime(inputWrapper.asAnyInt(-1));
                    arenaGameplayManager.save();
                    return true;
                });
            }
        });
        this.addItem(Material.SADDLE, EditorLocales.GAMEPLAY_KEEP_INVENTORY, new int[]{22}).setClick((menuViewer, inventoryClickEvent) -> {
            arenaGameplayManager.setKeepInventory(!arenaGameplayManager.isKeepInventory());
            this.save(menuViewer);
        });
        this.addItem(Material.ENDER_EYE, EditorLocales.GAMEPLAY_SPECTATE, new int[]{23}).setClick((menuViewer, inventoryClickEvent) -> {
            arenaGameplayManager.setSpectateEnabled(!arenaGameplayManager.isSpectateEnabled());
            this.save(menuViewer);
        });
        this.addItem(Material.COMMAND_BLOCK, EditorLocales.GAMEPLAY_COMMANDS, new int[]{24}).setClick((menuViewer, inventoryClickEvent) -> {
            if (inventoryClickEvent.isRightClick()) {
                this.handleInput(menuViewer, Lang.EDITOR_GENERIC_ENTER_COMMAND, inputWrapper -> {
                    arenaGameplayManager.getPlayerCommandsAllowed().add(inputWrapper.getTextRaw());
                    arenaGameplayManager.save();
                    return true;
                });
                return;
            }
            if (inventoryClickEvent.isLeftClick()) {
                arenaGameplayManager.setPlayerCommandsEnabled(!arenaGameplayManager.isPlayerCommandsEnabled());
            } else if (inventoryClickEvent.getClick() == ClickType.DROP) {
                arenaGameplayManager.getPlayerCommandsAllowed().clear();
            }
            this.save(menuViewer);
        });
        this.addItem(ItemUtil.createCustomHead((String)TEXTURE_IRON_HELMET), EditorLocales.GAMEPLAY_KITS, new int[]{25}).setClick((menuViewer, inventoryClickEvent) -> {
            if (inventoryClickEvent.isRightClick()) {
                EditorManager.suggestValues((Player)menuViewer.getPlayer(), ((AMA)this.plugin).getKitManager().getKitIds(), (boolean)true);
                this.handleInput(menuViewer, Lang.EDITOR_KIT_ENTER_ID, inputWrapper -> {
                    arenaGameplayManager.getKitsAllowed().add(inputWrapper.getTextRaw().toLowerCase());
                    arenaGameplayManager.save();
                    return true;
                });
                return;
            }
            if (inventoryClickEvent.isLeftClick()) {
                arenaGameplayManager.setKitsEnabled(!arenaGameplayManager.isKitsEnabled());
            } else if (inventoryClickEvent.getClick() == ClickType.DROP) {
                arenaGameplayManager.getKitsAllowed().clear();
            }
            this.save(menuViewer);
        });
        this.addItem(Material.ARMOR_STAND, EditorLocales.GAMEPLAY_KIT_LIMITS, new int[]{26}).setClick((menuViewer, inventoryClickEvent) -> {
            if (inventoryClickEvent.isLeftClick()) {
                EditorManager.suggestValues((Player)menuViewer.getPlayer(), ((AMA)this.plugin).getKitManager().getKitIds(), (boolean)true);
                this.handleInput(menuViewer, Lang.EDITOR_ARENA_GAMEPLAY_ENTER_KIT_LIMIT, inputWrapper -> {
                    String[] stringArray = inputWrapper.getTextRaw().split(" ");
                    int n = stringArray.length >= 2 ? StringUtil.getInteger((String)stringArray[0], (int)-1) : -1;
                    String string = stringArray[1];
                    arenaGameplayManager.getKitsLimits().put(string.toLowerCase(), n);
                    arenaGameplayManager.save();
                    return true;
                });
            } else if (inventoryClickEvent.getClick() == ClickType.DROP) {
                arenaGameplayManager.getKitsLimits().clear();
                this.save(menuViewer);
            }
        });
        this.addItem(Material.BONE, EditorLocales.GAMEPLAY_PETS, new int[]{27}).setClick((menuViewer, inventoryClickEvent) -> {
            arenaGameplayManager.setPetsAllowed(!arenaGameplayManager.isPetsAllowed());
            this.save(menuViewer);
        });
        this.addItem(Material.DIAMOND_SWORD, EditorLocales.GAMEPLAY_MCMMO, new int[]{28}).setClick((menuViewer, inventoryClickEvent) -> {
            arenaGameplayManager.setMcmmoAllowed(!arenaGameplayManager.isMcmmoAllowed());
            this.save(menuViewer);
        });
        this.getItems().forEach(menuItem -> menuItem.getOptions().addDisplayModifier((menuViewer, itemStack) -> ItemUtil.replace((ItemStack)itemStack, (UnaryOperator)arenaGameplayManager.replacePlaceholders())));
    }

    private void save(@NotNull MenuViewer menuViewer) {
        ((ArenaGameplayManager)this.object).save();
        this.openNextTick(menuViewer, menuViewer.getPage());
    }
}

