/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.arena.editor.reward;

import java.util.ArrayList;
import java.util.List;
import java.util.function.UnaryOperator;
import java.util.stream.IntStream;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.menu.AutoPaged;
import su.nexmedia.engine.api.menu.click.ItemClick;
import su.nexmedia.engine.api.menu.impl.EditorMenu;
import su.nexmedia.engine.api.menu.impl.MenuOptions;
import su.nexmedia.engine.api.menu.impl.MenuViewer;
import su.nexmedia.engine.editor.EditorManager;
import su.nexmedia.engine.utils.ItemUtil;
import su.nexmedia.engine.utils.StringUtil;
import su.nightexpress.ama.AMA;
import su.nightexpress.ama.arena.reward.ArenaReward;
import su.nightexpress.ama.arena.reward.ArenaRewardManager;
import su.nightexpress.ama.config.Lang;
import su.nightexpress.ama.editor.EditorLocales;

public class RewardListEditor
extends EditorMenu<AMA, ArenaRewardManager>
implements AutoPaged<ArenaReward> {
    public RewardListEditor(@NotNull ArenaRewardManager arenaRewardManager) {
        super((NexPlugin)arenaRewardManager.plugin(), (Object)arenaRewardManager, "Arena Reward Editor", 45);
        this.addReturn(new int[]{39}).setClick((menuViewer, inventoryClickEvent) -> arenaRewardManager.getArenaConfig().getEditor().openNextTick(menuViewer, 1));
        this.addNextPage(new int[]{44});
        this.addPreviousPage(new int[]{36});
        this.addCreation(EditorLocales.REWARD_CREATE, new int[]{41}).setClick((menuViewer, inventoryClickEvent) -> this.handleInput(menuViewer, Lang.EDITOR_REWARD_ENTER_ID, inputWrapper -> {
            if (!arenaRewardManager.createReward(StringUtil.lowerCaseUnderscore((String)inputWrapper.getTextRaw()))) {
                EditorManager.error((Player)menuViewer.getPlayer(), (String)((AMA)this.plugin).getMessage(Lang.EDITOR_REWARD_ERROR_EXIST).getLocalized());
                return false;
            }
            arenaRewardManager.save();
            return true;
        }));
        this.addItem(Material.ENDER_CHEST, EditorLocales.REWARDS_RETAIN, new int[]{40}).setClick((menuViewer, inventoryClickEvent) -> {
            if (inventoryClickEvent.isLeftClick()) {
                arenaRewardManager.setRetainOnDeath(!arenaRewardManager.isRetainOnDeath());
            } else if (inventoryClickEvent.isRightClick()) {
                arenaRewardManager.setRetainOnLeave(!arenaRewardManager.isRetainOnLeave());
            }
            arenaRewardManager.save();
            this.openNextTick(menuViewer, menuViewer.getPage());
        });
        this.getItems().forEach(menuItem -> menuItem.getOptions().addDisplayModifier((menuViewer, itemStack) -> ItemUtil.replace((ItemStack)itemStack, (UnaryOperator)arenaRewardManager.replacePlaceholders())));
    }

    public void onPrepare(@NotNull MenuViewer menuViewer, @NotNull MenuOptions menuOptions) {
        super.onPrepare(menuViewer, menuOptions);
        this.getItemsForPage(menuViewer).forEach(arg_0 -> ((RewardListEditor)this).addItem(arg_0));
    }

    public int[] getObjectSlots() {
        return IntStream.range(0, 36).toArray();
    }

    @NotNull
    public List<ArenaReward> getObjects(@NotNull Player player) {
        return new ArrayList<ArenaReward>(((ArenaRewardManager)this.object).getRewards());
    }

    @NotNull
    public ItemStack getObjectStack(@NotNull Player player, @NotNull ArenaReward arenaReward) {
        ItemStack itemStack = new ItemStack(Material.GOLD_INGOT);
        ItemUtil.mapMeta((ItemStack)itemStack, itemMeta -> {
            itemMeta.setDisplayName(EditorLocales.REWARD_OBJECT.getLocalizedName());
            itemMeta.setLore(EditorLocales.REWARD_OBJECT.getLocalizedLore());
            itemMeta.addItemFlags(ItemFlag.values());
            ItemUtil.replace((ItemMeta)itemMeta, (UnaryOperator)arenaReward.replacePlaceholders());
        });
        return itemStack;
    }

    @NotNull
    public ItemClick getObjectClick(@NotNull ArenaReward arenaReward) {
        return (menuViewer, inventoryClickEvent) -> {
            if (inventoryClickEvent.isShiftClick() && inventoryClickEvent.isRightClick()) {
                ((ArenaRewardManager)this.object).getRewardsMap().remove(arenaReward.getId());
                arenaReward.clear();
                ((ArenaRewardManager)this.object).save();
                this.openNextTick(menuViewer, menuViewer.getPage());
                return;
            }
            arenaReward.getEditor().openNextTick(menuViewer, 1);
        };
    }
}

