/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.arena.editor.reward;

import java.util.Objects;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.menu.impl.EditorMenu;
import su.nexmedia.engine.api.menu.impl.Menu;
import su.nexmedia.engine.api.menu.impl.MenuViewer;
import su.nexmedia.engine.utils.ItemUtil;
import su.nightexpress.ama.AMA;
import su.nightexpress.ama.arena.reward.ArenaReward;
import su.nightexpress.ama.config.Lang;
import su.nightexpress.ama.editor.EditorLocales;

public class RewardSettingsEditor
extends EditorMenu<AMA, ArenaReward> {
    public RewardSettingsEditor(@NotNull ArenaReward arenaReward) {
        super((NexPlugin)arenaReward.plugin(), (Object)arenaReward, "Arena Reward Editor", 36);
        this.addReturn(new int[]{31}).setClick((menuViewer, inventoryClickEvent) -> arenaReward.getArenaConfig().getRewardManager().getEditor().openNextTick(menuViewer, 1));
        this.addItem(Material.NAME_TAG, EditorLocales.REWARD_NAME, new int[]{10}).setClick((menuViewer, inventoryClickEvent) -> this.handleInput(menuViewer, Lang.EDITOR_GENERIC_ENTER_NAME, inputWrapper -> {
            arenaReward.setName(inputWrapper.getText());
            arenaReward.getArenaConfig().getRewardManager().save();
            return true;
        }));
        this.addItem(Material.IRON_DOOR, EditorLocales.REWARD_LATE, new int[]{12}).setClick((menuViewer, inventoryClickEvent) -> {
            arenaReward.setLate(!arenaReward.isLate());
            this.save(menuViewer);
        });
        this.addItem(Material.COMMAND_BLOCK, EditorLocales.REWARD_COMMANDS, new int[]{14}).setClick((menuViewer, inventoryClickEvent) -> {
            if (inventoryClickEvent.isRightClick()) {
                arenaReward.getCommands().clear();
                this.save(menuViewer);
                return;
            }
            this.handleInput(menuViewer, Lang.EDITOR_GENERIC_ENTER_COMMAND, inputWrapper -> {
                arenaReward.getCommands().add(inputWrapper.getText());
                arenaReward.getArenaConfig().getRewardManager().save();
                return true;
            });
        });
        this.addItem(Material.CHEST_MINECART, EditorLocales.REWARD_ITEMS, new int[]{16}).setClick((menuViewer, inventoryClickEvent) -> new ContentEditor(arenaReward).openNextTick(menuViewer, 1));
        this.getItems().forEach(menuItem -> menuItem.getOptions().addDisplayModifier((menuViewer, itemStack) -> ItemUtil.replace((ItemStack)itemStack, (UnaryOperator)arenaReward.replacePlaceholders())));
    }

    private void save(@NotNull MenuViewer menuViewer) {
        ((ArenaReward)this.object).getArenaConfig().getRewardManager().save();
        this.openNextTick(menuViewer, menuViewer.getPage());
    }

    private static class ContentEditor
    extends Menu<AMA> {
        private final ArenaReward reward;

        public ContentEditor(@NotNull ArenaReward arenaReward) {
            super((NexPlugin)arenaReward.plugin(), "Reward Items", 27);
            this.reward = arenaReward;
        }

        public void onReady(@NotNull MenuViewer menuViewer, @NotNull Inventory inventory) {
            super.onReady(menuViewer, inventory);
            inventory.setContents(this.reward.getItems().toArray(new ItemStack[this.getOptions().getSize()]));
        }

        public void onClick(@NotNull MenuViewer menuViewer, @Nullable ItemStack itemStack, @NotNull Menu.SlotType slotType, int n, @NotNull InventoryClickEvent inventoryClickEvent) {
            super.onClick(menuViewer, itemStack, slotType, n, inventoryClickEvent);
            inventoryClickEvent.setCancelled(false);
        }

        public void onClose(@NotNull MenuViewer menuViewer, @NotNull InventoryCloseEvent inventoryCloseEvent) {
            Inventory inventory = inventoryCloseEvent.getInventory();
            this.reward.setItems(Stream.of(inventory.getContents()).filter(Objects::nonNull).toList());
            this.reward.getArenaConfig().getRewardManager().save();
            this.reward.getEditor().openNextTick(menuViewer, 1);
            super.onClose(menuViewer, inventoryCloseEvent);
        }

        public boolean isPersistent() {
            return false;
        }
    }
}

