/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.arena.editor.shop;

import java.util.ArrayList;
import java.util.List;
import java.util.function.UnaryOperator;
import java.util.stream.IntStream;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.menu.AutoPaged;
import su.nexmedia.engine.api.menu.click.ItemClick;
import su.nexmedia.engine.api.menu.impl.EditorMenu;
import su.nexmedia.engine.api.menu.impl.MenuOptions;
import su.nexmedia.engine.api.menu.impl.MenuViewer;
import su.nexmedia.engine.editor.EditorManager;
import su.nexmedia.engine.utils.ItemUtil;
import su.nexmedia.engine.utils.StringUtil;
import su.nightexpress.ama.AMA;
import su.nightexpress.ama.arena.shop.ShopManager;
import su.nightexpress.ama.arena.shop.impl.ShopCategory;
import su.nightexpress.ama.config.Lang;
import su.nightexpress.ama.editor.EditorLocales;

public class ShopCategoryListEditor
extends EditorMenu<AMA, ShopManager>
implements AutoPaged<ShopCategory> {
    public ShopCategoryListEditor(@NotNull ShopManager shopManager) {
        super((NexPlugin)shopManager.plugin(), (Object)shopManager, "Arena Shop Editor", 45);
        this.addReturn(new int[]{39}).setClick((menuViewer, inventoryClickEvent) -> shopManager.getEditor().openNextTick(menuViewer, 1));
        this.addNextPage(new int[]{44});
        this.addPreviousPage(new int[]{36});
        this.addCreation(EditorLocales.SHOP_CATEGORY_CREATE, new int[]{41}).setClick((menuViewer, inventoryClickEvent) -> this.handleInput(menuViewer, Lang.EDITOR_ARENA_SHOP_ENTER_CATEGORY_ID, inputWrapper -> {
            if (!shopManager.createCategory(StringUtil.lowerCaseUnderscore((String)inputWrapper.getTextRaw()))) {
                EditorManager.error((Player)menuViewer.getPlayer(), (String)((AMA)this.plugin).getMessage(Lang.EDITOR_ARENA_SHOP_ERROR_CATEGORY_EXISTS).getLocalized());
                return false;
            }
            shopManager.save();
            return true;
        }));
    }

    public void onPrepare(@NotNull MenuViewer menuViewer, @NotNull MenuOptions menuOptions) {
        super.onPrepare(menuViewer, menuOptions);
        this.getItemsForPage(menuViewer).forEach(arg_0 -> ((ShopCategoryListEditor)this).addItem(arg_0));
    }

    public int[] getObjectSlots() {
        return IntStream.range(0, 36).toArray();
    }

    @NotNull
    public List<ShopCategory> getObjects(@NotNull Player player) {
        return new ArrayList<ShopCategory>(((ShopManager)this.object).getCategories());
    }

    @NotNull
    public ItemStack getObjectStack(@NotNull Player player, @NotNull ShopCategory shopCategory) {
        ItemStack itemStack = new ItemStack(shopCategory.getIcon());
        ItemUtil.mapMeta((ItemStack)itemStack, itemMeta -> {
            itemMeta.setDisplayName(EditorLocales.SHOP_CATEGORY_OBJECT.getLocalizedName());
            itemMeta.setLore(EditorLocales.SHOP_CATEGORY_OBJECT.getLocalizedLore());
            itemMeta.addItemFlags(ItemFlag.values());
            ItemUtil.replace((ItemMeta)itemMeta, (UnaryOperator)shopCategory.replacePlaceholders());
        });
        return itemStack;
    }

    @NotNull
    public ItemClick getObjectClick(@NotNull ShopCategory shopCategory) {
        return (menuViewer, inventoryClickEvent) -> {
            if (inventoryClickEvent.isShiftClick() && inventoryClickEvent.isRightClick()) {
                shopCategory.clear();
                ((ShopManager)this.object).getCategoryMap().remove(shopCategory.getId());
                ((ShopManager)this.object).save();
                this.openNextTick(menuViewer, menuViewer.getPage());
                return;
            }
            shopCategory.getEditor().openNextTick(menuViewer, 1);
        };
    }
}

