/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.arena.editor.shop;

import java.util.ArrayList;
import java.util.List;
import java.util.function.UnaryOperator;
import java.util.stream.IntStream;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.menu.AutoPaged;
import su.nexmedia.engine.api.menu.click.ItemClick;
import su.nexmedia.engine.api.menu.impl.EditorMenu;
import su.nexmedia.engine.api.menu.impl.MenuOptions;
import su.nexmedia.engine.api.menu.impl.MenuViewer;
import su.nexmedia.engine.editor.EditorManager;
import su.nexmedia.engine.utils.ItemUtil;
import su.nexmedia.engine.utils.StringUtil;
import su.nightexpress.ama.AMA;
import su.nightexpress.ama.arena.shop.impl.ShopCategory;
import su.nightexpress.ama.arena.shop.impl.ShopProduct;
import su.nightexpress.ama.config.Lang;
import su.nightexpress.ama.editor.EditorLocales;

public class ShopProductListEditor
extends EditorMenu<AMA, ShopCategory>
implements AutoPaged<ShopProduct> {
    public ShopProductListEditor(@NotNull ShopCategory shopCategory) {
        super((NexPlugin)shopCategory.plugin(), (Object)shopCategory, "Arena Shop Editor", 45);
        this.addReturn(new int[]{39}).setClick((menuViewer, inventoryClickEvent) -> shopCategory.getEditor().openNextTick(menuViewer, 1));
        this.addNextPage(new int[]{44});
        this.addPreviousPage(new int[]{36});
        this.addCreation(EditorLocales.SHOP_PRODUCT_CREATE, new int[]{41}).setClick((menuViewer, inventoryClickEvent) -> this.handleInput(menuViewer, Lang.EDITOR_ARENA_SHOP_ENTER_PRODUCT_ID, inputWrapper -> {
            if (!shopCategory.createProduct(StringUtil.lowerCaseUnderscore((String)inputWrapper.getTextRaw()))) {
                EditorManager.error((Player)menuViewer.getPlayer(), (String)((AMA)this.plugin).getMessage(Lang.EDITOR_ARENA_SHOP_ERROR_PRODUCT_EXISTS).getLocalized());
                return false;
            }
            shopCategory.getShopManager().save();
            return true;
        }));
    }

    public void onPrepare(@NotNull MenuViewer menuViewer, @NotNull MenuOptions menuOptions) {
        super.onPrepare(menuViewer, menuOptions);
        this.getItemsForPage(menuViewer).forEach(arg_0 -> ((ShopProductListEditor)this).addItem(arg_0));
    }

    public int[] getObjectSlots() {
        return IntStream.range(0, 36).toArray();
    }

    @NotNull
    public List<ShopProduct> getObjects(@NotNull Player player) {
        return new ArrayList<ShopProduct>(((ShopCategory)this.object).getProducts());
    }

    @NotNull
    public ItemStack getObjectStack(@NotNull Player player, @NotNull ShopProduct shopProduct) {
        ItemStack itemStack = new ItemStack(shopProduct.getIcon());
        ItemUtil.mapMeta((ItemStack)itemStack, itemMeta -> {
            itemMeta.setDisplayName(EditorLocales.SHOP_PRODUCT_OBJECT.getLocalizedName());
            itemMeta.setLore(EditorLocales.SHOP_PRODUCT_OBJECT.getLocalizedLore());
            itemMeta.addItemFlags(ItemFlag.values());
            ItemUtil.replace((ItemMeta)itemMeta, (UnaryOperator)shopProduct.replacePlaceholders());
        });
        return itemStack;
    }

    @NotNull
    public ItemClick getObjectClick(@NotNull ShopProduct shopProduct) {
        return (menuViewer, inventoryClickEvent) -> {
            if (inventoryClickEvent.isShiftClick() && inventoryClickEvent.isRightClick()) {
                shopProduct.clear();
                ((ShopCategory)this.object).getProducts().remove(shopProduct);
                ((ShopCategory)this.object).getShopManager().save();
                this.openNextTick(menuViewer, menuViewer.getPage());
                return;
            }
            shopProduct.getEditor().openNextTick(menuViewer, 1);
        };
    }
}

