/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.arena.editor.shop;

import java.util.Objects;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.menu.impl.EditorMenu;
import su.nexmedia.engine.api.menu.impl.Menu;
import su.nexmedia.engine.api.menu.impl.MenuViewer;
import su.nexmedia.engine.editor.EditorManager;
import su.nexmedia.engine.utils.ItemUtil;
import su.nightexpress.ama.AMA;
import su.nightexpress.ama.api.currency.Currency;
import su.nightexpress.ama.arena.shop.impl.ShopProduct;
import su.nightexpress.ama.config.Lang;
import su.nightexpress.ama.editor.EditorLocales;

public class ShopProductSettingsEditor
extends EditorMenu<AMA, ShopProduct> {
    public ShopProductSettingsEditor(@NotNull ShopProduct shopProduct) {
        super((NexPlugin)shopProduct.getShopCategory().plugin(), (Object)shopProduct, "Arena Shop Editor", 45);
        this.addReturn(new int[]{40}).setClick((menuViewer, inventoryClickEvent) -> shopProduct.getShopCategory().getEditor().getProductsEditor().openNextTick(menuViewer, 1));
        this.addItem(Material.NAME_TAG, EditorLocales.SHOP_PRODUCT_NAME, new int[]{2}).setClick((menuViewer, inventoryClickEvent) -> this.handleInput(menuViewer, Lang.EDITOR_GENERIC_ENTER_NAME, inputWrapper -> {
            shopProduct.setName(inputWrapper.getText());
            shopProduct.getShopCategory().getShopManager().save();
            return true;
        }));
        this.addItem(Material.ITEM_FRAME, EditorLocales.SHOP_PRODUCT_ICON, new int[]{4}).setClick((menuViewer, inventoryClickEvent) -> {
            ItemStack itemStack = inventoryClickEvent.getCursor();
            if (itemStack == null || itemStack.getType().isAir()) {
                return;
            }
            shopProduct.setIcon(itemStack);
            inventoryClickEvent.getView().setCursor(null);
            this.save(menuViewer);
        }).getOptions().addDisplayModifier((menuViewer, itemStack) -> itemStack.setType(shopProduct.getIcon().getType()));
        this.addItem(Material.MAP, EditorLocales.SHOP_PRODUCT_DESCRIPTION, new int[]{6}).setClick((menuViewer, inventoryClickEvent) -> {
            if (inventoryClickEvent.isRightClick()) {
                shopProduct.getDescription().clear();
                this.save(menuViewer);
                return;
            }
            this.handleInput(menuViewer, Lang.EDITOR_GENERIC_ENTER_DESCRIPTION, inputWrapper -> {
                shopProduct.getDescription().add(inputWrapper.getText());
                shopProduct.getShopCategory().getShopManager().save();
                return true;
            });
        });
        this.addItem(Material.GOLD_NUGGET, EditorLocales.SHOP_PRODUCT_PRICE, new int[]{11}).setClick((menuViewer, inventoryClickEvent) -> this.handleInput(menuViewer, Lang.EDITOR_ARENA_SHOP_ENTER_PRODUCT_PRICE, inputWrapper -> {
            shopProduct.setPrice(inputWrapper.asDouble());
            shopProduct.getShopCategory().getShopManager().save();
            return true;
        }));
        this.addItem(Material.EMERALD, EditorLocales.SHOP_PRODUCT_CURRENCY, new int[]{13}).setClick((menuViewer, inventoryClickEvent) -> {
            EditorManager.suggestValues((Player)menuViewer.getPlayer(), ((AMA)this.plugin).getCurrencyManager().getCurrencyIds(), (boolean)true);
            this.handleInput(menuViewer, Lang.EDITOR_GENERIC_ENTER_CURRENCY, inputWrapper -> {
                Currency currency = ((AMA)this.plugin).getCurrencyManager().getCurrency(inputWrapper.getTextRaw());
                if (currency == null) {
                    EditorManager.error((Player)menuViewer.getPlayer(), (String)((AMA)this.plugin).getMessage(Lang.ERROR_CURRENCY_INVALID).getLocalized());
                    return false;
                }
                shopProduct.setCurrency(currency);
                shopProduct.getShopCategory().getShopManager().save();
                return true;
            });
        });
        this.addItem(Material.ARMOR_STAND, EditorLocales.SHOP_PRODUCT_REQUIRED_KITS, new int[]{15}).setClick((menuViewer, inventoryClickEvent) -> {
            if (inventoryClickEvent.isRightClick()) {
                shopProduct.getAllowedKits().clear();
                this.save(menuViewer);
                return;
            }
            EditorManager.suggestValues((Player)menuViewer.getPlayer(), ((AMA)this.plugin).getKitManager().getKitIds(), (boolean)true);
            this.handleInput(menuViewer, Lang.EDITOR_KIT_ENTER_ID, inputWrapper -> {
                shopProduct.getAllowedKits().add(inputWrapper.getTextRaw().toLowerCase());
                shopProduct.getShopCategory().getShopManager().save();
                return true;
            });
        });
        this.addItem(Material.COMMAND_BLOCK, EditorLocales.SHOP_PRODUCT_COMMANDS, new int[]{21}).setClick((menuViewer, inventoryClickEvent) -> {
            if (inventoryClickEvent.isRightClick()) {
                shopProduct.getCommands().clear();
                this.save(menuViewer);
                return;
            }
            this.handleInput(menuViewer, Lang.EDITOR_GENERIC_ENTER_COMMAND, inputWrapper -> {
                shopProduct.getCommands().add(inputWrapper.getText());
                shopProduct.getShopCategory().getShopManager().save();
                return true;
            });
        });
        this.addItem(Material.CHEST_MINECART, EditorLocales.SHOP_PRODUCT_ITEMS, new int[]{23}).setClick((menuViewer, inventoryClickEvent) -> new ProductItems(shopProduct).openNextTick(menuViewer, 1));
        this.getItems().forEach(menuItem -> menuItem.getOptions().addDisplayModifier((menuViewer, itemStack) -> ItemUtil.replace((ItemStack)itemStack, (UnaryOperator)shopProduct.replacePlaceholders())));
    }

    private void save(@NotNull MenuViewer menuViewer) {
        ((ShopProduct)this.object).getShopCategory().getShopManager().save();
        this.openNextTick(menuViewer, menuViewer.getPage());
    }

    public void onClick(@NotNull MenuViewer menuViewer, @Nullable ItemStack itemStack, @NotNull Menu.SlotType slotType, int n, @NotNull InventoryClickEvent inventoryClickEvent) {
        super.onClick(menuViewer, itemStack, slotType, n, inventoryClickEvent);
        if (slotType == Menu.SlotType.PLAYER || slotType == Menu.SlotType.PLAYER_EMPTY) {
            inventoryClickEvent.setCancelled(false);
        }
    }

    private static class ProductItems
    extends Menu<AMA> {
        private final ShopProduct shopProduct;

        public ProductItems(@NotNull ShopProduct shopProduct) {
            super((NexPlugin)shopProduct.getShopCategory().getShopManager().plugin(), "Product Items", 27);
            this.shopProduct = shopProduct;
        }

        public boolean isPersistent() {
            return false;
        }

        public void onReady(@NotNull MenuViewer menuViewer, @NotNull Inventory inventory) {
            super.onReady(menuViewer, inventory);
            inventory.setContents(this.shopProduct.getItems().toArray(new ItemStack[this.getOptions().getSize()]));
        }

        public void onClick(@NotNull MenuViewer menuViewer, @Nullable ItemStack itemStack, @NotNull Menu.SlotType slotType, int n, @NotNull InventoryClickEvent inventoryClickEvent) {
            super.onClick(menuViewer, itemStack, slotType, n, inventoryClickEvent);
            inventoryClickEvent.setCancelled(false);
        }

        public void onClose(@NotNull MenuViewer menuViewer, @NotNull InventoryCloseEvent inventoryCloseEvent) {
            Inventory inventory = inventoryCloseEvent.getInventory();
            this.shopProduct.setItems(Stream.of(inventory.getContents()).filter(Objects::nonNull).toList());
            this.shopProduct.getShopCategory().getShopManager().save();
            this.shopProduct.getEditor().openNextTick(menuViewer, 1);
            super.onClose(menuViewer, inventoryCloseEvent);
        }
    }
}

