/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.arena.editor.spot;

import java.util.ArrayList;
import java.util.List;
import java.util.function.UnaryOperator;
import java.util.stream.IntStream;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.menu.AutoPaged;
import su.nexmedia.engine.api.menu.click.ItemClick;
import su.nexmedia.engine.api.menu.impl.EditorMenu;
import su.nexmedia.engine.api.menu.impl.MenuOptions;
import su.nexmedia.engine.api.menu.impl.MenuViewer;
import su.nexmedia.engine.editor.EditorManager;
import su.nexmedia.engine.utils.ItemUtil;
import su.nexmedia.engine.utils.StringUtil;
import su.nightexpress.ama.AMA;
import su.nightexpress.ama.arena.spot.ArenaSpot;
import su.nightexpress.ama.arena.spot.ArenaSpotState;
import su.nightexpress.ama.config.Lang;
import su.nightexpress.ama.editor.EditorLocales;

public class SpotStatesEditor
extends EditorMenu<AMA, ArenaSpot>
implements AutoPaged<ArenaSpotState> {
    public SpotStatesEditor(@NotNull ArenaSpot arenaSpot) {
        super((NexPlugin)((AMA)arenaSpot.plugin()), (Object)arenaSpot, "Arena Spot Editor", 45);
        this.addReturn(new int[]{39}).setClick((menuViewer, inventoryClickEvent) -> arenaSpot.getEditor().openNextTick(menuViewer, 1));
        this.addNextPage(new int[]{44});
        this.addPreviousPage(new int[]{36});
        this.addCreation(EditorLocales.SPOT_STATE_CREATE, new int[]{41}).setClick((menuViewer, inventoryClickEvent) -> this.handleInput(menuViewer, Lang.EDITOR_SPOT_STATE_ENTER_ID, inputWrapper -> {
            String string = StringUtil.lowerCaseUnderscore((String)inputWrapper.getTextRaw());
            if (arenaSpot.getState(string) != null) {
                EditorManager.error((Player)menuViewer.getPlayer(), (String)((AMA)this.plugin).getMessage(Lang.EDITOR_SPOT_STATE_ERROR_EXISTS).getLocalized());
                return false;
            }
            ArenaSpotState arenaSpotState = new ArenaSpotState(arenaSpot, string, new ArrayList<String>());
            arenaSpot.getStates().put(arenaSpotState.getId(), arenaSpotState);
            arenaSpot.save();
            return true;
        }));
    }

    public void onPrepare(@NotNull MenuViewer menuViewer, @NotNull MenuOptions menuOptions) {
        super.onPrepare(menuViewer, menuOptions);
        this.getItemsForPage(menuViewer).forEach(arg_0 -> ((SpotStatesEditor)this).addItem(arg_0));
    }

    public int[] getObjectSlots() {
        return IntStream.range(0, 36).toArray();
    }

    @NotNull
    public List<ArenaSpotState> getObjects(@NotNull Player player) {
        return new ArrayList<ArenaSpotState>(((ArenaSpot)this.object).getStates().values());
    }

    @NotNull
    public ItemStack getObjectStack(@NotNull Player player, @NotNull ArenaSpotState arenaSpotState) {
        ItemStack itemStack = new ItemStack(Material.ITEM_FRAME);
        ItemUtil.mapMeta((ItemStack)itemStack, itemMeta -> {
            itemMeta.setDisplayName(EditorLocales.SPOT_STATE_OBJECT.getLocalizedName());
            itemMeta.setLore(EditorLocales.SPOT_STATE_OBJECT.getLocalizedLore());
            itemMeta.addItemFlags(ItemFlag.values());
            ItemUtil.replace((ItemMeta)itemMeta, (UnaryOperator)arenaSpotState.replacePlaceholders());
        });
        return itemStack;
    }

    @NotNull
    public ItemClick getObjectClick(@NotNull ArenaSpotState arenaSpotState) {
        return (menuViewer, inventoryClickEvent) -> {
            if (inventoryClickEvent.isShiftClick()) {
                if (inventoryClickEvent.isRightClick()) {
                    ((ArenaSpot)this.object).getStates().remove(arenaSpotState.getId());
                    ((ArenaSpot)this.object).save();
                    this.openNextTick(menuViewer, menuViewer.getPage());
                }
                return;
            }
            menuViewer.getPlayer().closeInventory();
            ((AMA)this.plugin).getArenaSetupManager().getSpotStateSetupManager().startSetup(menuViewer.getPlayer(), arenaSpotState);
        };
    }
}

