/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.arena.editor.supply;

import java.util.Objects;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.editor.InputHandler;
import su.nexmedia.engine.api.editor.InputWrapper;
import su.nexmedia.engine.api.manager.EventListener;
import su.nexmedia.engine.api.menu.impl.EditorMenu;
import su.nexmedia.engine.api.menu.impl.Menu;
import su.nexmedia.engine.api.menu.impl.MenuViewer;
import su.nexmedia.engine.editor.EditorManager;
import su.nexmedia.engine.utils.ItemUtil;
import su.nightexpress.ama.AMA;
import su.nightexpress.ama.arena.supply.ArenaSupplyChest;
import su.nightexpress.ama.config.Lang;
import su.nightexpress.ama.editor.EditorLocales;

public class SupplyChestSettingsEditor
extends EditorMenu<AMA, ArenaSupplyChest>
implements EventListener {
    public SupplyChestSettingsEditor(@NotNull ArenaSupplyChest arenaSupplyChest) {
        super((NexPlugin)arenaSupplyChest.plugin(), (Object)arenaSupplyChest, "Arena Supply Editor", 36);
        this.addReturn(new int[]{31}).setClick((menuViewer, inventoryClickEvent) -> arenaSupplyChest.getArenaConfig().getSupplyManager().getEditor().openNextTick(menuViewer, 1));
        this.addItem(Material.REPEATER, EditorLocales.SUPPLY_CHEST_REFILL_AMOUNT, new int[]{11}).setClick((menuViewer, inventoryClickEvent) -> this.handleInput(menuViewer, Lang.EDITOR_GENERIC_ENTER_NUMBER, inputWrapper -> {
            if (inventoryClickEvent.isLeftClick()) {
                arenaSupplyChest.setMinItems(inputWrapper.asInt());
            } else {
                arenaSupplyChest.setMaxItems(inputWrapper.asInt());
            }
            arenaSupplyChest.getArenaConfig().getSupplyManager().save();
            return true;
        }));
        this.addItem(Material.COMPASS, EditorLocales.SUPPLY_CHEST_LOCATION, new int[]{13}).setClick((menuViewer, inventoryClickEvent) -> this.handleInput(menuViewer, Lang.EDITOR_SUPPLY_CHEST_SET_CONTAINER, inputWrapper -> inputWrapper.asInt() == 13));
        this.addItem(Material.CHEST_MINECART, EditorLocales.SUPPLY_CHEST_ITEMS, new int[]{15}).setClick((menuViewer, inventoryClickEvent) -> new ContainerGUI(arenaSupplyChest).openNextTick(menuViewer, 1));
        this.getItems().forEach(menuItem -> menuItem.getOptions().addDisplayModifier((menuViewer, itemStack) -> ItemUtil.replace((ItemStack)itemStack, (UnaryOperator)arenaSupplyChest.replacePlaceholders())));
        this.registerListeners();
    }

    public void clear() {
        super.clear();
        this.unregisterListeners();
    }

    public void registerListeners() {
        ((AMA)this.plugin).getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onBlockClick(PlayerInteractEvent playerInteractEvent) {
        Player player = playerInteractEvent.getPlayer();
        InputHandler inputHandler = EditorManager.getInputHandler((Player)player);
        if (inputHandler == null) {
            return;
        }
        Block block = playerInteractEvent.getClickedBlock();
        if (block == null) {
            return;
        }
        if (inputHandler.handle(new InputWrapper("13"))) {
            playerInteractEvent.setUseInteractedBlock(Event.Result.DENY);
            playerInteractEvent.setUseItemInHand(Event.Result.DENY);
            if (((ArenaSupplyChest)this.object).getArenaConfig().getSupplyManager().getChest(block) != null) {
                return;
            }
            ((ArenaSupplyChest)this.object).setLocation(block.getLocation());
            ((ArenaSupplyChest)this.object).getArenaConfig().getSupplyManager().save();
            EditorManager.endEdit((Player)player);
        }
    }

    static class ContainerGUI
    extends Menu<AMA> {
        private final ArenaSupplyChest container;

        public ContainerGUI(@NotNull ArenaSupplyChest arenaSupplyChest) {
            super((NexPlugin)arenaSupplyChest.plugin(), "Supply Chest Content", 27);
            this.container = arenaSupplyChest;
        }

        public void onReady(@NotNull MenuViewer menuViewer, @NotNull Inventory inventory) {
            super.onReady(menuViewer, inventory);
            inventory.setContents(this.container.getItems().toArray(new ItemStack[this.getOptions().getSize()]));
        }

        public void onClick(@NotNull MenuViewer menuViewer, @Nullable ItemStack itemStack, @NotNull Menu.SlotType slotType, int n, @NotNull InventoryClickEvent inventoryClickEvent) {
            super.onClick(menuViewer, itemStack, slotType, n, inventoryClickEvent);
            inventoryClickEvent.setCancelled(false);
        }

        public void onClose(@NotNull MenuViewer menuViewer, @NotNull InventoryCloseEvent inventoryCloseEvent) {
            super.onClose(menuViewer, inventoryCloseEvent);
            Inventory inventory = inventoryCloseEvent.getInventory();
            this.container.setItems(Stream.of(inventory.getContents()).filter(Objects::nonNull).toList());
            this.container.getArenaConfig().getSupplyManager().save();
            this.container.getEditor().openNextTick(menuViewer, 1);
        }

        public boolean isPersistent() {
            return false;
        }
    }
}

