/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.arena.editor.wave;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.UnaryOperator;
import java.util.stream.IntStream;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.menu.AutoPaged;
import su.nexmedia.engine.api.menu.click.ItemClick;
import su.nexmedia.engine.api.menu.impl.EditorMenu;
import su.nexmedia.engine.api.menu.impl.MenuOptions;
import su.nexmedia.engine.api.menu.impl.MenuViewer;
import su.nexmedia.engine.editor.EditorManager;
import su.nexmedia.engine.utils.ItemUtil;
import su.nexmedia.engine.utils.StringUtil;
import su.nightexpress.ama.AMA;
import su.nightexpress.ama.arena.wave.ArenaWave;
import su.nightexpress.ama.arena.wave.ArenaWaveManager;
import su.nightexpress.ama.arena.wave.ArenaWaveMob;
import su.nightexpress.ama.config.Lang;
import su.nightexpress.ama.editor.EditorLocales;

public class WavesListEditor
extends EditorMenu<AMA, ArenaWaveManager>
implements AutoPaged<ArenaWave> {
    public WavesListEditor(@NotNull ArenaWaveManager arenaWaveManager) {
        super((NexPlugin)arenaWaveManager.plugin(), (Object)arenaWaveManager, "Arena Wave Editor", 45);
        this.addReturn(new int[]{39}).setClick((menuViewer, inventoryClickEvent) -> arenaWaveManager.getEditor().openNextTick(menuViewer, 1));
        this.addNextPage(new int[]{44});
        this.addPreviousPage(new int[]{36});
        this.addCreation(EditorLocales.WAVES_WAVE_CREATE, new int[]{41}).setClick((menuViewer, inventoryClickEvent) -> this.handleInput(menuViewer, Lang.EDITOR_ARENA_WAVES_ENTER_WAVE_ID, inputWrapper -> {
            String string = StringUtil.lowerCaseUnderscore((String)inputWrapper.getTextRaw());
            if (arenaWaveManager.getWave(string) != null) {
                EditorManager.error((Player)menuViewer.getPlayer(), (String)((AMA)this.plugin).getMessage(Lang.EDITOR_ARENA_WAVES_ERROR_WAVE_EXISTS).getLocalized());
                return false;
            }
            ArenaWave arenaWave = new ArenaWave(arenaWaveManager.getArenaConfig(), string, new HashSet<ArenaWaveMob>());
            arenaWaveManager.getWaves().put(string, arenaWave);
            arenaWaveManager.save();
            return true;
        }));
    }

    public void onPrepare(@NotNull MenuViewer menuViewer, @NotNull MenuOptions menuOptions) {
        super.onPrepare(menuViewer, menuOptions);
        this.getItemsForPage(menuViewer).forEach(arg_0 -> ((WavesListEditor)this).addItem(arg_0));
    }

    public int[] getObjectSlots() {
        return IntStream.range(0, 36).toArray();
    }

    @NotNull
    public List<ArenaWave> getObjects(@NotNull Player player) {
        return new ArrayList<ArenaWave>(((ArenaWaveManager)this.object).getWaves().values());
    }

    @NotNull
    public ItemStack getObjectStack(@NotNull Player player, @NotNull ArenaWave arenaWave) {
        ItemStack itemStack = new ItemStack(Material.BLAZE_POWDER);
        ItemUtil.mapMeta((ItemStack)itemStack, itemMeta -> {
            itemMeta.setDisplayName(EditorLocales.WAVES_WAVE_OBJECT.getLocalizedName());
            itemMeta.setLore(EditorLocales.WAVES_WAVE_OBJECT.getLocalizedLore());
            itemMeta.addItemFlags(ItemFlag.values());
            ItemUtil.replace((ItemMeta)itemMeta, (UnaryOperator)arenaWave.replacePlaceholders());
        });
        return itemStack;
    }

    @NotNull
    public ItemClick getObjectClick(@NotNull ArenaWave arenaWave) {
        return (menuViewer, inventoryClickEvent) -> {
            if (inventoryClickEvent.isShiftClick() && inventoryClickEvent.isRightClick()) {
                arenaWave.clear();
                ((ArenaWaveManager)this.object).getWaves().remove(arenaWave.getId());
                ((ArenaWaveManager)this.object).save();
                this.openNextTick(menuViewer, menuViewer.getPage());
                return;
            }
            arenaWave.getEditor().openNextTick(menuViewer, 1);
        };
    }
}

