/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.arena.impl;

import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nexmedia.engine.api.placeholder.Placeholder;
import su.nexmedia.engine.api.placeholder.PlaceholderMap;
import su.nexmedia.engine.lang.LangManager;
import su.nexmedia.engine.utils.EngineUtils;
import su.nexmedia.engine.utils.EntityUtil;
import su.nexmedia.engine.utils.TimeUtil;
import su.nightexpress.ama.AMA;
import su.nightexpress.ama.api.event.ArenaPlayerReadyEvent;
import su.nightexpress.ama.api.type.GameState;
import su.nightexpress.ama.arena.board.ArenaBoard;
import su.nightexpress.ama.arena.board.ArenaBoardConfig;
import su.nightexpress.ama.arena.impl.Arena;
import su.nightexpress.ama.arena.region.ArenaRegion;
import su.nightexpress.ama.arena.reward.ArenaReward;
import su.nightexpress.ama.arena.util.ArenaUtils;
import su.nightexpress.ama.config.Config;
import su.nightexpress.ama.config.Lang;
import su.nightexpress.ama.data.impl.ArenaUser;
import su.nightexpress.ama.hook.external.SunLightHook;
import su.nightexpress.ama.kit.Kit;
import su.nightexpress.ama.stats.object.StatType;

public final class ArenaPlayer
implements Placeholder {
    private static final Map<UUID, ArenaPlayer> PLAYER_MAP = new HashMap<UUID, ArenaPlayer>();
    private static final DateTimeFormatter FORMAT_STREAK = DateTimeFormatter.ofPattern("ss");
    private final AMA plugin;
    private final Player player;
    private final Arena arena;
    private final Map<StatType, Integer> stats;
    private final List<ArenaReward> rewards;
    private final PlaceholderMap placeholderMap;
    private GameState state;
    private ArenaBoard board;
    private Kit kit;
    private int lifes;
    private int reviveTime;
    private int score;
    private int killStreak;
    private long killStreakDecay;
    private boolean dead;
    private boolean ghost;
    private boolean transfer;

    @Nullable
    public static ArenaPlayer getPlayer(@NotNull Player player) {
        if (EntityUtil.isNPC((Entity)player)) {
            return null;
        }
        return ArenaPlayer.getPlayer(player.getUniqueId());
    }

    @Nullable
    public static ArenaPlayer getPlayer(@NotNull UUID uUID) {
        return PLAYER_MAP.get(uUID);
    }

    @NotNull
    public static Collection<ArenaPlayer> getPlayers() {
        return PLAYER_MAP.values();
    }

    public static boolean isPlaying(@NotNull Player player) {
        return ArenaPlayer.getPlayer(player) != null;
    }

    @NotNull
    public static ArenaPlayer create(@NotNull Player player, @NotNull Arena arena) {
        if (ArenaPlayer.isPlaying(player)) {
            throw new IllegalStateException("This player is already playing other arena!");
        }
        ArenaPlayer arenaPlayer = new ArenaPlayer(player, arena);
        PLAYER_MAP.put(player.getUniqueId(), arenaPlayer);
        return arenaPlayer;
    }

    public static void remove(@NotNull Player player) {
        PLAYER_MAP.remove(player.getUniqueId());
    }

    private ArenaPlayer(@NotNull Player player, @NotNull Arena arena) {
        this.plugin = arena.plugin();
        this.stats = new HashMap<StatType, Integer>();
        this.rewards = new ArrayList<ArenaReward>();
        this.player = player;
        this.arena = arena;
        this.state = GameState.WAITING;
        this.setReal();
        this.setKit(null);
        this.setLifes(arena.getConfig().getGameplayManager().getPlayerLivesAmount());
        this.setScore(0);
        this.setKillStreak(0);
        this.setDead(false);
        this.placeholderMap = new PlaceholderMap().add("%player_name%", this.getPlayer().getName()).add("%player_lives%", () -> String.valueOf(this.getLifes())).add("%player_streak%", () -> String.valueOf(this.getKillStreak())).add("%player_streak_decay%", () -> TimeUtil.getLocalTimeOf((long)this.getKillStreakDecay()).format(FORMAT_STREAK)).add("%player_score%", () -> String.valueOf(this.getScore())).add("%player_kills%", () -> String.valueOf(this.getStats(StatType.MOB_KILLS))).add("%player_is_ready%", () -> LangManager.getBoolean((boolean)this.isReady())).add("%player_kit_name%", () -> this.getKit() == null ? "-" : this.getKit().getName());
    }

    @NotNull
    public PlaceholderMap getPlaceholders() {
        return this.placeholderMap;
    }

    public boolean leaveArena() {
        return this.getArena().leaveArena(this);
    }

    public void tick() {
        if (!this.isDead() && !this.isGhost()) {
            if (!this.getArena().isAwaitingNewRound()) {
                this.setKillStreakDecay(this.getKillStreakDecay() - 1000L);
                if (this.getKillStreakDecay() == 0L) {
                    this.setKillStreak(0);
                    this.getStats().remove((Object)StatType.BEST_KILL_STREAK);
                }
            }
            if (this.kit != null) {
                this.kit.applyPotionEffects(this.player);
            }
        }
        if (this.board != null) {
            this.board.update();
        }
        if (this.isDead()) {
            if (this.isGhost()) {
                this.plugin.getMessage(Lang.ARENA_GAME_STATUS_DEAD_NO_LIFES).send((CommandSender)this.getPlayer());
            } else {
                this.plugin.getMessage(Lang.ARENA_GAME_STATUS_DEAD_WITH_LIFES).send((CommandSender)this.getPlayer());
            }
            if (this.isAutoRevive()) {
                if (this.getReviveTime() == 0) {
                    this.revive();
                    this.setReviveTime(-1);
                } else {
                    this.setReviveTime(this.getReviveTime() - 1);
                }
            }
        } else if (this.isGhost()) {
            this.plugin.getMessage(Lang.ARENA_GAME_STATUS_SPECTATE).send((CommandSender)this.getPlayer());
        }
    }

    public void onDeath() {
        this.setDead(true);
        this.takeLive();
        if (this.isOutOfLifes()) {
            this.setReviveTime(-1);
            if (!this.getArena().getConfig().getRewardManager().isRetainOnDeath()) {
                this.getRewards().clear();
            }
            if (!this.getArena().getAlivePlayers().isEmpty()) {
                this.plugin.getMessage(Lang.ARENA_GAME_DEATH_NO_LIFES).replace(this.replacePlaceholders()).send((CommandSender)this.getPlayer());
            }
            this.setGhost();
            if (!this.getArena().getConfig().getWaveManager().isInfiniteWaves()) {
                this.addStats(StatType.GAMES_LOST, 1);
            }
            ArenaUtils.removeMobBossBars(this.getPlayer());
        } else {
            this.setReviveTime(this.getArena().getConfig().getGameplayManager().getPlayerReviveTime());
            if (!this.getArena().getAlivePlayers().isEmpty()) {
                this.plugin.getMessage(Lang.ARENA_GAME_DEATH_WITH_LIFES).replace(this.replacePlaceholders()).send((CommandSender)this.getPlayer());
            }
        }
        this.getPlayer().setGameMode(GameMode.SPECTATOR);
        this.addStats(StatType.DEATHS, 1);
        this.setKillStreak(0);
        this.setKillStreakDecay(0L);
        this.getArena().broadcast(this.plugin.getMessage(Lang.ARENA_GAME_INFO_PLAYER_DEATH).replace(this.getArena().replacePlaceholders()).replace(this.replacePlaceholders()));
    }

    public void revive() {
        if (!this.isDead() || this.isGhost()) {
            return;
        }
        ArenaRegion arenaRegion = this.getArena().getConfig().getRegionManager().getFirstUnlocked();
        if (arenaRegion != null && arenaRegion.getSpawnLocation() != null) {
            this.getPlayer().teleport(arenaRegion.getSpawnLocation());
        }
        this.setDead(false);
        this.getPlayer().setGameMode(GameMode.SURVIVAL);
        if (this.getLifes() == 1) {
            this.plugin.getMessage(Lang.ARENA_GAME_REVIVE_NO_LIFES).replace(this.replacePlaceholders()).send((CommandSender)this.getPlayer());
        } else {
            this.plugin.getMessage(Lang.ARENA_GAME_REVIVE_WITH_LIFES).replace(this.replacePlaceholders()).send((CommandSender)this.getPlayer());
        }
    }

    public boolean isAutoRevive() {
        return this.isDead() && !this.isGhost() && this.getReviveTime() >= 0;
    }

    public boolean isOutOfLifes() {
        return this.getLifes() < 1;
    }

    @NotNull
    public Arena getArena() {
        return this.arena;
    }

    @NotNull
    public GameState getState() {
        return this.state;
    }

    public void setState(@NotNull GameState gameState) {
        this.state = gameState;
        if (this.getState() == GameState.READY || this.getState() == GameState.WAITING) {
            ArenaPlayerReadyEvent arenaPlayerReadyEvent = new ArenaPlayerReadyEvent(this.getArena(), this);
            this.plugin.getPluginManager().callEvent((Event)arenaPlayerReadyEvent);
            this.getArena().broadcast(this.plugin.getMessage(this.isReady() ? Lang.ARENA_GAME_INFO_PLAYER_READY : Lang.ARENA_GAME_INFO_PLAYER_NOT_READY).replace(this.replacePlaceholders()));
        }
    }

    @Nullable
    public Kit getKit() {
        return this.kit;
    }

    public void setKit(@Nullable Kit kit) {
        this.kit = kit;
    }

    @NotNull
    public List<ArenaReward> getRewards() {
        return this.rewards;
    }

    @NotNull
    public Player getPlayer() {
        return this.player;
    }

    public int getReviveTime() {
        return this.reviveTime;
    }

    public void setReviveTime(int n) {
        this.reviveTime = n;
    }

    public int getLifes() {
        return this.lifes;
    }

    public void setLifes(int n) {
        this.lifes = Math.max(0, n);
    }

    public void takeLive() {
        this.setLifes(this.getLifes() - 1);
    }

    public boolean isDead() {
        return this.dead;
    }

    public void setDead(boolean bl) {
        this.dead = bl;
    }

    public boolean isGhost() {
        return this.ghost;
    }

    public boolean isReal() {
        return !this.isGhost();
    }

    public void setGhost() {
        this.ghost = true;
    }

    public void setReal() {
        this.ghost = false;
    }

    public boolean isTransfer() {
        return this.transfer;
    }

    public void setTransfer(boolean bl) {
        this.transfer = bl;
    }

    public boolean isReady() {
        return this.getState() == GameState.READY;
    }

    public boolean isInGame() {
        return this.getState() == GameState.INGAME;
    }

    public void addBoard() {
        if (!this.arena.getConfig().getGameplayManager().isScoreboardEnabled()) {
            return;
        }
        ArenaBoardConfig arenaBoardConfig = (ArenaBoardConfig)((Map)Config.SCOREBOARDS.get()).get(this.getArena().getConfig().getGameplayManager().getScoreboardId());
        if (arenaBoardConfig == null) {
            return;
        }
        if (EngineUtils.hasPlugin((String)"SunLight")) {
            SunLightHook.disableBoard(this.getPlayer());
        }
        this.board = new ArenaBoard(this, arenaBoardConfig);
        this.board.create();
    }

    public void removeBoard() {
        if (this.board != null) {
            this.board.remove();
            this.board = null;
        }
    }

    @Nullable
    public ArenaRegion getRegion() {
        Location location = this.getPlayer().getLocation();
        return this.getArena().getConfig().getRegionManager().getRegion(location);
    }

    public int getScore() {
        return this.score;
    }

    public void setScore(int n) {
        this.score = Math.max(0, n);
        this.getArena().updateGameScore();
    }

    public void addScore(int n) {
        this.setScore(this.getScore() + n);
    }

    public int getKillStreak() {
        return this.killStreak;
    }

    public void setKillStreak(int n) {
        this.killStreak = n;
    }

    public long getKillStreakDecay() {
        return this.killStreakDecay;
    }

    public void setKillStreakDecay(long l) {
        this.killStreakDecay = Math.max(0L, l);
    }

    @NotNull
    public Map<StatType, Integer> getStats() {
        return this.stats;
    }

    public int getStats(@NotNull StatType statType) {
        return this.stats.getOrDefault((Object)statType, 0);
    }

    public void addStats(@NotNull StatType statType, int n) {
        this.stats.put(statType, n + this.getStats(statType));
    }

    public void saveStats() {
        String string = this.getArena().getId();
        Player player = this.getPlayer();
        ArenaUser arenaUser = (ArenaUser)this.getArena().plugin().getUserManager().getUserData(player);
        Map<StatType, Integer> map = this.getStats();
        Map<StatType, Integer> map2 = arenaUser.getStats(string);
        map.forEach((statType, n3) -> map2.merge((StatType)((Object)statType), (Integer)n3, (n, n2) -> {
            if (statType == StatType.WAVES_PASSED || statType == StatType.BEST_KILL_STREAK) {
                return Math.max(n, n2);
            }
            return n + n2;
        }));
    }
}

