/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.arena.listener;

import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemBreakEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerItemDamageEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.permissions.Permission;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.manager.AbstractListener;
import su.nexmedia.engine.utils.ArrayUtil;
import su.nexmedia.engine.utils.StringUtil;
import su.nightexpress.ama.AMA;
import su.nightexpress.ama.Perms;
import su.nightexpress.ama.api.event.ArenaGameGenericEvent;
import su.nightexpress.ama.api.event.ArenaMobDeathEvent;
import su.nightexpress.ama.api.event.ArenaPlayerDeathEvent;
import su.nightexpress.ama.api.type.GameState;
import su.nightexpress.ama.arena.ArenaManager;
import su.nightexpress.ama.arena.impl.Arena;
import su.nightexpress.ama.arena.impl.ArenaPlayer;
import su.nightexpress.ama.arena.region.ArenaRegion;
import su.nightexpress.ama.arena.util.ArenaUtils;
import su.nightexpress.ama.arena.util.LobbyItem;
import su.nightexpress.ama.config.Lang;
import su.nightexpress.ama.mob.MobManager;
import su.nightexpress.ama.mob.config.MobConfig;
import su.nightexpress.ama.mob.config.MobsConfig;
import su.nightexpress.ama.mob.kill.MobKillReward;
import su.nightexpress.ama.mob.kill.MobKillStreak;
import su.nightexpress.ama.stats.object.StatType;

public class ArenaGameplayListener
extends AbstractListener<AMA> {
    private final ArenaManager manager;

    public ArenaGameplayListener(@NotNull ArenaManager arenaManager) {
        super((NexPlugin)((AMA)arenaManager.plugin()));
        this.manager = arenaManager;
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onArenaGameEvent(ArenaGameGenericEvent arenaGameGenericEvent) {
        arenaGameGenericEvent.getArena().onArenaGameEvent(arenaGameGenericEvent);
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onGamePlayerItemDurability(PlayerItemDamageEvent playerItemDamageEvent) {
        Player player = playerItemDamageEvent.getPlayer();
        ArenaPlayer arenaPlayer = ArenaPlayer.getPlayer(player);
        if (arenaPlayer == null) {
            return;
        }
        Arena arena = arenaPlayer.getArena();
        if (!arena.getConfig().getGameplayManager().isItemDurabilityEnabled()) {
            playerItemDamageEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onGamePlayerItemDrop(PlayerDropItemEvent playerDropItemEvent) {
        Player player = playerDropItemEvent.getPlayer();
        ArenaPlayer arenaPlayer = ArenaPlayer.getPlayer(player);
        if (arenaPlayer == null) {
            return;
        }
        Arena arena = arenaPlayer.getArena();
        if (arena.getConfig().getGameplayManager().isKitsEnabled() && arenaPlayer.getState() != GameState.INGAME) {
            playerDropItemEvent.setCancelled(true);
            return;
        }
        if (!arena.getConfig().getGameplayManager().isItemDropEnabled()) {
            playerDropItemEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onGamePlayerRegen(EntityRegainHealthEvent entityRegainHealthEvent) {
        if (entityRegainHealthEvent.getRegainReason() != EntityRegainHealthEvent.RegainReason.SATIATED) {
            return;
        }
        Object object = entityRegainHealthEvent.getEntity();
        if (!(object instanceof Player)) {
            return;
        }
        Player player = (Player)object;
        object = ArenaPlayer.getPlayer(player);
        if (object == null) {
            return;
        }
        Arena arena = ((ArenaPlayer)object).getArena();
        if (!arena.getConfig().getGameplayManager().isRegenerationEnabled()) {
            entityRegainHealthEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onGamePlayerHunger(FoodLevelChangeEvent foodLevelChangeEvent) {
        Object object = foodLevelChangeEvent.getEntity();
        if (!(object instanceof Player)) {
            return;
        }
        Player player = (Player)object;
        object = ArenaPlayer.getPlayer(player);
        if (object == null) {
            return;
        }
        Arena arena = ((ArenaPlayer)object).getArena();
        if (!arena.getConfig().getGameplayManager().isHungerEnabled()) {
            foodLevelChangeEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onGamePlayerCmd(PlayerCommandPreprocessEvent playerCommandPreprocessEvent) {
        Player player = playerCommandPreprocessEvent.getPlayer();
        ArenaPlayer arenaPlayer = ArenaPlayer.getPlayer(player);
        if (arenaPlayer == null) {
            return;
        }
        if (player.hasPermission((Permission)Perms.BYPASS_ARENA_GAME_COMMANDS)) {
            return;
        }
        Arena arena = arenaPlayer.getArena();
        if (arena.getConfig().getGameplayManager().isPlayerCommandsEnabled()) {
            return;
        }
        String string = StringUtil.extractCommandName((String)playerCommandPreprocessEvent.getMessage());
        if (ArrayUtil.contains((Object[])((AMA)this.plugin).getLabels(), (Object)string)) {
            return;
        }
        if (arena.getConfig().getGameplayManager().getPlayerCommandsAllowed().contains(string)) {
            return;
        }
        playerCommandPreprocessEvent.setCancelled(true);
        player.closeInventory();
        ((AMA)this.plugin).getMessage(Lang.Arena_Game_Restrict_Commands).send((CommandSender)player);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onGamePlayerRegionMove(PlayerMoveEvent playerMoveEvent) {
        Location location = playerMoveEvent.getTo();
        if (location == null) {
            return;
        }
        Location location2 = playerMoveEvent.getFrom();
        Player player = playerMoveEvent.getPlayer();
        ArenaPlayer arenaPlayer = ArenaPlayer.getPlayer(player);
        if (arenaPlayer == null) {
            return;
        }
        if (arenaPlayer.isReal() ? location.getX() == location2.getX() && location.getZ() == location2.getZ() : arenaPlayer.isGhost() && location.getX() == location2.getX() && location.getZ() == location2.getZ() && location.getY() == location2.getY()) {
            return;
        }
        Arena arena = arenaPlayer.getArena();
        ArenaRegion arenaRegion = arena.getConfig().getRegionManager().getRegion(location);
        if (arenaPlayer.isGhost() && arenaRegion == null) {
            playerMoveEvent.setCancelled(true);
            return;
        }
        if (arenaRegion == null || !arenaRegion.isActive() || arenaRegion.isUnlocked()) {
            return;
        }
        arenaRegion.getCuboid().ifPresent(arenaCuboid -> {
            if (arenaCuboid.contains(location) && !arenaCuboid.contains(location2)) {
                playerMoveEvent.setCancelled(true);
            }
        });
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onGamePlayerDeathRealSpawn(PlayerRespawnEvent playerRespawnEvent) {
        Player player = playerRespawnEvent.getPlayer();
        ArenaPlayer arenaPlayer = ArenaPlayer.getPlayer(player);
        if (arenaPlayer == null) {
            return;
        }
        arenaPlayer.onDeath();
        playerRespawnEvent.setRespawnLocation(player.getLocation());
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onGamePlayerDeathReal(PlayerDeathEvent playerDeathEvent) {
        Player player = playerDeathEvent.getEntity();
        ArenaPlayer arenaPlayer = ArenaPlayer.getPlayer(player);
        if (arenaPlayer == null) {
            return;
        }
        Arena arena = arenaPlayer.getArena();
        ArenaPlayerDeathEvent arenaPlayerDeathEvent = new ArenaPlayerDeathEvent(arena, arenaPlayer);
        ((AMA)this.plugin).getPluginManager().callEvent((Event)arenaPlayerDeathEvent);
        if (arena.getConfig().getGameplayManager().isKeepInventory()) {
            playerDeathEvent.setKeepInventory(true);
            playerDeathEvent.getDrops().clear();
        }
        playerDeathEvent.setDroppedExp(0);
        playerDeathEvent.setKeepLevel(true);
        ((AMA)this.plugin).runTask(bukkitTask -> player.spigot().respawn());
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onMobDeath(EntityDeathEvent entityDeathEvent) {
        ArenaPlayer arenaPlayer;
        LivingEntity livingEntity = entityDeathEvent.getEntity();
        Arena arena = ((AMA)this.plugin).getMobManager().getEntityArena((Entity)livingEntity);
        if (arena == null) {
            return;
        }
        if (!arena.getConfig().getGameplayManager().isMobDropLootEnabled()) {
            entityDeathEvent.getDrops().clear();
        }
        if (!arena.getConfig().getGameplayManager().isMobDropExpEnabled()) {
            entityDeathEvent.setDroppedExp(0);
        }
        String string = MobManager.getMobId(livingEntity);
        MobConfig mobConfig = ((AMA)this.plugin).getMobManager().getEntityMobConfig(livingEntity);
        if (mobConfig != null && mobConfig.isBarEnabled()) {
            ArenaUtils.removeMobBossBar(livingEntity);
        }
        ArenaMobDeathEvent arenaMobDeathEvent = new ArenaMobDeathEvent(arena, livingEntity, string);
        Player player = livingEntity.getKiller();
        ArenaPlayer arenaPlayer2 = arenaPlayer = player != null ? ArenaPlayer.getPlayer(player) : null;
        if (player != null && arenaPlayer != null) {
            arenaMobDeathEvent.setKiller(arenaPlayer);
            int n = arenaPlayer.getKillStreak() + 1;
            MobKillReward mobKillReward = MobManager.getMobKillReward(livingEntity);
            MobKillStreak mobKillStreak = MobManager.getMobKillStreak(n);
            if (mobKillStreak != null) {
                mobKillStreak.execute(player);
            }
            arenaPlayer.setKillStreak(n);
            if (n > 0) {
                arenaPlayer.setKillStreakDecay((long)((Integer)MobsConfig.KILL_STREAK_DECAY.get()).intValue() * 1000L);
            }
            arenaPlayer.addStats(StatType.BEST_KILL_STREAK, 1);
            arenaPlayer.addStats(StatType.MOB_KILLS, 1);
            if (mobKillReward != null) {
                mobKillReward.reward(arenaPlayer);
                ((AMA)this.plugin).getMobManager().displayMobKillReward(livingEntity, mobKillReward);
            }
        }
        ((AMA)this.plugin).getPluginManager().callEvent((Event)arenaMobDeathEvent);
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onGamePlayerBlockPlace(BlockPlaceEvent blockPlaceEvent) {
        Player player = blockPlaceEvent.getPlayer();
        Block block = blockPlaceEvent.getBlock();
        ArenaPlayer arenaPlayer = ArenaPlayer.getPlayer(player);
        if (arenaPlayer != null) {
            blockPlaceEvent.setCancelled(true);
            if (block.getType() == Material.TNT) {
                ItemStack itemStack = blockPlaceEvent.getItemInHand();
                itemStack.setAmount(itemStack.getAmount() - 1);
                TNTPrimed tNTPrimed = (TNTPrimed)block.getWorld().spawn(block.getLocation(), TNTPrimed.class);
                tNTPrimed.setSource((Entity)player);
            }
            return;
        }
        if (player.hasPermission((Permission)Perms.CREATOR)) {
            return;
        }
        Arena arena = this.manager.getArenaAtLocation(block.getLocation());
        if (arena != null) {
            blockPlaceEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onGameStatsTNT(EntityExplodeEvent entityExplodeEvent) {
        TNTPrimed tNTPrimed;
        Object object = entityExplodeEvent.getEntity();
        if (object instanceof TNTPrimed && (object = (tNTPrimed = (TNTPrimed)object).getSource()) instanceof Player) {
            Player player = (Player)object;
            if ((object = ArenaPlayer.getPlayer(player)) == null) {
                return;
            }
            ((ArenaPlayer)object).addStats(StatType.TNT_EXPLODED, 1);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onGameStatsConsume(PlayerItemConsumeEvent playerItemConsumeEvent) {
        Player player = playerItemConsumeEvent.getPlayer();
        ArenaPlayer arenaPlayer = ArenaPlayer.getPlayer(player);
        if (arenaPlayer == null) {
            return;
        }
        ItemStack itemStack = playerItemConsumeEvent.getItem();
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta instanceof PotionMeta) {
            arenaPlayer.addStats(StatType.POTIONS_DRUNK, 1);
        } else {
            arenaPlayer.addStats(StatType.FOOD_EATEN, 1);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onGameStatsItemBreak(PlayerItemBreakEvent playerItemBreakEvent) {
        Player player = playerItemBreakEvent.getPlayer();
        ArenaPlayer arenaPlayer = ArenaPlayer.getPlayer(player);
        if (arenaPlayer == null) {
            return;
        }
        arenaPlayer.addStats(StatType.EQUIPMENT_BROKEN, 1);
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onGamePlayerQuit(PlayerQuitEvent playerQuitEvent) {
        Player player = playerQuitEvent.getPlayer();
        ArenaPlayer arenaPlayer = ArenaPlayer.getPlayer(player);
        if (arenaPlayer == null) {
            return;
        }
        arenaPlayer.leaveArena();
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onGameItemInteract(PlayerInteractEvent playerInteractEvent) {
        Object object;
        Player player = playerInteractEvent.getPlayer();
        ArenaPlayer arenaPlayer = ArenaPlayer.getPlayer(player);
        if (arenaPlayer == null) {
            return;
        }
        ItemStack itemStack = playerInteractEvent.getItem();
        if (itemStack == null || itemStack.getType().isAir()) {
            return;
        }
        if (arenaPlayer.getState() != GameState.INGAME) {
            object = playerInteractEvent.getClickedBlock();
            if (object != null && object.getType().isInteractable()) {
                return;
            }
            LobbyItem lobbyItem = LobbyItem.get(itemStack);
            if (lobbyItem != null) {
                lobbyItem.use(arenaPlayer);
                playerInteractEvent.setUseItemInHand(Event.Result.DENY);
                return;
            }
        }
        if (((Arena)(object = arenaPlayer.getArena())).getConfig().getGameplayManager().getBannedItems().contains(itemStack.getType())) {
            playerInteractEvent.setUseItemInHand(Event.Result.DENY);
            playerInteractEvent.setUseInteractedBlock(Event.Result.DENY);
        }
    }
}

