/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.arena.listener;

import java.util.Set;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.block.EntityBlockFormEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.bukkit.event.entity.ItemSpawnEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerArmorStandManipulateEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.vehicle.VehicleDamageEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.permissions.Permission;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.manager.AbstractListener;
import su.nexmedia.engine.utils.EngineUtils;
import su.nightexpress.ama.AMA;
import su.nightexpress.ama.Perms;
import su.nightexpress.ama.api.type.GameState;
import su.nightexpress.ama.api.type.PlayerType;
import su.nightexpress.ama.arena.ArenaManager;
import su.nightexpress.ama.arena.impl.Arena;
import su.nightexpress.ama.arena.impl.ArenaPlayer;
import su.nightexpress.ama.config.Config;
import su.nightexpress.ama.kit.Kit;
import su.nightexpress.ama.mob.MobManager;
import su.nightexpress.ama.mob.config.MobConfig;
import su.nightexpress.ama.mob.config.MobsConfig;

public class ArenaGenericListener
extends AbstractListener<AMA> {
    private final ArenaManager manager;

    public ArenaGenericListener(@NotNull ArenaManager arenaManager) {
        super((NexPlugin)((AMA)arenaManager.plugin()));
        this.manager = arenaManager;
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onArenaPlayerBlockBreak(BlockBreakEvent blockBreakEvent) {
        Player player = blockBreakEvent.getPlayer();
        if (ArenaPlayer.isPlaying(player)) {
            blockBreakEvent.setCancelled(true);
            return;
        }
        Block block = blockBreakEvent.getBlock();
        Arena arena = this.manager.getArenaAtLocation(block.getLocation());
        if (arena != null && !player.hasPermission((Permission)Perms.CREATOR)) {
            blockBreakEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onArenaDamageGeneric(EntityDamageEvent entityDamageEvent) {
        Object object = entityDamageEvent.getEntity();
        if (!(object instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)object;
        object = ((AMA)this.plugin).getMobManager().getEntityMobConfig(livingEntity);
        if (object != null && ((MobConfig)((Object)object)).isBarEnabled()) {
            ((AMA)this.plugin).runTask(arg_0 -> ArenaGenericListener.lambda$onArenaDamageGeneric$0((MobConfig)((Object)object), livingEntity, arg_0));
            return;
        }
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        ArenaPlayer arenaPlayer = ArenaPlayer.getPlayer(player);
        if (arenaPlayer == null) {
            return;
        }
        if (arenaPlayer.getState() != GameState.INGAME) {
            entityDamageEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onArenaDamageFriendly(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        Object object;
        Object object2;
        ProjectileSource projectileSource;
        Entity entity = entityDamageByEntityEvent.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        entity = entityDamageByEntityEvent.getDamager();
        if (entity instanceof Projectile && (projectileSource = (object2 = (Projectile)entity).getShooter()) instanceof LivingEntity) {
            object = (LivingEntity)projectileSource;
            entity = object;
        }
        if ((object2 = ((AMA)this.plugin).getMobManager().getEntityArena(entity)) == (object = ((AMA)this.plugin).getMobManager().getEntityArena((Entity)livingEntity)) && object2 != null) {
            if (((Arena)object2).getMobs().getFaction((LivingEntity)entity) == ((Arena)object2).getMobs().getFaction(livingEntity)) {
                entityDamageByEntityEvent.setCancelled(true);
            }
        } else if (entity instanceof Player) {
            projectileSource = (Player)entity;
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                if (projectileSource == player) {
                    return;
                }
                if (ArenaPlayer.isPlaying((Player)projectileSource) || ArenaPlayer.isPlaying(player)) {
                    entityDamageByEntityEvent.setCancelled(true);
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onArenaItemMove(InventoryClickEvent inventoryClickEvent) {
        if (inventoryClickEvent.getInventory().getType() != InventoryType.CRAFTING) {
            return;
        }
        Player player = (Player)inventoryClickEvent.getWhoClicked();
        ArenaPlayer arenaPlayer = ArenaPlayer.getPlayer(player);
        if (arenaPlayer == null) {
            return;
        }
        Arena arena = arenaPlayer.getArena();
        if (!arena.getConfig().getGameplayManager().isKitsEnabled()) {
            return;
        }
        if (arena.getState() == GameState.INGAME) {
            return;
        }
        inventoryClickEvent.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onArenaItemSpawn(ItemSpawnEvent itemSpawnEvent) {
        Item item = itemSpawnEvent.getEntity();
        Arena arena = this.manager.getArenaAtLocation(item.getLocation());
        if (arena == null) {
            return;
        }
        arena.addGroundItem(item);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onArenaMobSpawn(CreatureSpawnEvent creatureSpawnEvent) {
        LivingEntity livingEntity = creatureSpawnEvent.getEntity();
        Location location = livingEntity.getLocation();
        Arena arena = ((AMA)this.plugin).getArenaManager().getArenaAtLocation(location);
        if (arena == null) {
            return;
        }
        if (arena.getState() == GameState.INGAME && !arena.isAboutToEnd()) {
            CreatureSpawnEvent.SpawnReason spawnReason = creatureSpawnEvent.getSpawnReason();
            if (spawnReason == CreatureSpawnEvent.SpawnReason.SPAWNER_EGG && ((Set)MobsConfig.ALLY_FROM_EGGS.get()).contains(livingEntity.getType())) {
                arena.spawnAllyMob(livingEntity.getType(), location);
                creatureSpawnEvent.setCancelled(true);
                return;
            }
            if (spawnReason == CreatureSpawnEvent.SpawnReason.CUSTOM || arena.getConfig().getGameplayManager().isAllowedSpawnReason(spawnReason)) {
                if (!arena.isAboutToSpawnMobs()) {
                    MobManager.setArena(livingEntity, arena);
                    arena.getMobs().getEnemies().add(livingEntity);
                    arena.setRoundTotalMobsAmount(arena.getRoundTotalMobsAmount() + 1);
                }
                return;
            }
        }
        creatureSpawnEvent.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onArenaMobTeleport(EntityTeleportEvent entityTeleportEvent) {
        Arena arena;
        Location location = entityTeleportEvent.getTo();
        if (location == null) {
            return;
        }
        Arena arena2 = this.manager.getArenaAtLocation(location);
        if (arena2 != (arena = this.manager.getArenaAtLocation(entityTeleportEvent.getFrom()))) {
            entityTeleportEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onArenaPlayerTeleport(PlayerTeleportEvent playerTeleportEvent) {
        if (playerTeleportEvent.getPlayer().hasPermission((Permission)Perms.CREATOR)) {
            return;
        }
        Location location = playerTeleportEvent.getTo();
        if (location == null) {
            return;
        }
        Arena arena = this.manager.getArenaAtLocation(location);
        ArenaPlayer arenaPlayer = ArenaPlayer.getPlayer(playerTeleportEvent.getPlayer());
        if (arenaPlayer == null) {
            Arena arena2 = this.manager.getArenaAtLocation(playerTeleportEvent.getFrom());
            if (arena2 != null) {
                return;
            }
            if (arena != null) {
                playerTeleportEvent.setCancelled(true);
            }
        } else {
            if (arenaPlayer.isTransfer() || arenaPlayer.isGhost() || arenaPlayer.isDead()) {
                return;
            }
            if (arenaPlayer.getArena().isAboutToEnd()) {
                return;
            }
            if (arenaPlayer.getArena() == arena) {
                return;
            }
            playerTeleportEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onArenaMobCombust(EntityCombustEvent entityCombustEvent) {
        Entity entity = entityCombustEvent.getEntity();
        if (((AMA)this.plugin).getMobManager().isArenaEntity(entity)) {
            if (entityCombustEvent instanceof EntityCombustByEntityEvent) {
                EntityCombustByEntityEvent entityCombustByEntityEvent = (EntityCombustByEntityEvent)entityCombustEvent;
                if (((AMA)this.plugin).getMobManager().isArenaEntity(entityCombustByEntityEvent.getCombuster())) {
                    entityCombustEvent.setCancelled(true);
                }
                return;
            }
            entityCombustEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onArenaMobExplode(EntityExplodeEvent entityExplodeEvent) {
        if (entityExplodeEvent.blockList().stream().anyMatch(block -> this.manager.getArenaAtLocation(block.getLocation()) != null)) {
            entityExplodeEvent.blockList().clear();
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onArenaBlockExplode(BlockExplodeEvent blockExplodeEvent) {
        if (blockExplodeEvent.blockList().stream().anyMatch(block -> this.manager.getArenaAtLocation(block.getLocation()) != null)) {
            blockExplodeEvent.blockList().clear();
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onArenaBlockFire(BlockIgniteEvent blockIgniteEvent) {
        BlockIgniteEvent.IgniteCause igniteCause = blockIgniteEvent.getCause();
        if (igniteCause == BlockIgniteEvent.IgniteCause.FLINT_AND_STEEL) {
            return;
        }
        Block block = blockIgniteEvent.getBlock();
        Arena arena = this.manager.getArenaAtLocation(block.getLocation());
        if (arena != null) {
            blockIgniteEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onArenaBlockChange(EntityChangeBlockEvent entityChangeBlockEvent) {
        Arena arena = ((AMA)this.plugin).getArenaManager().getArenaAtLocation(entityChangeBlockEvent.getBlock().getLocation());
        if (arena != null) {
            entityChangeBlockEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onArenaBlockForm(EntityBlockFormEvent entityBlockFormEvent) {
        Arena arena = ((AMA)this.plugin).getArenaManager().getArenaAtLocation(entityBlockFormEvent.getBlock().getLocation());
        if (arena != null) {
            entityBlockFormEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onArenaBreakVehicle(VehicleDamageEvent vehicleDamageEvent) {
        vehicleDamageEvent.setCancelled(!this.canDamage(vehicleDamageEvent.getAttacker(), (Entity)vehicleDamageEvent.getVehicle()));
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onArenaBreakDecorations(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        if (!(entityDamageByEntityEvent.getEntity() instanceof LivingEntity)) {
            entityDamageByEntityEvent.setCancelled(!this.canDamage(entityDamageByEntityEvent.getDamager(), entityDamageByEntityEvent.getEntity()));
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onArenaBreakPainting(HangingBreakByEntityEvent hangingBreakByEntityEvent) {
        hangingBreakByEntityEvent.setCancelled(!this.canDamage(hangingBreakByEntityEvent.getRemover(), (Entity)hangingBreakByEntityEvent.getEntity()));
    }

    private boolean canDamage(@Nullable Entity entity, @NotNull Entity entity2) {
        Object object;
        if (entity instanceof Player && ArenaPlayer.isPlaying(object = (Player)entity)) {
            return false;
        }
        if (entity != null && entity.hasPermission((Permission)Perms.CREATOR)) {
            return true;
        }
        object = ((AMA)this.plugin).getArenaManager().getArenaAtLocation(entity2.getLocation());
        return object == null;
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onArenaPlayerInteractEntity(PlayerInteractEntityEvent playerInteractEntityEvent) {
        playerInteractEntityEvent.setCancelled(!this.canInteract(playerInteractEntityEvent));
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onArenaPlayerInteractEntity2(PlayerInteractAtEntityEvent playerInteractAtEntityEvent) {
        playerInteractAtEntityEvent.setCancelled(!this.canInteract((PlayerInteractEntityEvent)playerInteractAtEntityEvent));
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onArenaPlayerInteractStand(PlayerArmorStandManipulateEvent playerArmorStandManipulateEvent) {
        playerArmorStandManipulateEvent.setCancelled(ArenaPlayer.isPlaying(playerArmorStandManipulateEvent.getPlayer()));
    }

    private boolean canInteract(@NotNull PlayerInteractEntityEvent playerInteractEntityEvent) {
        Player player = playerInteractEntityEvent.getPlayer();
        if (!ArenaPlayer.isPlaying(player)) {
            return true;
        }
        Entity entity = playerInteractEntityEvent.getRightClicked();
        return entity instanceof Player || entity instanceof Vehicle || !((AMA)this.plugin).getMobManager().isArenaEntity(entity);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onArenaChunkUnload(ChunkUnloadEvent chunkUnloadEvent) {
        Chunk chunk = chunkUnloadEvent.getChunk();
        if (chunk.getPluginChunkTickets().contains(this.plugin)) {
            return;
        }
        for (Entity entity : chunkUnloadEvent.getChunk().getEntities()) {
            if (!((AMA)this.plugin).getMobManager().isArenaEntity(entity)) continue;
            chunk.addPluginChunkTicket((Plugin)this.plugin);
            return;
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onArenaChat(AsyncPlayerChatEvent asyncPlayerChatEvent) {
        if (!((Boolean)Config.CHAT_ENABLED.get()).booleanValue()) {
            return;
        }
        Player player = asyncPlayerChatEvent.getPlayer();
        ArenaPlayer arenaPlayer = ArenaPlayer.getPlayer(player);
        if (arenaPlayer == null) {
            return;
        }
        Arena arena = arenaPlayer.getArena();
        Kit kit = arenaPlayer.getKit();
        asyncPlayerChatEvent.getRecipients().retainAll(arena.getPlayers(PlayerType.ALL).stream().map(ArenaPlayer::getPlayer).toList());
        String string = ((String)Config.CHAT_FORMAT.get()).replace("%player_name%", "%1$s").replace("%message%", "%2$s");
        string = (String)arenaPlayer.replacePlaceholders().apply(string);
        string = (String)arena.replacePlaceholders().apply(string);
        if (EngineUtils.hasPlaceholderAPI()) {
            string = PlaceholderAPI.setPlaceholders((Player)player, (String)string);
        }
        asyncPlayerChatEvent.setFormat(string);
    }

    private static /* synthetic */ void lambda$onArenaDamageGeneric$0(MobConfig mobConfig, LivingEntity livingEntity, BukkitTask bukkitTask) {
        mobConfig.createOrUpdateBar(livingEntity);
    }
}

