/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.arena.reward;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.api.config.JYML;
import su.nexmedia.engine.api.manager.ConfigHolder;
import su.nexmedia.engine.api.manager.Loadable;
import su.nexmedia.engine.api.placeholder.Placeholder;
import su.nexmedia.engine.api.placeholder.PlaceholderMap;
import su.nexmedia.engine.lang.LangManager;
import su.nexmedia.engine.utils.StringUtil;
import su.nightexpress.ama.api.arena.ArenaChild;
import su.nightexpress.ama.api.arena.Problematic;
import su.nightexpress.ama.api.arena.type.ArenaGameEventType;
import su.nightexpress.ama.api.arena.type.ArenaTargetType;
import su.nightexpress.ama.arena.editor.reward.RewardListEditor;
import su.nightexpress.ama.arena.impl.ArenaConfig;
import su.nightexpress.ama.arena.reward.ArenaReward;
import su.nightexpress.ama.arena.script.action.ParameterResult;
import su.nightexpress.ama.arena.script.action.Parameters;
import su.nightexpress.ama.arena.script.action.ScriptActions;
import su.nightexpress.ama.arena.script.action.ScriptPreparedAction;
import su.nightexpress.ama.arena.script.condition.ScriptCondition;
import su.nightexpress.ama.arena.script.condition.ScriptConditions;
import su.nightexpress.ama.arena.script.condition.ScriptPreparedCondition;
import su.nightexpress.ama.arena.script.impl.ArenaScript;

public class ArenaRewardManager
implements ArenaChild,
ConfigHolder,
Loadable,
Problematic,
Placeholder {
    private static final String CONFIG_NAME = "rewards.yml";
    private final ArenaConfig arenaConfig;
    private final JYML config;
    private final Map<String, ArenaReward> rewards;
    private final PlaceholderMap placeholderMap;
    private boolean isRetainOnLeave;
    private boolean isRetainOnDeath;
    private RewardListEditor editor;

    public ArenaRewardManager(@NotNull ArenaConfig arenaConfig) {
        this.arenaConfig = arenaConfig;
        this.config = new JYML(this.arenaConfig.getFile().getParentFile().getAbsolutePath(), CONFIG_NAME);
        this.rewards = new HashMap<String, ArenaReward>();
        this.placeholderMap = new PlaceholderMap().add("%problems%", () -> String.join((CharSequence)"\n", this.getProblems())).add("%reward_manager_retain_on_death%", () -> LangManager.getBoolean((boolean)this.isRetainOnDeath())).add("%reward_manager_retain_on_leave%", () -> LangManager.getBoolean((boolean)this.isRetainOnLeave()));
    }

    public void setup() {
        this.isRetainOnLeave = this.config.getBoolean("Retain_On_Leave");
        this.isRetainOnDeath = this.config.getBoolean("Retain_On_Death");
        for (String string : this.config.getSection("List")) {
            String string2 = "List." + string + ".";
            String string3 = this.config.getString(string2 + "Name", string);
            boolean bl = this.config.getBoolean(string2 + "Late");
            double d = this.config.getDouble(string2 + "Chance");
            ArenaTargetType arenaTargetType = (ArenaTargetType)this.config.getEnum(string2 + "Target", ArenaTargetType.class, (Enum)ArenaTargetType.PLAYER_ALL);
            List list2 = this.config.getStringList(string2 + "Commands");
            ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>(Arrays.asList(this.config.getItemsEncoded(string2 + "Items")));
            for (String string4 : this.config.getSection(string2 + "Triggers")) {
                ArenaGameEventType arenaGameEventType = StringUtil.getEnum((String)string4, ArenaGameEventType.class).orElse(null);
                if (arenaGameEventType == null) continue;
                String string5 = "reward_" + string;
                ArenaScript arenaScript = new ArenaScript(this.arenaConfig, string5, arenaGameEventType);
                String string6 = this.config.getString(string2 + "Triggers." + string4, "");
                Map<String, List<ScriptPreparedCondition>> map = ArenaScript.ofGameTrigger(arenaGameEventType, string6);
                map.values().forEach(list -> list.add(new ScriptPreparedCondition(ScriptConditions.CHANCE, d, ScriptCondition.Operator.SMALLER)));
                if (map.isEmpty()) {
                    map.put("default", Collections.singletonList(new ScriptPreparedCondition(ScriptConditions.CHANCE, d, ScriptCondition.Operator.SMALLER)));
                }
                arenaScript.getConditions().putAll(map);
                ScriptPreparedAction scriptPreparedAction = new ScriptPreparedAction(ScriptActions.GIVE_REWARD, new ParameterResult());
                scriptPreparedAction.getParameters().add(Parameters.REWARD, string.toLowerCase());
                scriptPreparedAction.getParameters().add(Parameters.TARGET, arenaTargetType.name());
                arenaScript.getActions().add(scriptPreparedAction);
                this.getArenaConfig().getScriptManager().addConverted(arenaScript);
            }
            this.config.remove(string2 + "Triggers");
            ArenaReward arenaReward = new ArenaReward(this.arenaConfig, string, string3, bl, list2, arrayList);
            this.getRewardsMap().put(arenaReward.getId(), arenaReward);
        }
        this.config.saveChanges();
    }

    public void shutdown() {
        if (this.editor != null) {
            this.editor.clear();
            this.editor = null;
        }
        this.getRewards().forEach(ArenaReward::clear);
        this.getRewardsMap().clear();
    }

    @NotNull
    public PlaceholderMap getPlaceholders() {
        return this.placeholderMap;
    }

    @NotNull
    public RewardListEditor getEditor() {
        if (this.editor == null) {
            this.editor = new RewardListEditor(this);
        }
        return this.editor;
    }

    @NotNull
    public JYML getConfig() {
        return this.config;
    }

    @Override
    @NotNull
    public List<String> getProblems() {
        return new ArrayList<String>();
    }

    public void onSave() {
        this.config.set("Retain_On_Death", (Object)this.isRetainOnDeath());
        this.config.set("Retain_On_Leave", (Object)this.isRetainOnLeave());
        this.config.set("List", null);
        this.getRewardsMap().forEach((string, arenaReward) -> {
            String string2 = "List." + string + ".";
            this.config.set(string2 + "Name", (Object)arenaReward.getName());
            this.config.set(string2 + "Late", (Object)arenaReward.isLate());
            this.config.set(string2 + "Commands", arenaReward.getCommands());
            this.config.setItemsEncoded(string2 + "Items", arenaReward.getItems());
        });
    }

    @Override
    @NotNull
    public ArenaConfig getArenaConfig() {
        return this.arenaConfig;
    }

    public boolean createReward(@NotNull String string) {
        if (this.getReward(string).isPresent()) {
            return false;
        }
        ArenaReward arenaReward = new ArenaReward(this.getArenaConfig(), string);
        this.getRewardsMap().put(arenaReward.getId(), arenaReward);
        return true;
    }

    @NotNull
    public Map<String, ArenaReward> getRewardsMap() {
        return this.rewards;
    }

    @NotNull
    public Collection<ArenaReward> getRewards() {
        return this.rewards.values();
    }

    @NotNull
    public Optional<ArenaReward> getReward(@NotNull String string) {
        return Optional.ofNullable(this.getRewardsMap().get(string.toLowerCase()));
    }

    public boolean isRetainOnDeath() {
        return this.isRetainOnDeath;
    }

    public boolean isRetainOnLeave() {
        return this.isRetainOnLeave;
    }

    public void setRetainOnDeath(boolean bl) {
        this.isRetainOnDeath = bl;
    }

    public void setRetainOnLeave(boolean bl) {
        this.isRetainOnLeave = bl;
    }
}

