/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.arena.script;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.api.config.JYML;
import su.nexmedia.engine.api.manager.ConfigHolder;
import su.nexmedia.engine.api.manager.Loadable;
import su.nightexpress.ama.api.arena.ArenaChild;
import su.nightexpress.ama.arena.editor.script.ScriptsEditor;
import su.nightexpress.ama.arena.impl.ArenaConfig;
import su.nightexpress.ama.arena.script.impl.ArenaScript;
import su.nightexpress.ama.arena.script.impl.ScriptCategory;

public class ArenaScriptManager
implements ArenaChild,
Loadable {
    public static final String DIR_SCRIPTS = "/scripts/";
    private final ArenaConfig arenaConfig;
    private final Map<String, ScriptCategory> categories;
    private ScriptsEditor editor;

    public ArenaScriptManager(@NotNull ArenaConfig arenaConfig) {
        this.arenaConfig = arenaConfig;
        this.categories = new HashMap<String, ScriptCategory>();
    }

    public void setup() {
        for (JYML jYML : JYML.loadAll((String)this.getScriptsPath(), (boolean)true)) {
            ScriptCategory scriptCategory = new ScriptCategory(this.getArenaConfig(), jYML);
            if (scriptCategory.load()) {
                this.getCategoryMap().put(scriptCategory.getId(), scriptCategory);
                continue;
            }
            this.plugin().error("Script category not loaded: '" + jYML.getFile().getName() + "' in '" + this.getArenaConfig().getId() + "' arena!");
        }
        this.plugin().info("Loaded " + this.getScripts().size() + " scripts for '" + this.getArenaConfig().getId() + "' arena!");
    }

    public void shutdown() {
        if (this.editor != null) {
            this.editor.clear();
            this.editor = null;
        }
        this.getCategories().forEach(ScriptCategory::clear);
        this.getCategoryMap().clear();
    }

    public void save() {
        this.getCategories().forEach(ConfigHolder::save);
    }

    @NotNull
    public ScriptsEditor getEditor() {
        if (this.editor == null) {
            this.editor = new ScriptsEditor(this);
        }
        return this.editor;
    }

    @NotNull
    public String getScriptsPath() {
        return this.arenaConfig.getFile().getParentFile().getAbsolutePath() + DIR_SCRIPTS;
    }

    @Override
    @NotNull
    public ArenaConfig getArenaConfig() {
        return this.arenaConfig;
    }

    @NotNull
    public Map<String, ScriptCategory> getCategoryMap() {
        return this.categories;
    }

    @NotNull
    public Collection<ScriptCategory> getCategories() {
        return this.getCategoryMap().values();
    }

    @NotNull
    public Optional<ScriptCategory> getCategory(@NotNull String string) {
        return Optional.ofNullable(this.getCategoryMap().get(string.toLowerCase()));
    }

    @NotNull
    public List<ArenaScript> getScripts() {
        return this.getCategories().stream().flatMap(scriptCategory -> scriptCategory.getScripts().stream()).toList();
    }

    public void addConverted(@NotNull ArenaScript arenaScript) {
        this.createCategory("from_game_triggers");
        this.getCategory("from_game_triggers").ifPresent(scriptCategory -> {
            scriptCategory.getScriptsMap().put(arenaScript.getId(), arenaScript);
            scriptCategory.save();
        });
    }

    public boolean createCategory(@NotNull String string) {
        if (this.getCategory(string).isPresent()) {
            return false;
        }
        JYML jYML = new JYML(this.getScriptsPath(), string + ".yml");
        ScriptCategory scriptCategory = new ScriptCategory(this.getArenaConfig(), jYML);
        this.getCategoryMap().put(scriptCategory.getId(), scriptCategory);
        return true;
    }

    public void deleteCategory(@NotNull ScriptCategory scriptCategory) {
        if (scriptCategory.getConfig().getFile().delete()) {
            scriptCategory.clear();
            this.getCategoryMap().remove(scriptCategory.getId());
        }
    }
}

