/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.arena.script.action;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.ama.api.event.ArenaGameGenericEvent;
import su.nightexpress.ama.arena.script.action.Parameter;
import su.nightexpress.ama.arena.script.action.ParameterResult;

public class ScriptAction {
    private final String name;
    private final Set<Parameter<?>> parameters;
    private final BiConsumer<ArenaGameGenericEvent, ParameterResult> executor;

    public ScriptAction(@NotNull String string, @NotNull BiConsumer<ArenaGameGenericEvent, ParameterResult> biConsumer, Parameter<?> ... parameterArray) {
        this.name = string.toLowerCase();
        this.parameters = new HashSet(Arrays.asList(parameterArray));
        this.executor = biConsumer;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public Set<Parameter<?>> getParameters() {
        return this.parameters;
    }

    @NotNull
    public BiConsumer<ArenaGameGenericEvent, ParameterResult> getExecutor() {
        return this.executor;
    }

    public void run(@NotNull ArenaGameGenericEvent arenaGameGenericEvent, @NotNull ParameterResult parameterResult) {
        this.getExecutor().accept(arenaGameGenericEvent, parameterResult);
    }
}

