/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.arena.script.condition;

import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.utils.TriFunction;
import su.nightexpress.ama.api.event.ArenaGameGenericEvent;

public class ScriptCondition<C, E> {
    private final String name;
    private final Function<String, C> parser;
    private final Function<ArenaGameGenericEvent, E> extractor;
    private final TriFunction<E, C, Operator, Boolean> tester;

    public ScriptCondition(@NotNull String string, @NotNull Function<String, C> function, @NotNull Function<ArenaGameGenericEvent, E> function2, @NotNull TriFunction<E, C, Operator, Boolean> triFunction) {
        this.name = string.toLowerCase();
        this.parser = function;
        this.extractor = function2;
        this.tester = triFunction;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public Function<String, C> getParser() {
        return this.parser;
    }

    @NotNull
    public Function<ArenaGameGenericEvent, E> getExtractor() {
        return this.extractor;
    }

    @NotNull
    public TriFunction<E, C, Operator, Boolean> getTester() {
        return this.tester;
    }

    public boolean test(@NotNull ArenaGameGenericEvent arenaGameGenericEvent, @NotNull Object object, @NotNull Operator operator) {
        E e = this.getExtractor().apply(arenaGameGenericEvent);
        Object object2 = object;
        return (Boolean)this.getTester().apply(e, object2, (Object)operator);
    }

    public static enum Operator {
        EQUAL("="),
        NOT_EQUAL("!="),
        GREATER(">"),
        SMALLER("<"),
        EACH("%"),
        EACH_NOT("!%");

        private final String raw;

        private Operator(String string2) {
            this.raw = string2;
        }

        @NotNull
        public String getRaw() {
            return this.raw;
        }

        @NotNull
        public static Optional<Operator> fromString(@NotNull String string) {
            return Stream.of(Operator.values()).filter(operator -> operator.getRaw().equalsIgnoreCase(string)).findFirst();
        }
    }
}

