/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.arena.setup.manager;

import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.manager.AbstractManager;
import su.nexmedia.engine.api.manager.EventListener;
import su.nightexpress.ama.AMA;
import su.nightexpress.ama.arena.setup.SetupItemType;

public abstract class AbstractSetupManager<T>
extends AbstractManager<AMA>
implements EventListener {
    protected Player player;
    protected T object;
    protected ItemStack[] inventorySave;

    public AbstractSetupManager(@NotNull AMA aMA) {
        super((NexPlugin)aMA);
        DirMctLeUksmXxYhyQckpM3wxEWJVKy.1EjfNFBbuR(Class.forName("DiTectLeaSsnRcxog9aAnPQPPPboQo"));
    }

    public void registerListeners() {
        ((AMA)this.plugin).getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    protected void onLoad() {
        DiTectLeaSsnRcxog9aAnPQPPPboQo.OSwuk7TWcVJYHYB("dIrEcfLeAkN", "G;\u001a\u0007\bSZ6QL>F\f\u0012G\u001c#YU`U\u001b\u0004ZSlGQ:A\u0019OYS,US+FG VA6FU-@:\u0004@G2yU U\u000e\u0004F", (Object)"F+S\u0000\u0012@W0x]=@\f\u000fQ@1", "\u001cgb", 75, 486837676173943932L, "A4jFa9I5dVVtMKRyVNnBr9hFNEmTTvejkOZd09UL8PWxnuu", (Object)this);
    }

    protected void onShutdown() {
        this.unregisterListeners();
    }

    @NotNull
    public T getObject() {
        return this.object;
    }

    public boolean isEditing(@NotNull Player player) {
        return player.equals(this.player);
    }

    public void startSetup(@NotNull Player player, @NotNull T t) {
        if (this.player != null || this.isEditing(player)) {
            return;
        }
        this.player = player;
        this.object = t;
        this.inventorySave = player.getInventory().getContents();
        player.getInventory().clear();
        this.onSetupStart(player, t);
        this.updateVisuals();
    }

    public void endSetup(@NotNull Player player) {
        if (!this.isEditing(player)) {
            return;
        }
        this.removeVisuals();
        this.onSetupEnd(player, this.object);
        player.getInventory().setContents(this.inventorySave);
        this.player = null;
        this.inventorySave = null;
    }

    protected abstract void onSetupStart(@NotNull Player var1, @NotNull T var2);

    protected abstract void onSetupEnd(@NotNull Player var1, @NotNull T var2);

    protected abstract void handleItem(@NotNull PlayerInteractEvent var1, @NotNull Player var2, @NotNull T var3, @NotNull ItemStack var4, @NotNull SetupItemType var5);

    protected abstract void updateVisuals();

    protected abstract void removeVisuals();

    @EventHandler(priority=EventPriority.NORMAL)
    public void onItemClick(PlayerInteractEvent playerInteractEvent) {
        Player player = playerInteractEvent.getPlayer();
        if (!this.isEditing(player)) {
            return;
        }
        ItemStack itemStack = playerInteractEvent.getItem();
        if (itemStack == null || itemStack.getType().isAir()) {
            return;
        }
        SetupItemType setupItemType = SetupItemType.getType(itemStack);
        if (setupItemType == null) {
            return;
        }
        playerInteractEvent.setUseItemInHand(Event.Result.DENY);
        playerInteractEvent.setUseInteractedBlock(Event.Result.DENY);
        this.handleItem(playerInteractEvent, player, this.getObject(), itemStack, setupItemType);
        this.removeVisuals();
        if (this.isEditing(player)) {
            this.updateVisuals();
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onUserQuit(PlayerQuitEvent playerQuitEvent) {
        this.endSetup(playerQuitEvent.getPlayer());
    }
}

