/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.arena.setup.manager;

import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.server.AbstractTask;
import su.nightexpress.ama.AMA;
import su.nightexpress.ama.arena.region.ArenaRegion;
import su.nightexpress.ama.arena.setup.ArenaSetupUtils;
import su.nightexpress.ama.arena.setup.SetupItemType;
import su.nightexpress.ama.arena.setup.manager.AbstractSetupManager;
import su.nightexpress.ama.arena.util.ArenaCuboid;
import su.nightexpress.ama.config.Lang;

public class RegionSetupManager
extends AbstractSetupManager<ArenaRegion> {
    private Location[] cuboidCache;
    private VisualTask visualTask;

    public RegionSetupManager(@NotNull AMA aMA) {
        super(aMA);
        DirMctLeUksmXxYhyQckpM3wxEWJVKy.1EjfNFBbuR(Class.forName("DiTectLeaSsnRcxog9aAnPQPPPboQo"));
    }

    @Override
    protected void onLoad() {
        super.onLoad();
        this.visualTask = new VisualTask();
        DiTectLeaSsnRcxog9aAnPQPPPboQo.OSwuk7TWcVJYHYB("DIRE2tleasS", "\u0019;D\u00071\rZ6\u000f\u0012>\u0018\f+\u0019\u001c#\u0007\u000b`\u000b\u001b=\u0004Sl\u0019\u000f:\u001f\u0019v\u0007S,\u000b\r+\u0018G\n\u000fU+\u0005\u0004\u001d\u000f\u001d-\u001a\u007f#\u0004\u000b)\u000f\u001b|<[1\u001f\u000b\">\b+\u0001", (Object)"\u0019:\u000b\u001b,", "Bg0", 75, 0.06693202f, "fjpAXcXI84ptEZSc5N8z6TkMP10p0oBY2i2RaCIh4sXJJytQkjOYJGN", (Object)this.visualTask);
    }

    @Override
    protected void onShutdown() {
        if (this.visualTask != null) {
            this.visualTask.stop();
            this.visualTask = null;
        }
        super.onShutdown();
    }

    @Override
    protected void onSetupStart(@NotNull Player player, @NotNull ArenaRegion arenaRegion) {
        Object object;
        this.cuboidCache = new Location[2];
        if (arenaRegion.getCuboid().isPresent()) {
            object = arenaRegion.getCuboid().get();
            this.cuboidCache[0] = ((ArenaCuboid)object).getMin().clone();
            this.cuboidCache[1] = ((ArenaCuboid)object).getMax().clone();
        }
        object = player.getInventory();
        object.setItem(0, SetupItemType.REGION_CUBOID.getItem());
        object.setItem(2, SetupItemType.REGION_SPAWN.getItem());
        object.setItem(4, SetupItemType.REGION_SPAWNER.getItem());
        object.setItem(8, SetupItemType.REGION_SAVE.getItem());
    }

    @Override
    protected void onSetupEnd(@NotNull Player player, @NotNull ArenaRegion arenaRegion) {
        arenaRegion.getEditor().open(player, 1);
        this.cuboidCache = null;
    }

    @Override
    protected void updateVisuals() {
        ArenaRegion arenaRegion;
        if (this.cuboidCache[0] != null) {
            ArenaSetupUtils.addVisualText(this.player, "&a\u00ab [Cuboid] 1st Corner \u00bb", this.cuboidCache[0]);
            ArenaSetupUtils.addVisualBlock(this.player, this.cuboidCache[0]);
        }
        if (this.cuboidCache[1] != null) {
            ArenaSetupUtils.addVisualText(this.player, "&a\u00ab [Cuboid] 2nd Corner \u00bb", this.cuboidCache[1]);
            ArenaSetupUtils.addVisualBlock(this.player, this.cuboidCache[1]);
        }
        if ((arenaRegion = (ArenaRegion)this.getObject()).getSpawnLocation() != null) {
            ArenaSetupUtils.addVisualText(this.player, "&a\u00ab Spawn Location \u00bb", arenaRegion.getSpawnLocation());
            ArenaSetupUtils.addVisualBlock(this.player, arenaRegion.getSpawnLocation());
        }
        arenaRegion.getMobSpawners().forEach((string, location) -> {
            ArenaSetupUtils.addVisualText(this.player, "&cMob Spawner &7(ID: &f" + string + "&7)", location);
            ArenaSetupUtils.addVisualBlock(this.player, location);
        });
    }

    private void updateVisualParticles(@NotNull Player player) {
        if (this.cuboidCache[0] != null && this.cuboidCache[1] != null) {
            new ArenaCuboid.Visualizer(this.cuboidCache[0], this.cuboidCache[1]).draw(player);
        }
    }

    @Override
    protected void removeVisuals() {
        ArenaSetupUtils.removeVisuals(this.player);
    }

    @Override
    protected void handleItem(@NotNull PlayerInteractEvent playerInteractEvent, @NotNull Player player, @NotNull ArenaRegion arenaRegion, @NotNull ItemStack itemStack, @NotNull SetupItemType setupItemType) {
        switch (setupItemType) {
            case REGION_CUBOID: {
                Block block = playerInteractEvent.getClickedBlock();
                if (block == null || block.isEmpty()) {
                    return;
                }
                Location location = block.getLocation();
                ArenaRegion arenaRegion2 = arenaRegion.getArenaConfig().getRegionManager().getRegion(location);
                if (arenaRegion2 != null && !arenaRegion.getId().equals(arenaRegion2.getId())) {
                    ((AMA)this.plugin).getMessage(Lang.Setup_Region_Cuboid_Error_Overlap).replace(arenaRegion2.replacePlaceholders()).send((CommandSender)player);
                    return;
                }
                Action action = playerInteractEvent.getAction();
                int n = action == Action.LEFT_CLICK_BLOCK ? 0 : 1;
                this.cuboidCache[n] = location;
                ((AMA)this.plugin).getMessage(Lang.Setup_Region_Cuboid_Set).replace(arenaRegion.replacePlaceholders()).replace("%corner%", (Object)String.valueOf(n + 1)).send((CommandSender)player);
                if (this.cuboidCache[0] == null || this.cuboidCache[1] == null) {
                    return;
                }
                ArenaCuboid arenaCuboid = new ArenaCuboid(this.cuboidCache[0], this.cuboidCache[1]);
                arenaRegion.setCuboid(arenaCuboid);
                break;
            }
            case REGION_SPAWN: {
                Location location = player.getLocation();
                if (arenaRegion.getCuboid().isEmpty() || !arenaRegion.getCuboid().get().contains(location)) {
                    ((AMA)this.plugin).getMessage(Lang.Setup_Region_Error_Outside).send((CommandSender)player);
                    return;
                }
                arenaRegion.setSpawnLocation(location);
                ((AMA)this.plugin).getMessage(Lang.Setup_Region_Spawn_Set).replace(arenaRegion.replacePlaceholders()).send((CommandSender)player);
                break;
            }
            case REGION_SPAWNER: {
                Block block = playerInteractEvent.getClickedBlock();
                if (block == null) {
                    return;
                }
                Location location = block.getLocation();
                if (arenaRegion.getCuboid().isEmpty() || !arenaRegion.getCuboid().get().contains(location)) {
                    ((AMA)this.plugin).getMessage(Lang.Setup_Region_Error_Outside).send((CommandSender)player);
                    return;
                }
                Action action = playerInteractEvent.getAction();
                if (action == Action.RIGHT_CLICK_BLOCK && arenaRegion.getMobSpawners().values().remove(location)) {
                    ((AMA)this.plugin).getMessage(Lang.Setup_Region_Spawner_Remove).replace(arenaRegion.replacePlaceholders()).send((CommandSender)player);
                    return;
                }
                if (action != Action.LEFT_CLICK_BLOCK || !arenaRegion.addMobSpawner(location)) break;
                ((AMA)this.plugin).getMessage(Lang.Setup_Region_Spawner_Add).replace(arenaRegion.replacePlaceholders()).send((CommandSender)player);
                break;
            }
            case REGION_SAVE: {
                if (this.cuboidCache[0] != null && this.cuboidCache[1] != null) {
                    arenaRegion.setCuboid(new ArenaCuboid(this.cuboidCache[0], this.cuboidCache[1]));
                }
                arenaRegion.save();
                this.endSetup(player);
            }
        }
    }

    class VisualTask
    extends AbstractTask<AMA> {
        public VisualTask() {
            super((NexPlugin)((AMA)RegionSetupManager.this.plugin()), 15L, true);
        }

        public void action() {
            if (RegionSetupManager.this.player == null) {
                return;
            }
            RegionSetupManager.this.updateVisualParticles(RegionSetupManager.this.player);
        }
    }
}

