/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.arena.shop.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nexmedia.engine.api.placeholder.Placeholder;
import su.nexmedia.engine.api.placeholder.PlaceholderMap;
import su.nexmedia.engine.utils.Colorizer;
import su.nexmedia.engine.utils.ItemUtil;
import su.nexmedia.engine.utils.StringUtil;
import su.nightexpress.ama.api.arena.ArenaChild;
import su.nightexpress.ama.api.arena.type.ArenaGameEventType;
import su.nightexpress.ama.api.currency.Currency;
import su.nightexpress.ama.api.event.ArenaShopCategoryEvent;
import su.nightexpress.ama.api.type.GameState;
import su.nightexpress.ama.arena.editor.shop.ShopCategorySettingsEditor;
import su.nightexpress.ama.arena.impl.Arena;
import su.nightexpress.ama.arena.impl.ArenaConfig;
import su.nightexpress.ama.arena.impl.ArenaPlayer;
import su.nightexpress.ama.arena.lock.LockState;
import su.nightexpress.ama.arena.lock.Lockable;
import su.nightexpress.ama.arena.shop.ShopManager;
import su.nightexpress.ama.arena.shop.impl.ShopProduct;
import su.nightexpress.ama.arena.shop.menu.ShopCategoryMenu;
import su.nightexpress.ama.config.Lang;
import su.nightexpress.ama.kit.Kit;

public class ShopCategory
implements ArenaChild,
Lockable,
Placeholder {
    private final ArenaConfig arenaConfig;
    private final String id;
    private final PlaceholderMap placeholderMap;
    private final Map<String, ShopProduct> products;
    private String name;
    private List<String> description;
    private ItemStack icon;
    private LockState lockState;
    private Set<String> allowedKits;
    private ShopCategoryMenu menu;
    private ShopCategorySettingsEditor editor;

    public ShopCategory(@NotNull ArenaConfig arenaConfig, @NotNull String string) {
        this(arenaConfig, string, StringUtil.capitalizeUnderscored((String)string), new ArrayList<String>(), new ItemStack(Material.APPLE), new HashSet<String>(), new HashMap<String, ShopProduct>());
    }

    public ShopCategory(@NotNull ArenaConfig arenaConfig, @NotNull String string, @NotNull String string2, @NotNull List<String> list, @NotNull ItemStack itemStack, @NotNull Set<String> set, @NotNull Map<String, ShopProduct> map) {
        this.arenaConfig = arenaConfig;
        this.id = string.toLowerCase();
        this.setName(string2);
        this.setDescription(list);
        this.setIcon(itemStack);
        this.lockState = LockState.UNLOCKED;
        this.setAllowedKits(set);
        this.products = map;
        this.placeholderMap = new PlaceholderMap().add("%shop_category_id%", this::getId).add("%shop_category_name%", this::getName).add("%shop_category_description%", () -> String.join((CharSequence)"\n", this.getDescription())).add("%shop_category_allowed_kits%", () -> this.getAllowedKits().stream().map(string -> this.plugin().getKitManager().getKitById((String)string)).filter(Objects::nonNull).map(Kit::getName).map(Colorizer::strip).collect(Collectors.joining(", ")));
    }

    @NotNull
    public PlaceholderMap getPlaceholders() {
        return this.placeholderMap;
    }

    @NotNull
    public ShopCategorySettingsEditor getEditor() {
        if (this.editor == null) {
            this.editor = new ShopCategorySettingsEditor(this);
        }
        return this.editor;
    }

    public void clear() {
        this.getProducts().forEach(ShopProduct::clear);
        this.getProducts().clear();
        if (this.menu != null) {
            this.menu.clear();
            this.menu = null;
        }
        if (this.editor != null) {
            this.editor.clear();
            this.editor = null;
        }
    }

    @NotNull
    public ShopCategoryMenu getMenu() {
        if (this.menu == null) {
            this.menu = new ShopCategoryMenu(this);
        }
        return this.menu;
    }

    public boolean createProduct(@NotNull String string) {
        if (this.getProduct(string) != null) {
            return false;
        }
        Currency currency = this.plugin().getCurrencyManager().getOrAny("coins");
        ShopProduct shopProduct = new ShopProduct(this, string, currency);
        this.getProductsMap().put(shopProduct.getId(), shopProduct);
        return true;
    }

    public boolean isAvailable(@NotNull ArenaPlayer arenaPlayer) {
        if (this.getArenaConfig().getGameplayManager().isKitsEnabled()) {
            if (this.getAllowedKits().isEmpty() || this.getAllowedKits().contains("*")) {
                return true;
            }
            Kit kit = arenaPlayer.getKit();
            return kit != null && this.getAllowedKits().contains(kit.getId());
        }
        return true;
    }

    public boolean open(@NotNull ArenaPlayer arenaPlayer) {
        Arena arena = arenaPlayer.getArena();
        if (arena.getState() != GameState.INGAME || !arena.getConfig().getShopManager().isActive()) {
            this.plugin().getMessage(Lang.SHOP_OPEN_ERROR_DISABLED).send((CommandSender)arenaPlayer.getPlayer());
            return false;
        }
        if (this.isLocked()) {
            this.plugin().getMessage(Lang.SHOP_CATEGORY_OPEN_ERROR_LOCKED).replace(this.replacePlaceholders()).send((CommandSender)arenaPlayer.getPlayer());
            return false;
        }
        if (!this.isAvailable(arenaPlayer)) {
            this.plugin().getMessage(Lang.SHOP_CATEGORY_OPEN_ERROR_UNAVAILABLE).send((CommandSender)arenaPlayer.getPlayer());
            return false;
        }
        this.getMenu().open(arenaPlayer.getPlayer(), 1);
        return true;
    }

    @Override
    @NotNull
    public ArenaConfig getArenaConfig() {
        return this.arenaConfig;
    }

    @NotNull
    public ShopManager getShopManager() {
        return this.getArenaConfig().getShopManager();
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public LockState getLockState() {
        return this.lockState;
    }

    @Override
    public void setLockState(@NotNull LockState lockState) {
        this.lockState = lockState;
        ArenaGameEventType arenaGameEventType = this.isLocked() ? ArenaGameEventType.SHOP_CATEGORY_LOCKED : ArenaGameEventType.SHOP_CATEGORY_UNLOCKED;
        ArenaShopCategoryEvent arenaShopCategoryEvent = new ArenaShopCategoryEvent(this.getArena(), this, arenaGameEventType);
        this.plugin().getPluginManager().callEvent((Event)arenaShopCategoryEvent);
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(@NotNull String string) {
        this.name = Colorizer.apply((String)string);
    }

    @NotNull
    public List<String> getDescription() {
        return this.description;
    }

    public void setDescription(@NotNull List<String> list) {
        this.description = Colorizer.apply(list);
    }

    @NotNull
    public ItemStack getIcon() {
        return new ItemStack(this.icon);
    }

    public void setIcon(@NotNull ItemStack itemStack) {
        this.icon = new ItemStack(itemStack);
        ItemUtil.mapMeta((ItemStack)this.icon, itemMeta -> {
            itemMeta.setDisplayName(null);
            itemMeta.setLore(null);
            itemMeta.addItemFlags(ItemFlag.values());
        });
    }

    @NotNull
    public Set<String> getAllowedKits() {
        return this.allowedKits;
    }

    public void setAllowedKits(@NotNull Set<String> set) {
        this.allowedKits = set;
    }

    @NotNull
    public Map<String, ShopProduct> getProductsMap() {
        return this.products;
    }

    @NotNull
    public Collection<ShopProduct> getProducts() {
        return this.getProductsMap().values();
    }

    @Nullable
    public ShopProduct getProduct(@NotNull String string) {
        return this.getProductsMap().get(string.toLowerCase());
    }
}

