/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.arena.util;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.api.particle.SimpleParticle;

public class ArenaCuboid {
    private final Location min;
    private final Location max;
    private final Location center;
    private final Visualizer visualizer;

    public ArenaCuboid(@NotNull Location location, @NotNull Location location2) {
        int n = Math.min(location.getBlockX(), location2.getBlockX());
        int n2 = Math.min(location.getBlockY(), location2.getBlockY());
        int n3 = Math.min(location.getBlockZ(), location2.getBlockZ());
        int n4 = Math.max(location.getBlockX(), location2.getBlockX());
        int n5 = Math.max(location.getBlockY(), location2.getBlockY());
        int n6 = Math.max(location.getBlockZ(), location2.getBlockZ());
        this.min = new Location(location.getWorld(), (double)n, (double)n2, (double)n3);
        this.max = new Location(location.getWorld(), (double)n4, (double)n5, (double)n6);
        double d = (double)n + (double)(n4 - n) / 2.0;
        double d2 = (double)n2 + (double)(n5 - n2) / 2.0;
        double d3 = (double)n3 + (double)(n6 - n3) / 2.0;
        this.center = new Location(location.getWorld(), d, d2, d3);
        this.visualizer = new Visualizer(this.min, this.max);
    }

    @NotNull
    public Visualizer getVisualizer() {
        return this.visualizer;
    }

    public boolean contains(@NotNull Location location) {
        World world = location.getWorld();
        if (world == null || !world.equals(this.min.getWorld())) {
            return false;
        }
        int n = location.getBlockX();
        int n2 = location.getBlockY();
        int n3 = location.getBlockZ();
        return n >= this.min.getBlockX() && n <= this.max.getBlockX() && n2 >= this.min.getBlockY() && n2 <= this.max.getBlockY() && n3 >= this.min.getBlockZ() && n3 <= this.max.getBlockZ();
    }

    @NotNull
    public List<Block> getBlocks() {
        ArrayList<Block> arrayList = new ArrayList<Block>(this.getSize());
        World world = this.center.getWorld();
        if (world == null) {
            return arrayList;
        }
        for (int i = this.min.getBlockX(); i <= this.max.getBlockX(); ++i) {
            for (int j = this.min.getBlockY(); j <= this.max.getBlockY(); ++j) {
                for (int k = this.min.getBlockZ(); k <= this.max.getBlockZ(); ++k) {
                    Block block = world.getBlockAt(i, j, k);
                    arrayList.add(block);
                }
            }
        }
        return arrayList;
    }

    public int getSize() {
        int n = this.max.getBlockX() - this.min.getBlockX() + 1;
        int n2 = this.max.getBlockY() - this.min.getBlockY() + 1;
        int n3 = this.max.getBlockZ() - this.min.getBlockZ() + 1;
        return n * n2 * n3;
    }

    @NotNull
    public Location getMin() {
        return this.min;
    }

    @NotNull
    public Location getMax() {
        return this.max;
    }

    @NotNull
    public Location getCenter() {
        return this.center;
    }

    public static class Visualizer {
        private final ArrayList<Vector[]> sides = new ArrayList();
        private final Location min;

        public Visualizer(@NotNull Location location, @NotNull Location location2) {
            this.min = location;
            double d = (double)(location2.getBlockX() - location.getBlockX()) + 1.0;
            double d2 = (double)(location2.getBlockY() - location.getBlockY()) + 1.0;
            double d3 = (double)(location2.getBlockZ() - location.getBlockZ()) + 1.0;
            Vector vector = new Vector(0, 0, 0);
            Vector vector2 = new Vector(d, 0.0, 0.0);
            Vector vector3 = new Vector(0.0, 0.0, d3);
            Vector vector4 = new Vector(0.0, d2, 0.0);
            Vector vector5 = new Vector(0.0, d2, d3);
            Vector vector6 = new Vector(d, d2, 0.0);
            Vector vector7 = new Vector(d, 0.0, d3);
            this.sides.add(new Vector[]{vector, vector2});
            this.sides.add(new Vector[]{vector, vector3});
            this.sides.add(new Vector[]{vector, vector4});
            this.sides.add(new Vector[]{vector3, vector4});
            this.sides.add(new Vector[]{vector2, vector4});
            this.sides.add(new Vector[]{vector3, vector2});
            this.sides.add(new Vector[]{vector2, vector3});
            this.sides.add(new Vector[]{vector4, vector3});
            this.sides.add(new Vector[]{vector4, vector2});
            this.sides.add(new Vector[]{vector5, vector2});
            this.sides.add(new Vector[]{vector6, vector3});
            this.sides.add(new Vector[]{vector7, vector4});
        }

        @NotNull
        public Vector getPostion(double d, @NotNull Vector vector, @NotNull Vector vector2) {
            return vector.clone().add(vector2.clone().normalize().multiply(d));
        }

        @NotNull
        public ArrayList<Vector> traverse(@NotNull Vector vector, @NotNull Vector vector2) {
            ArrayList<Vector> arrayList = new ArrayList<Vector>();
            for (double d = 0.0; d <= vector2.length(); d += 0.1) {
                arrayList.add(this.getPostion(d, vector, vector2));
            }
            return arrayList;
        }

        public void draw(@NotNull Player player) {
            World world = this.min.getWorld();
            if (world == null) {
                return;
            }
            Particle.DustOptions dustOptions = new Particle.DustOptions(Color.RED, 1.0f);
            SimpleParticle simpleParticle = SimpleParticle.of((Particle)Particle.REDSTONE, (Object)dustOptions);
            for (Vector[] vectorArray : this.sides) {
                for (Vector vector : this.traverse(vectorArray[0], vectorArray[1])) {
                    vector = this.min.toVector().clone().add(vector);
                    Location location = vector.toLocation(world);
                    simpleParticle.play(player, location, 0.15, 0);
                }
            }
        }
    }
}

