/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.arena.util;

import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.ScoreboardManager;
import org.bukkit.scoreboard.Team;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.ama.api.ArenaAPI;
import su.nightexpress.ama.api.type.PlayerType;
import su.nightexpress.ama.arena.impl.Arena;
import su.nightexpress.ama.arena.impl.ArenaPlayer;

public class ArenaUtils {
    public static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ISO_LOCAL_TIME;
    private static final Map<UUID, BossBar> MOB_BARS = new HashMap<UUID, BossBar>();

    @NotNull
    public static Optional<Team> getHighlightTeam(@NotNull Arena arena, boolean bl) {
        Team team;
        ScoreboardManager scoreboardManager = ArenaAPI.PLUGIN.getServer().getScoreboardManager();
        if (scoreboardManager == null) {
            return Optional.empty();
        }
        Object object = "mob_hl_" + arena.getId();
        if (((String)object).length() > 16) {
            object = ((String)object).substring(0, 16);
        }
        if ((team = scoreboardManager.getMainScoreboard().getTeam((String)object)) == null) {
            if (bl) {
                team = scoreboardManager.getMainScoreboard().registerNewTeam((String)object);
            } else {
                return Optional.empty();
            }
        }
        team.setColor(arena.getConfig().getGameplayManager().getMobHighlightColor());
        return Optional.of(team);
    }

    @Nullable
    public static BossBar getMobBossBar(@NotNull LivingEntity livingEntity) {
        return ArenaUtils.getMobBossBar(livingEntity.getUniqueId());
    }

    @Nullable
    public static BossBar getMobBossBar(@NotNull UUID uUID) {
        return MOB_BARS.get(uUID);
    }

    public static void addMobBossBar(@NotNull Arena arena, @NotNull LivingEntity livingEntity, @NotNull BossBar bossBar) {
        arena.getPlayers(PlayerType.REAL).stream().map(ArenaPlayer::getPlayer).forEach(arg_0 -> ((BossBar)bossBar).addPlayer(arg_0));
        MOB_BARS.put(livingEntity.getUniqueId(), bossBar);
    }

    public static void removeMobBossBars(@NotNull Player player) {
        MOB_BARS.values().forEach(bossBar -> bossBar.removePlayer(player));
    }

    public static void removeMobBossBar(@NotNull LivingEntity livingEntity) {
        ArenaUtils.removeMobBossBar(livingEntity.getUniqueId());
    }

    public static void removeMobBossBar(@NotNull UUID uUID) {
        BossBar bossBar = ArenaUtils.getMobBossBar(uUID);
        if (bossBar == null) {
            return;
        }
        bossBar.removeAll();
        MOB_BARS.remove(uUID);
    }
}

