/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.arena.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.function.BiConsumer;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nexmedia.engine.api.config.JYML;
import su.nexmedia.engine.utils.Colorizer;
import su.nexmedia.engine.utils.PDCUtil;
import su.nexmedia.engine.utils.StringUtil;
import su.nightexpress.ama.Keys;
import su.nightexpress.ama.api.ArenaAPI;
import su.nightexpress.ama.api.type.GameState;
import su.nightexpress.ama.arena.impl.Arena;
import su.nightexpress.ama.arena.impl.ArenaPlayer;
import su.nightexpress.ama.config.Config;

public class LobbyItem {
    private final Type type;
    private final boolean isEnabled;
    private final ItemStack item;
    private final int slot;

    public LobbyItem(@NotNull Type type, boolean bl, @NotNull ItemStack itemStack, int n) {
        this.type = type;
        this.isEnabled = bl;
        this.item = new ItemStack(itemStack);
        this.slot = n;
        PDCUtil.set((ItemStack)this.item, (NamespacedKey)Keys.ITEM_LOBBY_TYPE, (String)this.getType().name());
    }

    @NotNull
    public Type getType() {
        return this.type;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    @NotNull
    public ItemStack getItem() {
        return new ItemStack(this.item);
    }

    public int getSlot() {
        return this.slot;
    }

    public void use(@NotNull ArenaPlayer arenaPlayer) {
        if (!this.isEnabled()) {
            return;
        }
        this.getType().usage.accept(arenaPlayer.getArena(), arenaPlayer);
    }

    public void give(@NotNull Player player) {
        if (!this.isEnabled()) {
            return;
        }
        player.getInventory().setItem(this.getSlot(), this.getItem());
    }

    @Nullable
    public static LobbyItem get(@NotNull ItemStack itemStack) {
        Type type = LobbyItem.getType(itemStack);
        return type == null ? null : (LobbyItem)((Map)Config.LOBBY_ITEMS.get()).get((Object)type);
    }

    @Nullable
    public static LobbyItem get(@NotNull Type type) {
        return (LobbyItem)((Map)Config.LOBBY_ITEMS.get()).get((Object)type);
    }

    @Nullable
    public static Type getType(@NotNull ItemStack itemStack) {
        String string = PDCUtil.getString((ItemStack)itemStack, (NamespacedKey)Keys.ITEM_LOBBY_TYPE).orElse(null);
        return string == null ? null : (Type)StringUtil.getEnum((String)string, Type.class).orElse(null);
    }

    public static void give(@NotNull Type type, @NotNull Player player) {
        LobbyItem lobbyItem = LobbyItem.get(type);
        if (lobbyItem != null) {
            lobbyItem.give(player);
        }
    }

    public static void write(@NotNull LobbyItem lobbyItem, @NotNull JYML jYML, @NotNull String string) {
        ItemStack itemStack = lobbyItem.getItem();
        PDCUtil.remove((ItemStack)itemStack, (NamespacedKey)Keys.ITEM_LOBBY_TYPE);
        jYML.set(string + ".Enabled", (Object)lobbyItem.isEnabled());
        jYML.set(string + ".Slot", (Object)lobbyItem.getSlot());
        jYML.setItem(string + ".Item", itemStack);
    }

    public static enum Type {
        KIT_SELECT((arena, arenaPlayer) -> ArenaAPI.getKitManager().getSelectMenu().open(arenaPlayer.getPlayer(), 1)),
        KIT_SHOP((arena, arenaPlayer) -> ArenaAPI.getKitManager().getShopMenu().open(arenaPlayer.getPlayer(), 1)),
        EXIT((arena, arenaPlayer) -> arenaPlayer.leaveArena()),
        STATS((arena, arenaPlayer) -> ArenaAPI.getStatsManager().getStatsMenu().open(arenaPlayer.getPlayer(), 1)),
        READY((arena, arenaPlayer) -> arenaPlayer.setState(arenaPlayer.isReady() ? GameState.WAITING : GameState.READY));

        private final BiConsumer<Arena, ArenaPlayer> usage;

        private Type(BiConsumer<Arena, ArenaPlayer> biConsumer) {
            this.usage = biConsumer;
        }

        public int getDefaultSlot() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case KIT_SHOP -> 2;
                case EXIT -> 8;
                case READY -> 6;
                case KIT_SELECT -> 4;
                case STATS -> 0;
            };
        }

        @NotNull
        public ItemStack getDefaultItem() {
            ItemStack itemStack = new ItemStack(Material.EMERALD);
            ItemMeta itemMeta = itemStack.getItemMeta();
            if (itemMeta == null) {
                return itemStack;
            }
            Material material = switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case KIT_SHOP -> {
                    itemMeta.setDisplayName(Colorizer.apply((String)"&d&lKit Shop&7 (Right-Click)"));
                    itemMeta.setLore(Colorizer.apply(new ArrayList<String>(Collections.singletonList("&7Purchase and try new kits!"))));
                    yield Material.ENDER_CHEST;
                }
                case KIT_SELECT -> {
                    itemMeta.setDisplayName(Colorizer.apply((String)"&6&lKit Selector&7 (Right-Click)"));
                    itemMeta.setLore(Colorizer.apply(new ArrayList<String>(Collections.singletonList("&7Select your kit to fight with!"))));
                    yield Material.CHEST;
                }
                case STATS -> {
                    itemMeta.setDisplayName(Colorizer.apply((String)"&b&lStatistics&7 (Right-Click)"));
                    itemMeta.setLore(Colorizer.apply(new ArrayList<String>(Collections.singletonList("&7Check your game stats!"))));
                    yield Material.MAP;
                }
                case READY -> {
                    itemMeta.setDisplayName(Colorizer.apply((String)"&a&lReady State&7 (Right-Click)"));
                    itemMeta.setLore(Colorizer.apply(new ArrayList<String>(Collections.singletonList("&7Are you ready to play?"))));
                    yield Material.LIME_DYE;
                }
                case EXIT -> {
                    itemMeta.setDisplayName(Colorizer.apply((String)"&c&lExit&7 (Right-Click)"));
                    itemMeta.setLore(Colorizer.apply(new ArrayList<String>(Collections.singletonList("&7Leaving so soon?"))));
                    yield Material.REDSTONE;
                }
            };
            itemMeta.addItemFlags(ItemFlag.values());
            itemStack.setItemMeta(itemMeta);
            itemStack.setType(material);
            return itemStack;
        }
    }
}

