/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.arena.wave;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.api.placeholder.Placeholder;
import su.nexmedia.engine.api.placeholder.PlaceholderMap;
import su.nexmedia.engine.utils.random.Rnd;
import su.nightexpress.ama.api.arena.ArenaChild;
import su.nightexpress.ama.arena.editor.wave.WaveMobsEditor;
import su.nightexpress.ama.arena.impl.ArenaConfig;
import su.nightexpress.ama.arena.wave.ArenaWaveMob;

public class ArenaWave
implements ArenaChild,
Placeholder {
    private final ArenaConfig arenaConfig;
    private final String id;
    private final Set<ArenaWaveMob> mobs;
    private final PlaceholderMap placeholderMap;
    private WaveMobsEditor editor;

    public ArenaWave(@NotNull ArenaConfig arenaConfig, @NotNull String string, @NotNull Set<ArenaWaveMob> set) {
        this.arenaConfig = arenaConfig;
        this.id = string.toLowerCase();
        this.mobs = new HashSet<ArenaWaveMob>(set);
        this.placeholderMap = new PlaceholderMap().add("%arena_wave_id%", this::getId).add("%arena_wave_mobs%", () -> String.join((CharSequence)"\n", this.getMobs().stream().map(ArenaWaveMob::getMobId).toList()));
    }

    public void clear() {
        if (this.editor != null) {
            this.editor.clear();
            this.editor = null;
        }
    }

    @NotNull
    public WaveMobsEditor getEditor() {
        if (this.editor == null) {
            this.editor = new WaveMobsEditor(this);
        }
        return this.editor;
    }

    @NotNull
    public PlaceholderMap getPlaceholders() {
        return this.placeholderMap;
    }

    @Override
    @NotNull
    public ArenaConfig getArenaConfig() {
        return this.arenaConfig;
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public Set<ArenaWaveMob> getMobs() {
        return this.mobs;
    }

    @NotNull
    public List<ArenaWaveMob> getMobsByChance() {
        return this.getMobs().stream().filter(arenaWaveMob -> arenaWaveMob.getAmount() > 0 && Rnd.chance((double)arenaWaveMob.getChance())).toList();
    }
}

