/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.command;

import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permission;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.command.AbstractCommand;
import su.nexmedia.engine.api.command.CommandResult;
import su.nightexpress.ama.AMA;
import su.nightexpress.ama.Perms;
import su.nightexpress.ama.api.type.GameState;
import su.nightexpress.ama.arena.impl.Arena;
import su.nightexpress.ama.config.Lang;

public class ForceEndCommand
extends AbstractCommand<AMA> {
    public ForceEndCommand(@NotNull AMA aMA) {
        super((NexPlugin)aMA, new String[]{"forceend"}, (Permission)Perms.COMMAND_FORCEEND);
        this.setDescription(aMA.getMessage(Lang.COMMAND_FORCE_END_DESC));
        this.setUsage(aMA.getMessage(Lang.COMMAND_FORCE_END_USAGE));
    }

    @NotNull
    public List<String> getTab(@NotNull Player player, int n, @NotNull String[] stringArray) {
        if (n == 1) {
            return ((AMA)this.plugin).getArenaManager().getArenas().stream().filter(arena -> arena.getState() == GameState.INGAME).map(Arena::getId).toList();
        }
        return super.getTab(player, n, stringArray);
    }

    public void onExecute(@NotNull CommandSender commandSender, @NotNull CommandResult commandResult) {
        if (commandResult.length() < 2) {
            this.printUsage(commandSender);
            return;
        }
        Arena arena = ((AMA)this.plugin).getArenaManager().getArenaById(commandResult.getArg(1));
        if (arena == null) {
            ((AMA)this.plugin).getMessage(Lang.ARENA_ERROR_INVALID).send(commandSender);
            return;
        }
        if (arena.getState() != GameState.INGAME) {
            ((AMA)this.plugin).getMessage(Lang.COMMAND_FORCE_END_ERROR_NOT_IN_GAME).replace(arena.replacePlaceholders()).send(commandSender);
            return;
        }
        ((AMA)this.plugin).getMessage(Lang.COMMAND_FORCE_END_DONE).replace(arena.replacePlaceholders()).send(commandSender);
        arena.stop();
    }
}

