/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.command;

import java.util.Arrays;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permission;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.command.AbstractCommand;
import su.nexmedia.engine.api.command.CommandResult;
import su.nexmedia.engine.api.manager.AbstractConfigHolder;
import su.nightexpress.ama.AMA;
import su.nightexpress.ama.Perms;
import su.nightexpress.ama.arena.impl.Arena;
import su.nightexpress.ama.arena.impl.ArenaPlayer;
import su.nightexpress.ama.arena.region.ArenaRegion;
import su.nightexpress.ama.config.Lang;

public class RegionCommand
extends AbstractCommand<AMA> {
    public RegionCommand(@NotNull AMA aMA) {
        super((NexPlugin)aMA, new String[]{"region"}, (Permission)Perms.COMMAND_REGION);
    }

    @NotNull
    public String getUsage() {
        return ((AMA)this.plugin).getMessage(Lang.Command_Region_Usage).getLocalized();
    }

    @NotNull
    public String getDescription() {
        return ((AMA)this.plugin).getMessage(Lang.Command_Region_Desc).getLocalized();
    }

    public boolean isPlayerOnly() {
        return true;
    }

    @NotNull
    public List<String> getTab(@NotNull Player player, int n, @NotNull String[] stringArray) {
        if (n == 1) {
            return Arrays.asList("lock", "unlock");
        }
        if (n == 2) {
            ArenaPlayer arenaPlayer = ArenaPlayer.getPlayer(player);
            if (arenaPlayer == null) {
                return super.getTab(player, n, stringArray);
            }
            return arenaPlayer.getArena().getConfig().getRegionManager().getRegions().stream().map(AbstractConfigHolder::getId).toList();
        }
        return super.getTab(player, n, stringArray);
    }

    public void onExecute(@NotNull CommandSender commandSender, @NotNull CommandResult commandResult) {
        if (commandResult.length() < 3) {
            this.printUsage(commandSender);
            return;
        }
        Player player = (Player)commandSender;
        ArenaPlayer arenaPlayer = ArenaPlayer.getPlayer(player);
        if (arenaPlayer == null) {
            ((AMA)this.plugin).getMessage(Lang.Command_Region_State_Error_NotInGame).send(commandSender);
            return;
        }
        Arena arena = arenaPlayer.getArena();
        boolean bl = commandResult.getArg(1).equalsIgnoreCase("lock");
        boolean bl2 = commandResult.getArg(1).equalsIgnoreCase("unlock");
        if (!bl && !bl2) {
            this.printUsage(commandSender);
            return;
        }
        String string = commandResult.getArg(2);
        ArenaRegion arenaRegion = arena.getConfig().getRegionManager().getRegion(string);
        if (arenaRegion == null) {
            ((AMA)this.plugin).getMessage(Lang.Command_Region_State_Error_InvalidRegion).send(commandSender);
            return;
        }
        if (bl) {
            arenaRegion.lock();
        } else {
            arenaRegion.unlock();
        }
        ((AMA)this.plugin).getMessage(Lang.Command_Region_State_Done).replace(arenaRegion.replacePlaceholders()).send(commandSender);
    }
}

