/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.command.coins;

import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permission;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.command.AbstractCommand;
import su.nexmedia.engine.api.command.CommandResult;
import su.nexmedia.engine.utils.CollectionsUtil;
import su.nightexpress.ama.AMA;
import su.nightexpress.ama.Perms;
import su.nightexpress.ama.api.currency.Currency;
import su.nightexpress.ama.config.Lang;

public class BalanceCommand
extends AbstractCommand<AMA> {
    private final Currency currency;

    public BalanceCommand(@NotNull AMA aMA, @NotNull Currency currency) {
        super((NexPlugin)aMA, new String[]{"balance"}, (Permission)Perms.COMMAND_BALANCE);
        this.setDescription(aMA.getMessage(Lang.COMMAND_COINS_BALANCE_DESC));
        this.setUsage(aMA.getMessage(Lang.COMMAND_COINS_BALANCE_USAGE));
        this.currency = currency;
    }

    @NotNull
    public List<String> getTab(@NotNull Player player, int n, @NotNull String[] stringArray) {
        if (n == 2 && player.hasPermission((Permission)Perms.COMMAND_BALANCE_OTHERS)) {
            return CollectionsUtil.playerNames((Player)player);
        }
        return super.getTab(player, n, stringArray);
    }

    public void onExecute(@NotNull CommandSender commandSender, @NotNull CommandResult commandResult) {
        String string = commandResult.getArg(2, commandSender.getName());
        if (!string.equalsIgnoreCase(commandSender.getName()) && !commandSender.hasPermission((Permission)Perms.COMMAND_BALANCE_OTHERS)) {
            this.errorPermission(commandSender);
            return;
        }
        ((AMA)this.plugin).getUserManager().getUserDataAsync(string).thenAccept(arenaUser -> {
            if (arenaUser == null) {
                this.errorPlayer(commandSender);
                return;
            }
            boolean bl = commandSender.getName().equalsIgnoreCase(arenaUser.getName());
            ((AMA)this.plugin).getMessage(bl ? Lang.COMMAND_COINS_BALANCE_DONE_SELF : Lang.COMMAND_COINS_BALANCE_DONE_OTHERS).replace("%player_name%", (Object)arenaUser.getName()).replace("%amount%", (Object)this.currency.format(arenaUser.getCoins())).send(commandSender);
        });
    }
}

