/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.command.coins;

import java.util.Arrays;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permission;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.command.AbstractCommand;
import su.nexmedia.engine.api.command.CommandResult;
import su.nexmedia.engine.api.lang.LangMessage;
import su.nexmedia.engine.utils.CollectionsUtil;
import su.nexmedia.engine.utils.NumberUtil;
import su.nightexpress.ama.AMA;
import su.nightexpress.ama.Placeholders;
import su.nightexpress.ama.api.currency.Currency;

public abstract class ManageCommand
extends AbstractCommand<AMA> {
    protected final Currency currency;
    private LangMessage doneMessage;

    public ManageCommand(@NotNull AMA aMA, @NotNull Currency currency, @NotNull String[] stringArray, @NotNull Permission permission) {
        super((NexPlugin)aMA, stringArray, permission);
        this.currency = currency;
    }

    protected void setDoneMessage(@NotNull LangMessage langMessage) {
        this.doneMessage = langMessage;
    }

    protected abstract void modify(@NotNull Player var1, double var2);

    @NotNull
    public List<String> getTab(@NotNull Player player, int n, @NotNull String[] stringArray) {
        if (n == 2) {
            return CollectionsUtil.playerNames((Player)player);
        }
        if (n == 3) {
            return Arrays.asList("1", "10", "100");
        }
        return super.getTab(player, n, stringArray);
    }

    public void onExecute(@NotNull CommandSender commandSender, @NotNull CommandResult commandResult) {
        if (commandResult.length() < 5) {
            this.printUsage(commandSender);
            return;
        }
        Player player = ((AMA)this.plugin).getServer().getPlayer(commandResult.getArg(2));
        if (player == null) {
            this.errorPlayer(commandSender);
            return;
        }
        double d = commandResult.getDouble(3, 0.0);
        if (d <= 0.0) {
            this.errorNumber(commandSender, commandResult.getArg(3));
            return;
        }
        this.modify(player, d);
        this.doneMessage.replace(this.currency.replacePlaceholders()).replace(Placeholders.forPlayer((Player)player)).replace("%amount%", (Object)NumberUtil.format((double)d)).send(commandSender);
    }
}

