/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.config;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.inventory.ItemStack;
import su.nexmedia.engine.api.config.JOption;
import su.nexmedia.engine.utils.Colorizer;
import su.nightexpress.ama.api.hologram.HologramType;
import su.nightexpress.ama.arena.board.ArenaBoardConfig;
import su.nightexpress.ama.arena.util.LobbyItem;
import su.nightexpress.ama.sign.type.SignType;

public class Config {
    public static final JOption<Boolean> DEBUG_MOB_SPAWN = JOption.create((String)"Debug.Mob_Spawning", (boolean)false, (String[])new String[]{"Enable this setting if you're experiencing issues with mob spawn on arenas.", "Then send debug logs from the console to the developer."});
    public static final JOption<Boolean> CHAT_ENABLED = JOption.create((String)"Chat.Enabled", (boolean)false, (String[])new String[]{"When enabled, players in arenas will have their own chat."});
    public static final JOption<String> CHAT_FORMAT = JOption.create((String)"Chat.Format", (String)"&7(&6%player_kit_name%&7) &a%player_name%: &f%message%", (String[])new String[]{"Sets the chat format.", "You can use 'Arena', 'Arena Player' placeholders: https://github.com/nulli0n/AdvancedMobArena-spigot/wiki/Internal-Placeholders", "Default Placeholders:", "- %player_name% - Player name.", "- %message% - Message text.", "PlaceholderAPI is also supported."}).mapReader(Colorizer::apply);
    public static final JOption<Boolean> ARENA_CLEAR_POTION_EFFECTS = JOption.create((String)"Arena.Clear_Potion_Effects", (boolean)true, (String[])new String[]{"Sets whether or not player's potion effects should be removed when join/leave arena."});
    public static final JOption<Integer> ARENA_END_COUNTDOWN_DEFEAT = JOption.create((String)"Arena.End_Countdown.Defeat", (int)10, (String[])new String[]{"Sets how soon (in seconds) game on the arena will be stopped in case of defeat?"});
    public static final JOption<Integer> ARENA_END_COUNTDOWN_VICTORY = JOption.create((String)"Arena.End_Countdown.Victory", (int)10, (String[])new String[]{"Sets how soon (in seconds) game on the arena will be stopped in case of victory?"});
    public static final JOption<Integer> LOBBY_READY_DROP_TIMER = JOption.create((String)"Lobby.Ready_State.Drop_Timer_To", (int)15, (String[])new String[]{"Instantly decreases lobby countdown timer to the specified value, if all players are ready to play.", "Set this to -1 to disable feature."});
    public static final JOption<Boolean> LOBBY_READY_FREEZE_TIMER_WHEN_DROPPED = JOption.create((String)"Lobby.Ready_State.Freeze_Dropped_Timer_When_Not_Ready", (boolean)false, (String[])new String[]{"When enabled, lobby timer will be stopped, when someone changes his state as 'not ready'.", "This option will only have effect if lobby timer was already decreased by the setting above."});
    public static final JOption<Map<LobbyItem.Type, LobbyItem>> LOBBY_ITEMS = new JOption("Lobby.Items", (jYML, string, map) -> Stream.of(LobbyItem.Type.values()).collect(Collectors.toMap(type -> type, type -> {
        boolean bl = jYML.getBoolean(string + "." + type.name() + ".Enabled");
        int n = jYML.getInt(string + "." + type.name() + ".Slot");
        ItemStack itemStack = jYML.getItem(string + "." + type.name() + ".Item");
        return new LobbyItem((LobbyItem.Type)((Object)((Object)type)), bl, itemStack, n);
    })), () -> Stream.of(LobbyItem.Type.values()).collect(Collectors.toMap(type -> type, type -> new LobbyItem((LobbyItem.Type)((Object)((Object)type)), true, type.getDefaultItem(), type.getDefaultSlot()))), new String[]{"Lobby items settings.", "Disabled items won't be given to players and will have no effect.", "Slot is where lobby item will be added in player's inventory.", "For 'Item' option, please check: https://github.com/nulli0n/NexEngine-spigot/wiki/Configuration-Tips#item-sections"}).setWriter((jYML, string, map) -> map.forEach((type, lobbyItem) -> LobbyItem.write(lobbyItem, jYML, string + "." + type.name())));
    public static final JOption<Boolean> SIGNS_ENABLED = JOption.create((String)"Signs.Enabled", (boolean)true, (String[])new String[]{"Enables/Disables usable signs feature."});
    public static final JOption<Boolean> SIGNS_GLOWING = JOption.create((String)"Signs.Glowing", (boolean)true, (String[])new String[]{"Makes the sign text glowing."});
    public static final JOption<Map<SignType, List<String>>> SIGNS_FORMAT = new JOption("Signs.Format", (jYML, string, map) -> Stream.of(SignType.values()).collect(Collectors.toMap(signType -> signType, signType -> Colorizer.apply((List)jYML.getStringList(string + "." + signType.name())))), () -> Stream.of(SignType.values()).collect(Collectors.toMap(signType -> signType, SignType::getDefaultText)), new String[]{"Text to dispay on arena signs.", "Depends on a Sign Type, you can use different placeholders: https://github.com/nulli0n/AdvancedMobArena-spigot/wiki/Internal-Placeholders"}).setWriter((jYML, string, map) -> map.forEach((signType, list) -> jYML.set(string + "." + signType.name(), list)));
    public static final JOption<Boolean> HOLOGRAMS_ENABLED = JOption.create((String)"Holograms.Enabled", (boolean)true, (String[])new String[]{"Enables the Holograms feature.", "Supported Plugins: HolographicDisplays, DecentHolograms"});
    public static final JOption<Map<HologramType, List<String>>> HOLOGRAMS_FORMAT = new JOption("Holograms.Format", (jYML, string, map) -> Stream.of(HologramType.values()).collect(Collectors.toMap(hologramType -> hologramType, hologramType -> Colorizer.apply((List)jYML.getStringList(string + "." + hologramType.name())))), () -> Stream.of(HologramType.values()).collect(Collectors.toMap(hologramType -> hologramType, HologramType::getDefaultFormat)), new String[]{"Text to dispay on arena holograms.", "Depends on a Hologram Type, you can use different placeholders: https://github.com/nulli0n/AdvancedMobArena-spigot/wiki/Internal-Placeholders"}).setWriter((jYML, string, map) -> map.forEach((hologramType, list) -> jYML.set(string + "." + hologramType.name(), list)));
    public static final JOption<Map<String, ArenaBoardConfig>> SCOREBOARDS = new JOption("Scoreboard", (jYML, string3, map) -> jYML.getSection(string3).stream().collect(Collectors.toMap(string -> string, string2 -> ArenaBoardConfig.read(jYML, string3 + "." + string2, string2))), () -> {
        HashMap<String, ArenaBoardConfig> hashMap = new HashMap<String, ArenaBoardConfig>();
        ArenaBoardConfig arenaBoardConfig = new ArenaBoardConfig("default", "&c&lMOB ARENA", Arrays.asList("&c\u25b8 &7Arena: &c%arena_name%", "&c\u25b8 &7Current wave: &c%arena_wave_number%", "&c\u25b8 &7Mobs: &a%arena_mobs_alive%&7/&e%arena_mobs_left%&7/&c%arena_mobs_total%", "&c\u25b8 &7Players: &c%arena_alive_players%&7/&c%arena_players_max%", "&c\u25b8 &7Timeleft: &c%arena_timeleft%", "&c\u25b8 &7Next wave in: &c%arena_wave_next_in% sec.", "&7       &e&lYOUR STATS     &7", "&e\u25b8 &6Score: &e%player_score%", "&e\u25b8 &6Kills: &e%player_kills%", "&e\u25b8 &6Streak: &ex%player_streak% &7(%player_streak_decay% sec.)", "&e\u25b8 &6Coins: &e%ama_coins%", "&r"));
        hashMap.put(arenaBoardConfig.getId(), arenaBoardConfig);
        return hashMap;
    }, new String[]{"Here you can create your own scoreboard format(s) for different arenas.", "To set the scoreboard format per arena, use in-game editor.", "You can use 'Arena', 'Arena Player' placeholders: https://github.com/nulli0n/AdvancedMobArena-spigot/wiki/Internal-Placeholders", "PlaceholderAPI is also supported here."}).setWriter((jYML, string, map) -> map.forEach((string2, arenaBoardConfig) -> ArenaBoardConfig.write(arenaBoardConfig, jYML, string + "." + string2)));
}

