/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.currency.impl;

import java.util.HashSet;
import java.util.Set;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.api.placeholder.PlaceholderMap;
import su.nightexpress.ama.api.currency.CurrencyHandler;
import su.nightexpress.coinsengine.api.CoinsEngineAPI;
import su.nightexpress.coinsengine.api.currency.Currency;

public class CoinsEngineCurrency
implements su.nightexpress.ama.api.currency.Currency,
CurrencyHandler {
    private final Currency currency;

    public CoinsEngineCurrency(@NotNull Currency currency) {
        this.currency = currency;
    }

    @NotNull
    public static Set<CoinsEngineCurrency> getCurrencies() {
        HashSet<CoinsEngineCurrency> hashSet = new HashSet<CoinsEngineCurrency>();
        CoinsEngineAPI.getCurrencyManager().getCurrencies().forEach(currency -> {
            if (!currency.isVaultEconomy()) {
                hashSet.add(new CoinsEngineCurrency((Currency)currency));
            }
        });
        return hashSet;
    }

    @Override
    @NotNull
    public String formatValue(double d) {
        return this.currency.formatValue(d);
    }

    @Override
    @NotNull
    public CurrencyHandler getHandler() {
        return this;
    }

    @Override
    @NotNull
    public String getId() {
        return "coinsengine_" + this.currency.getId();
    }

    @Override
    @NotNull
    public String getName() {
        return this.currency.getName();
    }

    @Override
    @NotNull
    public String getFormat() {
        return this.currency.getFormat();
    }

    @NotNull
    public PlaceholderMap getPlaceholders() {
        return this.currency.getPlaceholders();
    }

    @Override
    public double getBalance(@NotNull Player player) {
        return CoinsEngineAPI.getBalance((Player)player, (Currency)this.currency);
    }

    @Override
    public void give(@NotNull Player player, double d) {
        CoinsEngineAPI.addBalance((Player)player, (Currency)this.currency, (double)d);
    }

    @Override
    public void take(@NotNull Player player, double d) {
        CoinsEngineAPI.removeBalance((Player)player, (Currency)this.currency, (double)d);
    }

    @Override
    public void set(@NotNull Player player, double d) {
        CoinsEngineAPI.setBalance((Player)player, (Currency)this.currency, (double)d);
    }
}

