/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.kit;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.Permission;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.config.JYML;
import su.nexmedia.engine.api.manager.AbstractConfigHolder;
import su.nexmedia.engine.api.manager.ConfigHolder;
import su.nexmedia.engine.api.placeholder.Placeholder;
import su.nexmedia.engine.api.placeholder.PlaceholderMap;
import su.nexmedia.engine.lang.LangManager;
import su.nexmedia.engine.utils.Colorizer;
import su.nexmedia.engine.utils.ItemUtil;
import su.nexmedia.engine.utils.LocationUtil;
import su.nexmedia.engine.utils.NumberUtil;
import su.nexmedia.engine.utils.PlayerUtil;
import su.nightexpress.ama.AMA;
import su.nightexpress.ama.Perms;
import su.nightexpress.ama.api.currency.Currency;
import su.nightexpress.ama.api.hologram.HologramHolder;
import su.nightexpress.ama.api.hologram.HologramType;
import su.nightexpress.ama.api.type.PlayerType;
import su.nightexpress.ama.arena.impl.Arena;
import su.nightexpress.ama.arena.impl.ArenaPlayer;
import su.nightexpress.ama.config.Lang;
import su.nightexpress.ama.data.impl.ArenaUser;
import su.nightexpress.ama.hologram.HologramManager;
import su.nightexpress.ama.kit.editor.KitMainEditor;
import su.nightexpress.ama.kit.menu.KitPreviewMenu;

public class Kit
extends AbstractConfigHolder<AMA>
implements ConfigHolder,
HologramHolder,
Placeholder {
    private boolean isDefault;
    private String name;
    private List<String> description;
    private ItemStack icon;
    private Currency currency;
    private double cost;
    private boolean isPermissionRequired;
    private List<String> commands;
    private Set<PotionEffect> potionEffects;
    private ItemStack[] armor;
    private ItemStack[] items;
    private ItemStack[] extras;
    private final Set<UUID> hologramIds = new HashSet<UUID>();
    private final Set<Location> hologramLocations = new HashSet<Location>();
    private final PlaceholderMap placeholderMap = new PlaceholderMap().add("%kit_id%", () -> ((Kit)this).getId()).add("%kit_name%", this::getName).add("%kit_description%", () -> String.join((CharSequence)"\n", this.getDescription())).add("%kit_permission%", this::getPermission).add("%kit_is_default%", () -> LangManager.getBoolean((boolean)this.isDefault())).add("%kit_is_permission%", () -> LangManager.getBoolean((boolean)this.isPermissionRequired())).add("%kit_commands%", () -> String.join((CharSequence)"\n", this.getCommands())).add("%kit_potion_effects%", () -> String.join((CharSequence)"\n", this.getPotionEffects().stream().map(potionEffect -> potionEffect.getType().getName() + " " + NumberUtil.toRoman((int)(potionEffect.getAmplifier() + 1))).toList())).add("%kit_cost%", () -> this.getCurrency().format(this.getCost())).add("%kit_icon_lore%", () -> String.join((CharSequence)"\n", ItemUtil.getLore((ItemStack)this.getIcon()))).add("%kit_icon_material%", () -> this.getIcon().getType().name()).add("%kit_currency%", () -> this.getCurrency().getName());
    private KitPreviewMenu preview;
    private KitMainEditor editor;

    public Kit(@NotNull AMA aMA, @NotNull JYML jYML) {
        super((NexPlugin)aMA, jYML);
    }

    public boolean load() {
        this.setDefault(this.cfg.getBoolean("Default"));
        this.setName(this.cfg.getString("Name", this.getId()));
        this.setDescription(this.cfg.getStringList("Description"));
        this.setCost(this.cfg.getDouble("Cost"));
        this.setPermissionRequired(this.cfg.getBoolean("Permission_Required"));
        Currency currency = ((AMA)this.plugin).getCurrencyManager().getCurrency(this.cfg.getString("Currency", ""));
        if (currency == null) {
            currency = ((AMA)this.plugin).getCurrencyManager().getAny();
        }
        this.setCurrency(currency);
        ItemStack itemStack = this.cfg.getItem("Icon");
        if (itemStack.getType().isAir()) {
            itemStack = new ItemStack(Material.DIAMOND_SWORD);
        }
        this.setIcon(itemStack);
        this.setCommands(this.cfg.getStringList("Content.Commands"));
        this.setPotionEffects(new HashSet<PotionEffect>());
        for (String string : this.cfg.getSection("Content.Potion_Effects")) {
            PotionEffectType potionEffectType = PotionEffectType.getByName((String)string.toUpperCase());
            if (potionEffectType == null) {
                ((AMA)this.plugin).error("Invalid potion effect '" + string + "' in '" + this.getId() + "' kit!");
                continue;
            }
            int n = this.cfg.getInt("Content.Potion_Effects." + string);
            if (n == 0) continue;
            PotionEffect potionEffect = new PotionEffect(potionEffectType, 72000, n - 1);
            this.getPotionEffects().add(potionEffect);
        }
        this.setArmor(this.cfg.getItemsEncoded("Content.Armor"));
        this.setItems(this.cfg.getItemsEncoded("Content.Inventory"));
        this.setExtras(this.cfg.getItemsEncoded("Content.Extras"));
        this.hologramLocations.addAll(this.cfg.getStringSet("Hologram.Locations").stream().map(LocationUtil::deserialize).filter(Objects::nonNull).toList());
        ItemUtil.replace((ItemStack)this.icon, (UnaryOperator)this.replacePlaceholders());
        return true;
    }

    public void onSave() {
        this.updateHolograms();
        this.cfg.set("Name", (Object)this.getName());
        this.cfg.set("Description", this.getDescription());
        this.cfg.set("Default", (Object)this.isDefault());
        this.cfg.set("Cost", (Object)this.getCost());
        this.cfg.set("Currency", (Object)this.getCurrency().getId());
        this.cfg.set("Permission_Required", (Object)this.isPermissionRequired());
        this.cfg.setItem("Icon", this.getIcon());
        this.cfg.set("Content.Commands", this.getCommands());
        this.cfg.set("Content.Potion_Effects", null);
        this.getPotionEffects().forEach(potionEffect -> this.cfg.set("Content.Potion_Effects." + potionEffect.getType().getName(), (Object)(potionEffect.getAmplifier() + 1)));
        this.cfg.setItemsEncoded("Content.Armor", Arrays.asList(this.getArmor()));
        this.cfg.setItemsEncoded("Content.Inventory", Arrays.asList(this.getItems()));
        this.cfg.setItemsEncoded("Content.Extras", Arrays.asList(this.getExtras()));
        this.cfg.set("Hologram.Locations", this.getHologramLocations().stream().map(LocationUtil::serialize).toList());
    }

    public void clear() {
        if (this.preview != null) {
            this.preview.clear();
            this.preview = null;
        }
        if (this.editor != null) {
            this.editor.clear();
            this.editor = null;
        }
        ((AMA)this.plugin).getPluginManager().removePermission(this.getPermission());
        this.removeHolograms();
    }

    @NotNull
    public PlaceholderMap getPlaceholders() {
        return this.placeholderMap;
    }

    public boolean hasPermission(@NotNull Player player) {
        return !this.isPermissionRequired() || player.hasPermission(this.getPermission());
    }

    public void applyPotionEffects(@NotNull Player player) {
        this.getPotionEffects().forEach(potionEffect -> {
            if (!player.hasPotionEffect(potionEffect.getType())) {
                player.addPotionEffect(potionEffect);
            }
        });
    }

    public void give(@NotNull ArenaPlayer arenaPlayer) {
        Player player = arenaPlayer.getPlayer();
        player.getInventory().setContents(this.getItems());
        player.getInventory().setArmorContents(this.getArmor());
        player.getInventory().setExtraContents(this.getExtras());
        this.getCommands().forEach(string -> PlayerUtil.dispatchCommand((Player)player, (String)string));
        arenaPlayer.setKit(this);
    }

    @NotNull
    public KitMainEditor getEditor() {
        if (this.editor == null) {
            this.editor = new KitMainEditor(this);
        }
        return this.editor;
    }

    @NotNull
    public KitPreviewMenu getPreview() {
        if (this.preview == null) {
            this.preview = new KitPreviewMenu(this);
        }
        return this.preview;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public void setDefault(boolean bl) {
        this.isDefault = bl;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(@NotNull String string) {
        this.name = Colorizer.apply((String)string);
    }

    @NotNull
    public List<String> getDescription() {
        return this.description;
    }

    public void setDescription(@NotNull List<String> list) {
        this.description = Colorizer.apply(list);
    }

    @NotNull
    public ItemStack getIcon() {
        return new ItemStack(this.icon);
    }

    public void setIcon(@NotNull ItemStack itemStack) {
        this.icon = new ItemStack(itemStack);
    }

    @NotNull
    public Currency getCurrency() {
        return this.currency;
    }

    public void setCurrency(@NotNull Currency currency) {
        this.currency = currency;
    }

    public double getCost() {
        return this.cost;
    }

    public void setCost(double d) {
        this.cost = d;
    }

    public boolean isPermissionRequired() {
        return this.isPermissionRequired;
    }

    public void setPermissionRequired(boolean bl) {
        this.isPermissionRequired = bl;
    }

    @NotNull
    public String getPermission() {
        return "advancedmobarena.kit." + this.getId();
    }

    @NotNull
    public List<String> getCommands() {
        return this.commands;
    }

    public void setCommands(@NotNull List<String> list) {
        this.commands = list;
    }

    @NotNull
    public Set<PotionEffect> getPotionEffects() {
        return this.potionEffects;
    }

    public void setPotionEffects(@NotNull Set<PotionEffect> set) {
        this.potionEffects = set;
    }

    @NotNull
    public ItemStack[] getArmor() {
        return this.armor;
    }

    public void setArmor(@NotNull ItemStack[] itemStackArray) {
        this.armor = Arrays.copyOf(this.fineItems(itemStackArray), 4);
    }

    @NotNull
    public ItemStack[] getItems() {
        return this.items;
    }

    public void setItems(@NotNull ItemStack[] itemStackArray) {
        this.items = Arrays.copyOf(this.fineItems(itemStackArray), 27);
    }

    public ItemStack[] getExtras() {
        return this.extras;
    }

    public void setExtras(@NotNull ItemStack[] itemStackArray) {
        this.extras = Arrays.copyOf(this.fineItems(itemStackArray), 1);
    }

    private ItemStack[] fineItems(@NotNull ItemStack[] itemStackArray) {
        for (int i = 0; i < itemStackArray.length; ++i) {
            if (itemStackArray[i] != null) continue;
            itemStackArray[i] = new ItemStack(Material.AIR);
        }
        return itemStackArray;
    }

    @Override
    public void updateHolograms() {
        HologramHolder.super.updateHolograms();
        this.setHologramClick(player -> {
            ArenaPlayer arenaPlayer = ArenaPlayer.getPlayer(player);
            if (arenaPlayer == null) {
                return;
            }
            if (player.isSneaking()) {
                this.getPreview().open(player, 1);
            } else {
                this.buy(arenaPlayer);
            }
        });
    }

    @Override
    @NotNull
    public HologramType getHologramType() {
        return HologramType.KIT;
    }

    @Override
    @NotNull
    public List<String> getHologramFormat() {
        List<String> list = HologramManager.getFormat(this.getHologramType());
        list.replaceAll(this.replacePlaceholders());
        return list.stream().map(string -> string.split("\n")).flatMap(Stream::of).toList();
    }

    @Override
    @NotNull
    public Set<UUID> getHologramIds() {
        return this.hologramIds;
    }

    @Override
    @NotNull
    public Set<Location> getHologramLocations() {
        return this.hologramLocations;
    }

    public boolean buy(@NotNull ArenaPlayer arenaPlayer) {
        double d;
        Player player = arenaPlayer.getPlayer();
        if (!this.hasPermission(player)) {
            ((AMA)this.plugin).getMessage(Lang.Kit_Buy_Error_NoPermission).send((CommandSender)player);
            return false;
        }
        ArenaUser arenaUser = (ArenaUser)((AMA)this.plugin).getUserManager().getUserData(player);
        boolean bl = ((AMA)this.plugin).getKitManager().isSavePurchasedKits();
        if (bl && arenaUser.hasKit(this)) {
            arenaPlayer.setKit(this);
            return true;
        }
        double d2 = this.getCurrency().getHandler().getBalance(player);
        double d3 = d = player.hasPermission((Permission)Perms.BYPASS_KIT_COST) ? 0.0 : this.getCost();
        if (d > 0.0) {
            if (d2 < d) {
                ((AMA)this.plugin).getMessage(Lang.Kit_Buy_Error_NoMoney).replace(this.replacePlaceholders()).send((CommandSender)player);
                player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_HURT, 1.0f, 1.0f);
                return false;
            }
            this.getCurrency().getHandler().take(player, d);
        }
        ((AMA)this.plugin).getMessage(Lang.Kit_Buy_Success).replace(this.replacePlaceholders()).send((CommandSender)player);
        player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.0f);
        if (bl) {
            arenaUser.addKit(this);
        } else {
            arenaPlayer.setKit(this);
        }
        return true;
    }

    public boolean isAvailable(@NotNull ArenaPlayer arenaPlayer2, boolean bl) {
        int n;
        Arena arena = arenaPlayer2.getArena();
        Player player = arenaPlayer2.getPlayer();
        if (!arena.getConfig().getGameplayManager().isKitsEnabled()) {
            if (bl) {
                ((AMA)this.plugin).getMessage(Lang.Arena_Game_Restrict_Kits).send((CommandSender)player);
            }
            return false;
        }
        if (!arena.getConfig().getGameplayManager().isKitAllowed(this.getId())) {
            if (bl) {
                ((AMA)this.plugin).getMessage(Lang.Kit_Select_Error_Disabled).send((CommandSender)player);
            }
            return false;
        }
        if (!this.hasPermission(player)) {
            if (bl) {
                ((AMA)this.plugin).getMessage(Lang.Kit_Select_Error_NoPermission).send((CommandSender)player);
            }
            return false;
        }
        int n2 = arena.getConfig().getGameplayManager().getKitLimit(this.getId());
        if (n2 >= 0 && (n = (int)arena.getPlayers(PlayerType.REAL).stream().filter(arenaPlayer -> arenaPlayer.getKit() != null && arenaPlayer.getKit().equals(this)).count()) >= n2) {
            if (bl) {
                ((AMA)this.plugin).getMessage(Lang.Kit_Select_Error_Limit).send((CommandSender)player);
            }
            return false;
        }
        return true;
    }
}

