/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.kit.editor;

import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.menu.impl.EditorMenu;
import su.nexmedia.engine.api.menu.impl.Menu;
import su.nexmedia.engine.api.menu.impl.MenuViewer;
import su.nexmedia.engine.editor.EditorManager;
import su.nexmedia.engine.utils.ItemUtil;
import su.nexmedia.engine.utils.PlayerUtil;
import su.nexmedia.engine.utils.StringUtil;
import su.nightexpress.ama.AMA;
import su.nightexpress.ama.api.currency.Currency;
import su.nightexpress.ama.config.Lang;
import su.nightexpress.ama.editor.EditorLocales;
import su.nightexpress.ama.kit.Kit;

public class KitMainEditor
extends EditorMenu<AMA, Kit> {
    public KitMainEditor(@NotNull Kit kit) {
        super((NexPlugin)((AMA)kit.plugin()), (Object)kit, "Arena Kit Editor", 45);
        this.addReturn(new int[]{40}).setClick((menuViewer, inventoryClickEvent) -> ((AMA)this.plugin).getEditor().getKitEditor().openNextTick(menuViewer, 1));
        this.addItem(Material.GOLD_NUGGET, EditorLocales.KIT_COST, new int[]{2}).setClick((menuViewer, inventoryClickEvent) -> this.handleInput(menuViewer, Lang.Editor_Kit_Enter_Cost, inputWrapper -> {
            kit.setCost(inputWrapper.asDouble());
            kit.save();
            return true;
        }));
        this.addItem(Material.LIME_DYE, EditorLocales.KIT_DEFAULT, new int[]{4}).setClick((menuViewer, inventoryClickEvent) -> {
            kit.setDefault(!kit.isDefault());
            this.save(menuViewer);
        }).getOptions().addDisplayModifier((menuViewer, itemStack) -> itemStack.setType(kit.isDefault() ? Material.LIME_DYE : Material.GRAY_DYE));
        this.addItem(Material.EMERALD, EditorLocales.KIT_CURRENCY, new int[]{6}).setClick((menuViewer, inventoryClickEvent) -> {
            EditorManager.suggestValues((Player)menuViewer.getPlayer(), ((AMA)this.plugin).getCurrencyManager().getCurrencyIds(), (boolean)true);
            this.handleInput(menuViewer, Lang.EDITOR_GENERIC_ENTER_CURRENCY, inputWrapper -> {
                Currency currency = ((AMA)this.plugin).getCurrencyManager().getCurrency(inputWrapper.getTextRaw());
                if (currency == null) {
                    EditorManager.error((Player)menuViewer.getPlayer(), (String)((AMA)this.plugin).getMessage(Lang.ERROR_CURRENCY_INVALID).getLocalized());
                    return false;
                }
                kit.setCurrency(currency);
                kit.save();
                return true;
            });
        });
        this.addItem(Material.NAME_TAG, EditorLocales.KIT_NAME, new int[]{11}).setClick((menuViewer, inventoryClickEvent) -> this.handleInput(menuViewer, Lang.EDITOR_GENERIC_ENTER_NAME, inputWrapper -> {
            kit.setName(inputWrapper.getText());
            kit.save();
            return true;
        }));
        this.addItem(Material.MAP, EditorLocales.KIT_DESCRIPTION, new int[]{12}).setClick((menuViewer, inventoryClickEvent) -> {
            if (inventoryClickEvent.isRightClick()) {
                kit.getDescription().clear();
                this.save(menuViewer);
                return;
            }
            this.handleInput(menuViewer, Lang.EDITOR_GENERIC_ENTER_DESCRIPTION, inputWrapper -> {
                kit.getDescription().add(inputWrapper.getText());
                kit.save();
                return true;
            });
        });
        this.addItem(Material.ITEM_FRAME, EditorLocales.KIT_ICON, new int[]{14}).setClick((menuViewer, inventoryClickEvent) -> {
            if (inventoryClickEvent.isRightClick()) {
                PlayerUtil.addItem((Player)menuViewer.getPlayer(), (ItemStack[])new ItemStack[]{kit.getIcon()});
                return;
            }
            ItemStack itemStack = inventoryClickEvent.getCursor();
            if (itemStack == null || itemStack.getType().isAir()) {
                return;
            }
            kit.setIcon(itemStack);
            inventoryClickEvent.getView().setCursor(null);
            this.save(menuViewer);
        }).getOptions().addDisplayModifier((menuViewer, itemStack) -> itemStack.setType(kit.getIcon().getType()));
        this.addItem(Material.REDSTONE_TORCH, EditorLocales.KIT_PERMISSION, new int[]{15}).setClick((menuViewer, inventoryClickEvent) -> {
            kit.setPermissionRequired(!kit.isPermissionRequired());
            this.save(menuViewer);
        });
        this.addItem(Material.COMMAND_BLOCK, EditorLocales.KIT_COMMANDS, new int[]{20}).setClick((menuViewer, inventoryClickEvent) -> {
            if (inventoryClickEvent.isRightClick()) {
                kit.getCommands().clear();
                this.save(menuViewer);
                return;
            }
            this.handleInput(menuViewer, Lang.EDITOR_GENERIC_ENTER_COMMAND, inputWrapper -> {
                kit.getCommands().add(inputWrapper.getText());
                kit.save();
                return true;
            });
        });
        this.addItem(Material.BREWING_STAND, EditorLocales.KIT_POTIONS, new int[]{21}).setClick((menuViewer, inventoryClickEvent) -> {
            if (inventoryClickEvent.isRightClick()) {
                kit.getPotionEffects().clear();
                this.save(menuViewer);
                return;
            }
            EditorManager.suggestValues((Player)menuViewer.getPlayer(), Stream.of(PotionEffectType.values()).map(PotionEffectType::getName).toList(), (boolean)false);
            this.handleInput(menuViewer, Lang.EDITOR_KIT_ENTER_EFFECT, inputWrapper -> {
                String[] stringArray = inputWrapper.getTextRaw().split(" ");
                PotionEffectType potionEffectType = PotionEffectType.getByName((String)stringArray[0].toUpperCase());
                if (potionEffectType == null) {
                    EditorManager.error((Player)menuViewer.getPlayer(), (String)"#fd5e5eInvalid Effect!");
                    return false;
                }
                int n = stringArray.length >= 2 ? StringUtil.getInteger((String)stringArray[1], (int)1) : 1;
                PotionEffect potionEffect = new PotionEffect(potionEffectType, Integer.MAX_VALUE, Math.max(0, n - 1));
                kit.getPotionEffects().add(potionEffect);
                kit.save();
                return true;
            });
        });
        this.addItem(Material.ARMOR_STAND, EditorLocales.KIT_ARMOR, new int[]{23}).setClick((menuViewer, inventoryClickEvent) -> new ContentEditor(kit, 9).openNextTick(menuViewer, 1));
        this.addItem(Material.CHEST_MINECART, EditorLocales.KIT_INVENTORY, new int[]{24}).setClick((menuViewer, inventoryClickEvent) -> new ContentEditor(kit, 27).openNextTick(menuViewer, 1));
        this.getItems().forEach(menuItem -> menuItem.getOptions().addDisplayModifier((menuViewer, itemStack) -> ItemUtil.replace((ItemStack)itemStack, (UnaryOperator)kit.replacePlaceholders())));
    }

    private void save(@NotNull MenuViewer menuViewer) {
        ((Kit)this.object).save();
        this.openNextTick(menuViewer, menuViewer.getPage());
    }

    public void onClick(@NotNull MenuViewer menuViewer, @Nullable ItemStack itemStack, @NotNull Menu.SlotType slotType, int n, @NotNull InventoryClickEvent inventoryClickEvent) {
        super.onClick(menuViewer, itemStack, slotType, n, inventoryClickEvent);
        if (slotType == Menu.SlotType.PLAYER || slotType == Menu.SlotType.PLAYER_EMPTY) {
            inventoryClickEvent.setCancelled(false);
        }
    }

    private static class ContentEditor
    extends Menu<AMA> {
        private final Kit kit;
        private final boolean isArmor;

        public ContentEditor(@NotNull Kit kit, int n) {
            super((NexPlugin)((AMA)kit.plugin()), "Arena Kit Editor", n);
            this.kit = kit;
            this.isArmor = n == 9;
        }

        public boolean isPersistent() {
            return false;
        }

        public void onReady(@NotNull MenuViewer menuViewer, @NotNull Inventory inventory) {
            super.onReady(menuViewer, inventory);
            inventory.setContents(this.isArmor ? this.kit.getArmor() : this.kit.getItems());
        }

        public void onClick(@NotNull MenuViewer menuViewer, @Nullable ItemStack itemStack, @NotNull Menu.SlotType slotType, int n, @NotNull InventoryClickEvent inventoryClickEvent) {
            super.onClick(menuViewer, itemStack, slotType, n, inventoryClickEvent);
            inventoryClickEvent.setCancelled(false);
        }

        public void onClose(@NotNull MenuViewer menuViewer, @NotNull InventoryCloseEvent inventoryCloseEvent) {
            Inventory inventory = inventoryCloseEvent.getInventory();
            ItemStack[] itemStackArray = new ItemStack[this.isArmor ? 4 : 27];
            for (int i = 0; i < itemStackArray.length; ++i) {
                ItemStack itemStack = inventory.getItem(i);
                if (itemStack == null) continue;
                itemStackArray[i] = itemStack;
            }
            if (this.isArmor) {
                this.kit.setArmor(itemStackArray);
                this.kit.setExtras(new ItemStack[]{inventory.getItem(4)});
            } else {
                this.kit.setItems(itemStackArray);
            }
            this.kit.save();
            this.kit.getEditor().openNextTick(menuViewer, 1);
            super.onClose(menuViewer, inventoryCloseEvent);
        }
    }
}

