/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.kit.menu;

import java.util.function.Predicate;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nexmedia.engine.api.config.JYML;
import su.nexmedia.engine.api.menu.click.ItemClick;
import su.nightexpress.ama.AMA;
import su.nightexpress.ama.arena.impl.ArenaPlayer;
import su.nightexpress.ama.config.Lang;
import su.nightexpress.ama.data.impl.ArenaUser;
import su.nightexpress.ama.kit.Kit;
import su.nightexpress.ama.kit.menu.AbstractKitListMenu;

public class KitSelectMenu
extends AbstractKitListMenu {
    public KitSelectMenu(@NotNull AMA aMA, @NotNull JYML jYML) {
        super(aMA, jYML);
    }

    @Override
    @NotNull
    public Predicate<Kit> getFilter(@Nullable ArenaUser arenaUser) {
        return kit -> arenaUser != null && arenaUser.hasKit(kit.getId());
    }

    @NotNull
    public ItemClick getObjectClick(@NotNull Kit kit) {
        return (menuViewer, inventoryClickEvent) -> {
            Player player = menuViewer.getPlayer();
            ArenaPlayer arenaPlayer = ArenaPlayer.getPlayer(player);
            if (arenaPlayer == null) {
                return;
            }
            if (inventoryClickEvent.isLeftClick()) {
                if (!kit.isAvailable(arenaPlayer, true)) {
                    player.playSound(player.getLocation(), Sound.BLOCK_ANVIL_BREAK, 1.0f, 1.0f);
                    return;
                }
                arenaPlayer.setKit(kit);
                ((AMA)this.plugin).getMessage(Lang.Kit_Select_Success).replace(kit.replacePlaceholders()).send((CommandSender)player);
                player.playSound(player.getLocation(), Sound.ITEM_ARMOR_EQUIP_LEATHER, 1.0f, 1.0f);
                player.closeInventory();
            } else if (inventoryClickEvent.isRightClick()) {
                kit.getPreview().open(player, 1);
            }
        };
    }
}

