/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.mob.config;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Hoglin;
import org.bukkit.entity.Husk;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.PigZombie;
import org.bukkit.entity.PiglinAbstract;
import org.bukkit.entity.Zombie;
import org.bukkit.entity.ZombieVillager;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.config.JYML;
import su.nexmedia.engine.api.manager.AbstractConfigHolder;
import su.nexmedia.engine.api.placeholder.Placeholder;
import su.nexmedia.engine.api.placeholder.PlaceholderMap;
import su.nexmedia.engine.lang.LangManager;
import su.nexmedia.engine.utils.Colorizer;
import su.nexmedia.engine.utils.EntityUtil;
import su.nexmedia.engine.utils.NumberUtil;
import su.nexmedia.engine.utils.StringUtil;
import su.nightexpress.ama.AMA;
import su.nightexpress.ama.arena.util.ArenaUtils;
import su.nightexpress.ama.mob.config.MobsConfig;
import su.nightexpress.ama.mob.editor.MobMainEditor;
import su.nightexpress.ama.mob.style.MobStyleType;

public class MobConfig
extends AbstractConfigHolder<AMA>
implements Placeholder {
    private MobMainEditor editor;
    private String name;
    private boolean nameVisible;
    private EntityType entityType;
    private int levelMin;
    private int levelMax;
    private final Map<MobStyleType, String> styles = new HashMap<MobStyleType, String>();
    private boolean barEnabled;
    private BarStyle barStyle;
    private BarColor barColor;
    private final Map<EquipmentSlot, ItemStack> equipment;
    private final Map<Attribute, double[]> attributes = new HashMap<Attribute, double[]>();
    private final PlaceholderMap placeholderMap;

    public MobConfig(@NotNull AMA aMA, @NotNull JYML jYML) {
        super((NexPlugin)aMA, jYML);
        this.equipment = new HashMap<EquipmentSlot, ItemStack>();
        this.placeholderMap = new PlaceholderMap().add("%mob_id%", () -> ((MobConfig)this).getId()).add("%mob_name%", this::getName).add("%mob_name_visible%", () -> LangManager.getBoolean((boolean)this.isNameVisible())).add("%mob_entity_type%", () -> aMA.getLangManager().getEnum((Enum)this.getEntityType())).add("%mob_level_min%", () -> String.valueOf(this.getLevelMin())).add("%mob_level_max%", () -> String.valueOf(this.getLevelMax())).add("%mob_bossbar_enabled%", () -> LangManager.getBoolean((boolean)this.isBarEnabled())).add("%mob_bossbar_title%", () -> "-").add("%mob_bossbar_color%", () -> this.getBarColor().name()).add("%mob_bossbar_style%", () -> this.getBarStyle().name()).add("%mob_attributes_base%", () -> this.getAttributes().entrySet().stream().map(entry -> entry.getKey() + ": " + ((double[])entry.getValue())[0]).collect(Collectors.joining("\n"))).add("%mob_attributes_level%", () -> this.getAttributes().entrySet().stream().map(entry -> entry.getKey() + ": " + ((double[])entry.getValue())[1]).collect(Collectors.joining("\n")));
    }

    public boolean load() {
        this.setName(this.cfg.getString("Name", this.getId()));
        this.setNameVisible(this.cfg.getBoolean("Name_Visible"));
        EntityType entityType = (EntityType)this.cfg.getEnum("Entity_Type", EntityType.class);
        if (entityType == null) {
            throw new IllegalStateException("Invalid entity type for '" + this.getId() + "' mob!");
        }
        this.setEntityType(entityType);
        this.setLevelMin(this.cfg.getInt("Level.Minimum", 1));
        this.setLevelMax(this.cfg.getInt("Level.Maximum", 1));
        for (Attribute[] attributeArray : this.cfg.getSection("Styles")) {
            MobStyleType mobStyleType = StringUtil.getEnum((String)attributeArray, MobStyleType.class).orElse(null);
            if (mobStyleType == null) continue;
            String string = this.cfg.getString("Styles." + (String)attributeArray, "");
            this.addStyle(mobStyleType, string);
        }
        Object object = "Boss_Bar.";
        this.setBarEnabled(this.cfg.getBoolean((String)object + "Enabled"));
        this.setBarColor((BarColor)this.cfg.getEnum((String)object + "Color", BarColor.class, (Enum)BarColor.RED));
        this.setBarStyle((BarStyle)this.cfg.getEnum((String)object + "Style", BarStyle.class, (Enum)BarStyle.SOLID));
        Stream.of(EquipmentSlot.values()).forEach(equipmentSlot -> this.setEquipment((EquipmentSlot)equipmentSlot, this.cfg.getItemEncoded("Equipment." + equipmentSlot.name())));
        object = "Attributes.";
        for (Attribute attribute : Attribute.values()) {
            double d = this.cfg.getDouble((String)object + "Base." + attribute.name());
            double d2 = this.cfg.getDouble((String)object + "Per_Level." + attribute.name());
            if (!(d > 0.0) && !(d2 > 0.0)) continue;
            this.attributes.put(attribute, new double[]{d, d2});
        }
        return true;
    }

    public void onSave() {
        this.cfg.set("Name", (Object)this.getName());
        this.cfg.set("Name_Visible", (Object)this.isNameVisible());
        this.cfg.set("Entity_Type", (Object)this.getEntityType().name());
        this.cfg.set("Level.Minimum", (Object)this.getLevelMin());
        this.cfg.set("Level.Maximum", (Object)this.getLevelMax());
        this.cfg.set("Styles", null);
        this.getStyles().forEach((mobStyleType, string) -> this.cfg.set("Styles." + mobStyleType.name(), string));
        this.cfg.set("Equipment", null);
        Stream.of(EquipmentSlot.values()).forEach(equipmentSlot -> this.cfg.setItemEncoded("Equipment." + equipmentSlot.name(), this.getEquipment((EquipmentSlot)equipmentSlot)));
        String string2 = "Boss_Bar.";
        this.cfg.set(string2 + "Enabled", (Object)this.isBarEnabled());
        this.cfg.set(string2 + "Style", (Object)this.getBarStyle().name());
        this.cfg.set(string2 + "Color", (Object)this.getBarColor().name());
        this.cfg.set("Attributes", null);
        this.getAttributes().forEach((attribute, dArray) -> {
            String string = attribute.name();
            this.cfg.set("Attributes.Base." + string, (Object)dArray[0]);
            this.cfg.set("Attributes.Per_Level." + string, (Object)dArray[1]);
        });
    }

    @NotNull
    public MobMainEditor getEditor() {
        if (this.editor == null) {
            this.editor = new MobMainEditor(this);
        }
        return this.editor;
    }

    public void clear() {
        if (this.editor != null) {
            this.editor.clear();
            this.editor = null;
        }
    }

    @NotNull
    public PlaceholderMap getPlaceholders() {
        return this.placeholderMap;
    }

    @NotNull
    public BossBar createOrUpdateBar(@NotNull LivingEntity livingEntity) {
        String string = this.getBarTitle(livingEntity);
        BossBar bossBar = ArenaUtils.getMobBossBar(livingEntity);
        if (bossBar == null) {
            bossBar = ((AMA)this.plugin).getServer().createBossBar(string, this.getBarColor(), this.getBarStyle(), new BarFlag[]{BarFlag.DARKEN_SKY});
        }
        double d = EntityUtil.getAttribute((LivingEntity)livingEntity, (Attribute)Attribute.GENERIC_MAX_HEALTH);
        double d2 = Math.max(0.0, Math.min(1.0, livingEntity.getHealth() / d));
        bossBar.setTitle(string);
        bossBar.setProgress(d2);
        bossBar.setVisible(true);
        return bossBar;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(@NotNull String string) {
        this.name = Colorizer.apply((String)string);
    }

    public boolean isNameVisible() {
        return this.nameVisible;
    }

    public void setNameVisible(boolean bl) {
        this.nameVisible = bl;
    }

    @NotNull
    public EntityType getEntityType() {
        return this.entityType;
    }

    public void setEntityType(@NotNull EntityType entityType) {
        this.entityType = entityType;
    }

    public int getLevelMin() {
        return this.levelMin;
    }

    public void setLevelMin(int n) {
        this.levelMin = n;
    }

    public int getLevelMax() {
        return this.levelMax;
    }

    public void setLevelMax(int n) {
        this.levelMax = n;
    }

    public boolean isBarEnabled() {
        return this.barEnabled;
    }

    public void setBarEnabled(boolean bl) {
        this.barEnabled = bl;
    }

    @NotNull
    private String getBarTitle(@NotNull LivingEntity livingEntity) {
        double d = EntityUtil.getAttribute((LivingEntity)livingEntity, (Attribute)Attribute.GENERIC_MAX_HEALTH);
        return ((String)this.replacePlaceholders().apply((String)MobsConfig.BOSS_BAR_FORMAT.get())).replace("%mob_health%", NumberUtil.format((double)livingEntity.getHealth())).replace("%mob_health_max%", NumberUtil.format((double)d));
    }

    @NotNull
    public BarStyle getBarStyle() {
        return this.barStyle;
    }

    public void setBarStyle(@NotNull BarStyle barStyle) {
        this.barStyle = barStyle;
    }

    @NotNull
    public BarColor getBarColor() {
        return this.barColor;
    }

    public void setBarColor(@NotNull BarColor barColor) {
        this.barColor = barColor;
    }

    @NotNull
    public Map<MobStyleType, String> getStyles() {
        return this.styles;
    }

    @NotNull
    public String getStyle(@NotNull MobStyleType mobStyleType) {
        return this.getStyles().getOrDefault((Object)mobStyleType, "");
    }

    public void addStyle(@NotNull MobStyleType mobStyleType, @NotNull String string) {
        if (string.isEmpty() || !mobStyleType.isApplicable(this.getEntityType())) {
            return;
        }
        this.getStyles().put(mobStyleType, string);
    }

    public void removeStyle(@NotNull MobStyleType mobStyleType) {
        this.getStyles().remove((Object)mobStyleType);
    }

    @NotNull
    public Map<EquipmentSlot, ItemStack> getEquipment() {
        return this.equipment;
    }

    @NotNull
    public ItemStack getEquipment(@NotNull EquipmentSlot equipmentSlot) {
        return this.equipment.getOrDefault(equipmentSlot, new ItemStack(Material.AIR));
    }

    public void setEquipment(@NotNull EquipmentSlot equipmentSlot, @Nullable ItemStack itemStack) {
        if (itemStack == null) {
            itemStack = new ItemStack(Material.AIR);
        }
        this.getEquipment().put(equipmentSlot, itemStack);
    }

    @NotNull
    public Map<Attribute, double[]> getAttributes() {
        return this.attributes;
    }

    public void applySettings(@NotNull LivingEntity livingEntity, int n) {
        Ageable ageable;
        livingEntity.setCustomName(((String)this.replacePlaceholders().apply((String)MobsConfig.NAME_FORMAT.get())).replace("%mob_level%", NumberUtil.format((double)n)));
        livingEntity.setCustomNameVisible(this.isNameVisible());
        EntityEquipment entityEquipment = livingEntity.getEquipment();
        if (entityEquipment != null) {
            this.getEquipment().forEach((arg_0, arg_1) -> ((EntityEquipment)entityEquipment).setItem(arg_0, arg_1));
        }
        if (livingEntity instanceof Ageable) {
            ageable = (Ageable)livingEntity;
            ageable.setAdult();
        }
        if (livingEntity instanceof PiglinAbstract) {
            ageable = (PiglinAbstract)livingEntity;
            ageable.setImmuneToZombification(true);
        } else if (livingEntity instanceof Hoglin) {
            Hoglin hoglin = (Hoglin)livingEntity;
            hoglin.setImmuneToZombification(true);
        } else if (livingEntity instanceof Zombie) {
            Zombie zombie = (Zombie)livingEntity;
            if (zombie instanceof ZombieVillager) {
                ZombieVillager zombieVillager = (ZombieVillager)zombie;
                zombieVillager.setConversionTime(-1);
            } else if (zombie instanceof PigZombie) {
                PigZombie pigZombie = (PigZombie)zombie;
                pigZombie.setAngry(true);
            } else if (zombie instanceof Husk) {
                Husk husk = (Husk)zombie;
                husk.setConversionTime(-1);
            } else {
                zombie.setConversionTime(-1);
            }
        }
        this.getStyles().forEach((mobStyleType, string) -> mobStyleType.getWrapper().apply(livingEntity, (String)string));
    }

    public void applyAttributes(@NotNull LivingEntity livingEntity, int n) {
        int n2 = Math.min(this.getLevelMax(), Math.max(this.getLevelMin(), n)) - 1;
        this.getAttributes().forEach((attribute, dArray) -> {
            AttributeInstance attributeInstance = livingEntity.getAttribute(attribute);
            if (attributeInstance == null) {
                return;
            }
            if (dArray[0] <= 0.0) {
                dArray[0] = attributeInstance.getBaseValue();
            }
            double d = dArray[0] + dArray[1] * (double)n2;
            attributeInstance.setBaseValue(d);
            if (attribute == Attribute.GENERIC_MAX_HEALTH) {
                livingEntity.setHealth(d);
            }
        });
    }
}

