/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.mob.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.bukkit.entity.EntityType;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.config.JOption;
import su.nexmedia.engine.api.lang.LangMessage;
import su.nexmedia.engine.utils.Colorizer;
import su.nexmedia.engine.utils.StringUtil;
import su.nightexpress.ama.api.ArenaAPI;
import su.nightexpress.ama.api.currency.Currency;
import su.nightexpress.ama.mob.kill.MobKillReward;
import su.nightexpress.ama.mob.kill.MobKillStreak;

public class MobsConfig {
    public static final JOption<String> NAME_FORMAT = JOption.create((String)"Mobs.DisplayName_Format", (String)"#ffeea2%mob_name% #d4d9d8Lv. #fd5e5e%mob_level%", (String[])new String[]{"Sets entity display name format for internal AMA mobs.", "Placeholders: %mob_name%, %mob_level%"}).mapReader(Colorizer::apply);
    public static final JOption<String> BOSS_BAR_FORMAT = JOption.create((String)"Mobs.BossBar_Format", (String)"%mob_name% #fd5e5e%mob_health%\u2764", (String[])new String[]{"Sets BossBar title format for internal AMA mobs.", "Placeholders: %mob_name%, %mob_level%, %mob_health%, %mob_health_max%"}).mapReader(Colorizer::apply);
    public static final JOption<Set<EntityType>> ALLY_FROM_EGGS = JOption.forSet((String)"Mobs.Ally_From_Eggs", string -> StringUtil.getEnum((String)string, EntityType.class).orElse(null), Set.of(EntityType.SNOWMAN, EntityType.IRON_GOLEM, EntityType.WOLF), (String[])new String[]{"A list of mobs that will be marked as 'ally' mobs when spawned by Spawn Eggs on arenas.", "These mobs will fight together with players against the arena mobs."}).setWriter((jYML, string, set) -> jYML.set(string, set.stream().map(Enum::name).toList()));
    public static final JOption<Set<String>> ALLY_MYTHIC_MOBS = JOption.create((String)"Mobs.Ally_Mythic_Mobs", Set.of("SummonedMinion"), (String[])new String[]{"List of MythicMobs mob internal names that should not be counted as arena mobs.", "This option might be useful when you have plugins to summon MythicMobs that are allied with players."});
    public static final JOption<Boolean> KILL_REWARD_ENABLED = JOption.create((String)"Mobs.Kill_Rewards.Enabled", (boolean)true, (String[])new String[]{"Enables/Disables the Mob Kill Rewards feature."});
    public static final JOption<Boolean> KILL_REWARD_HOLOGRAM_ENABLED = JOption.create((String)"Mobs.Kill_Rewards.Hologram.Enabled", (boolean)true, (String[])new String[]{"When enabled, creates a hologram displaying amount of given reward(s) at mob death location.", "Supported Plugins: HolographicDisplays, DecentHolograms"});
    public static final JOption<Integer> KILL_REWARD_HOLOGRAM_LIFETIME = JOption.create((String)"Mobs.Kill_Rewards.Hologram.Lifetime", (int)3, (String[])new String[]{"Sets how long (in seconds) reward hologram will stay there before disappear."});
    public static final JOption<String> KILL_REWARD_HOLOGRAM_FORMAT_SCORE = JOption.create((String)"Mobs.Kill_Rewards.Hologram.Format.Score", (String)"+%amount% Score", (String[])new String[]{"Sets the hologram line format for score amount.", "Placeholders:", "- %amount% - Formatted score amount."});
    public static final JOption<String> KILL_REWARD_HOLOGRAM_FORMAT_PAYMENT = JOption.create((String)"Mobs.Kill_Rewards.Hologram.Format.Currency", (String)"+%amount%", (String[])new String[]{"Sets the hologram line format for currencies.", "Placeholders:", "- %amount% - Formatted currency amount."});
    public static final JOption<Map<String, MobKillReward>> KILL_REWARD_VALUES = JOption.forMap((String)"Mobs.Kill_Rewards.Table", (jYML, string, string2) -> MobKillReward.read(jYML, string + "." + string2, string2), () -> {
        HashMap<Object, MobKillReward> hashMap = new HashMap<Object, MobKillReward>();
        HashMap<Currency, Double> hashMap2 = new HashMap<Currency, Double>();
        ArenaAPI.getCurrencyManager().getCurrencies().forEach(currency -> hashMap2.put((Currency)currency, 1.0));
        hashMap.put("default", new MobKillReward("default", hashMap2, 1));
        hashMap.put("ama:" + EntityType.ZOMBIE.name(), new MobKillReward("ama:zombie", hashMap2, 3));
        return hashMap;
    }, (String[])new String[]{"Here you can create custom rewards for mob kills on the arena.", "===== Naming Info =====", "Format for mob names: '<Provider:MobId>'.", "* AMA Example: 'ama:zombie' - will give reward(s) for AMA Zombie mob (the one from /mobs/ folder).", "* MythicMobs Example: 'mythicmobs:skeletonking' - will give reward(s) for MythicMobs SkeletonKing mob.", "Also, you can use the 'default' keyword for all other mobs not listed here.", "===== =====", "All available currency names you can see in plugin startup log or here: https://github.com/nulli0n/AdvancedMobArena-spigot/wiki/"}).setWriter((jYML, string, map) -> map.forEach((string2, mobKillReward) -> mobKillReward.write(jYML, string + "." + string2)));
    public static final JOption<Boolean> KILL_STREAK_ENABLED = JOption.create((String)"Mobs.Kill_Streaks.Enabled", (boolean)true, (String[])new String[]{"Enables the Mob Kill Streak feature."});
    public static final JOption<Integer> KILL_STREAK_DECAY = JOption.create((String)"Mobs.Kill_Streaks.Streak_Decay", (int)5, (String[])new String[]{"Sets for how long (in seconds) kill streak will retain before reset to zero."});
    public static final JOption<Map<Integer, MobKillStreak>> KILL_STREAK_TABLE = JOption.forMap((String)"Mobs.Kill_Streaks.Table", string -> StringUtil.getInteger((String)string, (int)0), (jYML, string, string2) -> MobKillStreak.read(jYML, string + "." + string2, StringUtil.getInteger((String)string2, (int)0)), () -> {
        TreeMap<Integer, MobKillStreak> treeMap = new TreeMap<Integer, MobKillStreak>();
        treeMap.put(2, new MobKillStreak(2, new LangMessage((NexPlugin)ArenaAPI.PLUGIN, "<! type:\"titles:10:50:10\" !>#fd5e5e&lDouble Kill!"), new ArrayList<String>()));
        treeMap.put(3, new MobKillStreak(3, new LangMessage((NexPlugin)ArenaAPI.PLUGIN, "<! type:\"titles:10:50:10\" !>#fd5e5e&lTriple Kill!"), new ArrayList<String>()));
        treeMap.put(4, new MobKillStreak(4, new LangMessage((NexPlugin)ArenaAPI.PLUGIN, "<! type:\"titles:10:50:10\" !>#5edefd&lQuadra Kill!"), new ArrayList<String>()));
        treeMap.put(5, new MobKillStreak(5, new LangMessage((NexPlugin)ArenaAPI.PLUGIN, "<! type:\"titles:10:50:10\" !>#5edefd&lPenta Kill! \\n &d(+10 Coins)"), Collections.singletonList("ama coins add %player_name% 10")));
        treeMap.put(10, new MobKillStreak(10, new LangMessage((NexPlugin)ArenaAPI.PLUGIN, "<! type:\"titles:10:50:10\" !>#fdf35e&lx%amount% Kill! \\n #aefd5e(Heal)"), Collections.singletonList("heal %player_name%")));
        return treeMap;
    }, (String[])new String[]{"Here you can create and customize mob kill streaks.", "For 'Message' you can use %amount% placeholder for a kills amount. Please check: https://github.com/nulli0n/NexEngine-spigot/wiki/Language-Config", "For 'Commands', please check https://github.com/nulli0n/NexEngine-spigot/wiki/Configuration-Tips#command-sections"}).setWriter((jYML, string, map) -> map.forEach((n, mobKillStreak) -> mobKillStreak.write(jYML, string + "." + n)));
}

