/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.mob.editor;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.UnaryOperator;
import java.util.stream.IntStream;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.manager.AbstractConfigHolder;
import su.nexmedia.engine.api.menu.AutoPaged;
import su.nexmedia.engine.api.menu.click.ItemClick;
import su.nexmedia.engine.api.menu.impl.EditorMenu;
import su.nexmedia.engine.api.menu.impl.MenuOptions;
import su.nexmedia.engine.api.menu.impl.MenuViewer;
import su.nexmedia.engine.editor.EditorManager;
import su.nexmedia.engine.utils.ItemUtil;
import su.nightexpress.ama.AMA;
import su.nightexpress.ama.config.Lang;
import su.nightexpress.ama.editor.EditorLocales;
import su.nightexpress.ama.mob.MobManager;
import su.nightexpress.ama.mob.config.MobConfig;

public class MobListEditor
extends EditorMenu<AMA, MobManager>
implements AutoPaged<MobConfig> {
    public MobListEditor(@NotNull MobManager mobManager) {
        super((NexPlugin)((AMA)mobManager.plugin()), (Object)mobManager, "Arena Mob Editor", 45);
        this.addReturn(new int[]{39}).setClick((menuViewer, inventoryClickEvent) -> ((AMA)this.plugin).getEditor().openNextTick(menuViewer, 1));
        this.addNextPage(new int[]{44});
        this.addPreviousPage(new int[]{36});
        this.addCreation(EditorLocales.MOB_CREATE, new int[]{41}).setClick((menuViewer, inventoryClickEvent) -> this.handleInput(menuViewer, Lang.Editor_Mob_Enter_Create, inputWrapper -> {
            if (!mobManager.createMobConfig(inputWrapper.getTextRaw())) {
                EditorManager.error((Player)menuViewer.getPlayer(), (String)((AMA)this.plugin).getMessage(Lang.Editor_Mob_Error_Exist).getLocalized());
                return false;
            }
            return true;
        }));
    }

    public void onPrepare(@NotNull MenuViewer menuViewer, @NotNull MenuOptions menuOptions) {
        super.onPrepare(menuViewer, menuOptions);
        this.getItemsForPage(menuViewer).forEach(arg_0 -> ((MobListEditor)this).addItem(arg_0));
    }

    public int[] getObjectSlots() {
        return IntStream.range(0, 36).toArray();
    }

    @NotNull
    public List<MobConfig> getObjects(@NotNull Player player) {
        return new ArrayList<MobConfig>(((AMA)this.plugin).getMobManager().getMobConfigs().stream().sorted(Comparator.comparing(AbstractConfigHolder::getId)).toList());
    }

    @NotNull
    public ItemStack getObjectStack(@NotNull Player player, @NotNull MobConfig mobConfig) {
        Material material = Material.getMaterial((String)(mobConfig.getEntityType().name() + "_SPAWN_EGG"));
        if (mobConfig.getEntityType() == EntityType.MUSHROOM_COW) {
            material = Material.MOOSHROOM_SPAWN_EGG;
        }
        if (material == null) {
            material = Material.BAT_SPAWN_EGG;
        }
        ItemStack itemStack = new ItemStack(material);
        ItemUtil.mapMeta((ItemStack)itemStack, itemMeta -> {
            itemMeta.setDisplayName(EditorLocales.MOB_OBJECT.getLocalizedName());
            itemMeta.setLore(EditorLocales.MOB_OBJECT.getLocalizedLore());
            itemMeta.addItemFlags(ItemFlag.values());
            ItemUtil.replace((ItemMeta)itemMeta, (UnaryOperator)mobConfig.replacePlaceholders());
        });
        return itemStack;
    }

    @NotNull
    public ItemClick getObjectClick(@NotNull MobConfig mobConfig) {
        return (menuViewer, inventoryClickEvent) -> {
            if (inventoryClickEvent.isShiftClick()) {
                if (mobConfig.getFile().delete()) {
                    mobConfig.clear();
                    ((MobManager)((Object)((Object)this.object))).getMobConfigMap().remove(mobConfig.getId());
                    this.openNextTick(menuViewer, menuViewer.getPage());
                }
                return;
            }
            mobConfig.getEditor().openNextTick(menuViewer, 1);
        };
    }
}

