/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.nms.v1_20_R1.brain.behavior.impl;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtil;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.MemoryTarget;
import net.minecraft.world.entity.animal.frog.Frog;
import su.nightexpress.ama.nms.v1_20_R1.brain.MobAI;

public class ShootTongue
extends Behavior<Frog> {
    public static final int TIME_OUT_DURATION = 100;
    public static final int CATCH_ANIMATION_DURATION = 6;
    public static final int TONGUE_ANIMATION_DURATION = 10;
    private static final float EATING_DISTANCE = 2.5f;
    private static final float EATING_MOVEMENT_FACTOR = 0.75f;
    private int eatAnimationTimer;
    private int calculatePathCounter;
    private int attackCooldown;
    private State state = State.MOVE_TO_TARGET;

    public ShootTongue() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.n, (Object)MemoryStatus.c, (Object)MemoryModuleType.o, (Object)MemoryStatus.a), 100);
    }

    protected boolean canStillUse(WorldServer worldServer, Frog frog, long l) {
        EntityLiving entityLiving = MobAI.getAngerTarget((EntityInsentient)frog).orElse(null);
        return entityLiving != null && entityLiving.bs();
    }

    protected void start(WorldServer worldServer, Frog frog, long l) {
        EntityLiving entityLiving = MobAI.getAngerTarget((EntityInsentient)frog).orElse(null);
        if (entityLiving != null) {
            BehaviorUtil.a((EntityLiving)frog, (EntityLiving)entityLiving);
            frog.a((Entity)entityLiving);
            frog.dK().a(MemoryModuleType.m, (Object)new MemoryTarget(entityLiving.dg(), 2.0f, 0));
        }
        this.calculatePathCounter = 10;
        this.state = State.MOVE_TO_TARGET;
    }

    protected void stop(WorldServer worldServer, Frog frog, long l) {
        frog.dK().b(MemoryModuleType.o);
        frog.q();
        frog.b(EntityPose.a);
    }

    protected boolean a(long l) {
        return false;
    }

    private void eatEntity(WorldServer worldServer, Frog frog) {
        worldServer.a(null, (Entity)frog, SoundEffects.iG, SoundCategory.g, 2.0f, 1.0f);
        Optional optional = frog.r();
        if (optional.isEmpty()) {
            return;
        }
        Entity entity = (Entity)optional.get();
        if (entity.bs()) {
            frog.z(entity);
            if (!entity.bs()) {
                entity.a(Entity.RemovalReason.a);
            }
        }
    }

    protected void tick(WorldServer worldServer, Frog frog, long l) {
        EntityLiving entityLiving = MobAI.getAngerTarget((EntityInsentient)frog).orElse(null);
        if (entityLiving == null || !entityLiving.bs()) {
            return;
        }
        frog.a((Entity)entityLiving);
        BehaviorUtil.a((EntityLiving)frog, (EntityLiving)entityLiving);
        --this.attackCooldown;
        switch (this.state) {
            case MOVE_TO_TARGET: {
                if (entityLiving.e((Entity)frog) <= 2.5f) {
                    frog.J().n();
                    frog.dK().b(MemoryModuleType.m);
                    if (this.attackCooldown > 0) break;
                    worldServer.a(null, (Entity)frog, SoundEffects.iL, SoundCategory.g, 2.0f, 1.0f);
                    frog.b(EntityPose.j);
                    entityLiving.f(entityLiving.dg().a(frog.dg()).d().a(0.75));
                    this.eatAnimationTimer = 0;
                    this.state = State.CATCH_ANIMATION;
                    break;
                }
                if (--this.calculatePathCounter > 0) break;
                frog.dK().a(MemoryModuleType.m, (Object)new MemoryTarget(entityLiving.dg(), 2.0f, 0));
                this.calculatePathCounter = 10;
                break;
            }
            case CATCH_ANIMATION: {
                if (++this.eatAnimationTimer < 6) break;
                this.state = State.EAT_ANIMATION;
                this.eatEntity(worldServer, frog);
                break;
            }
            case EAT_ANIMATION: {
                if (this.eatAnimationTimer++ < 10) break;
                this.state = State.MOVE_TO_TARGET;
                this.attackCooldown = 40;
                frog.b(EntityPose.a);
            }
        }
    }

    private static enum State {
        MOVE_TO_TARGET,
        CATCH_ANIMATION,
        EAT_ANIMATION;

    }
}

