/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.sign.listener;

import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.permissions.Permission;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.manager.AbstractListener;
import su.nightexpress.ama.AMA;
import su.nightexpress.ama.Perms;
import su.nightexpress.ama.sign.SignManager;
import su.nightexpress.ama.sign.type.SignType;

public class SignListener
extends AbstractListener<AMA> {
    private final SignManager signManager;

    public SignListener(@NotNull SignManager signManager) {
        super((NexPlugin)((AMA)signManager.plugin()));
        this.signManager = signManager;
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onSignInteract(PlayerInteractEvent playerInteractEvent) {
        if (playerInteractEvent.getHand() == EquipmentSlot.OFF_HAND) {
            return;
        }
        if (playerInteractEvent.useInteractedBlock() == Event.Result.DENY) {
            return;
        }
        if (playerInteractEvent.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Block block = playerInteractEvent.getClickedBlock();
        if (block == null) {
            return;
        }
        BlockState blockState = block.getState();
        if (!(blockState instanceof Sign)) {
            return;
        }
        Sign sign = (Sign)blockState;
        SignType signType = this.signManager.getSignType(sign);
        if (signType == null) {
            return;
        }
        playerInteractEvent.setUseInteractedBlock(Event.Result.DENY);
        playerInteractEvent.setUseItemInHand(Event.Result.DENY);
        Player player = playerInteractEvent.getPlayer();
        this.signManager.signInteract(player, sign);
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onSignCreate(SignChangeEvent signChangeEvent) {
        if (!signChangeEvent.getPlayer().hasPermission((Permission)Perms.CREATOR)) {
            return;
        }
        BlockState blockState = signChangeEvent.getBlock().getState();
        if (!(blockState instanceof Sign)) {
            return;
        }
        Sign sign = (Sign)blockState;
        this.signManager.signCreate(sign, signChangeEvent.getLines());
    }
}

