/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.mobs.impl.customMobs.entityBuilders;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.UnmodifiableIterator;
import java.io.File;
import java.lang.invoke.LambdaMetafactory;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import net.advancedplugins.mobs.impl.commons.effects.effects.AdvancedEffect;
import net.advancedplugins.mobs.impl.customMobs.entityBuilders.PartProperty;
import net.advancedplugins.mobs.impl.customMobs.entityBuilders.subclass.AnimationCache;
import net.advancedplugins.mobs.impl.customMobs.entityBuilders.subclass.EntityBaseFlag;
import net.advancedplugins.mobs.impl.customMobs.entityBuilders.subclass.EntityBaseFlagValue;
import net.advancedplugins.mobs.impl.customMobs.entityBuilders.subclass.PartArmorType;
import net.advancedplugins.mobs.impl.customMobs.entityBuilders.subclass.PartOffset;
import net.advancedplugins.mobs.impl.customMobs.entityBuilders.subclass.PartType;
import net.advancedplugins.mobs.impl.customMobs.entityBuilders.subclass.SkinPack;
import net.advancedplugins.mobs.impl.customMobs.entityBuilders.subclass.SoundType;
import net.advancedplugins.mobs.impl.utils.ASManager;
import net.advancedplugins.mobs.impl.utils.nbt.utils.MinecraftVersion;
import org.bukkit.Sound;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;

public class EntityBase {
    private ImmutableMap<String, PartProperty> parts;
    private ImmutableMap<EntityBaseFlag, EntityBaseFlagValue> baseFlags;
    private ImmutableMap<String, SkinPack> skinPacks;
    private AnimationCache animations;
    private String name;
    private File mobFile;
    private FileConfiguration fc;
    private String modelEngine = null;
    private boolean customAI = false;
    private boolean ai = true;
    private double outermostPartDistance = 0.0;
    private ItemStack displayItem;
    private static int a;
    private static final String[] b;

    public EntityBase(String string, FileConfiguration fileConfiguration) {
        this.name = string;
        this.fc = fileConfiguration;
        this.init();
    }

    public void init() {
        if (this.fc == null) {
            return;
        }
        this.parts = null;
        this.baseFlags = null;
        this.skinPacks = ImmutableMap.builder().build();
        this.animations = null;
        this.cacheSkins((ConfigurationSection)this.fc);
        this.cacheParts(this.fc);
        this.cacheFlags(this.fc);
        this.animations = new AnimationCache(this.fc, this);
        this.updateOpd();
    }

    public AnimationCache getAnimations() {
        return this.animations;
    }

    public PartProperty getPart(String string) {
        return (PartProperty)this.parts.get((Object)string);
    }

    public Object getBaseFlag(EntityBaseFlag entityBaseFlag) {
        EntityBaseFlagValue entityBaseFlagValue = (EntityBaseFlagValue)this.baseFlags.get((Object)entityBaseFlag);
        if (entityBaseFlagValue == null) {
            return null;
        }
        return entityBaseFlagValue.getObject();
    }

    public Sound getSound(SoundType soundType) {
        String string;
        String[] stringArray;
        String string2;
        block12: {
            string2 = (String)this.getBaseFlag(EntityBaseFlag.SOUNDS);
            try {
                if (string2 == null) {
                    return null;
                }
            }
            catch (Exception exception) {
                throw EntityBase.b(exception);
            }
            try {
                stringArray = b;
                if (!string2.equalsIgnoreCase(stringArray[1]) || MinecraftVersion.isNew()) break block12;
            }
            catch (Exception exception) {
                throw EntityBase.b(exception);
            }
            stringArray = b;
            string2 = stringArray[2];
        }
        try {
            string = MinecraftVersion.isNew() ? soundType.getNewFormat() : soundType.getOldFormat();
        }
        catch (Exception exception) {
            throw EntityBase.b(exception);
        }
        String string3 = string;
        string3 = String.format(string3, string2).toUpperCase(Locale.ROOT);
        try {
            return Sound.valueOf((String)string3);
        }
        catch (Exception exception) {
            stringArray = b;
            if (string3.endsWith(stringArray[6])) {
                try {
                    return Sound.valueOf((String)String.format(stringArray[0], string2).toUpperCase(Locale.ROOT));
                }
                catch (Exception exception2) {
                    return null;
                }
            }
            return null;
        }
    }

    public List<String> getBiomes() {
        return (List)this.getBaseFlag(EntityBaseFlag.BIOMES);
    }

    public ImmutableMap<String, PartProperty> getParts() {
        return this.parts;
    }

    public String getName() {
        return this.name;
    }

    public int getHealth() {
        return Integer.parseInt(this.getOrDefault(EntityBaseFlag.HEALTH) + "");
    }

    public Double getDamage() {
        return Double.parseDouble(this.getOrDefault(EntityBaseFlag.DAMAGE) + "");
    }

    public boolean isHostile() {
        return (Boolean)this.getOrDefault(EntityBaseFlag.HOSTILE);
    }

    public boolean isWalkingOnlyAnimation() {
        return (Boolean)this.getOrDefault(EntityBaseFlag.ANIMATEONWALKING);
    }

    public int getAnimationFrequency() {
        return Integer.parseInt(this.getOrDefault(EntityBaseFlag.ANIMATIONSMOOTHNESS) + "");
    }

    public int getAnimationSpeed() {
        return Integer.parseInt(this.getOrDefault(EntityBaseFlag.ANIMATIONSPEED) + "");
    }

    public Double getNameTagHeight() {
        return Double.parseDouble(this.getOrDefault(EntityBaseFlag.NAMETAGHEIGHT) + "");
    }

    private Object getOrDefault(EntityBaseFlag entityBaseFlag) {
        EntityBaseFlagValue entityBaseFlagValue = (EntityBaseFlagValue)this.baseFlags.get((Object)entityBaseFlag);
        if (entityBaseFlagValue == null) {
            return entityBaseFlag.getDef();
        }
        return entityBaseFlagValue.getObject();
    }

    public EntityType getMobType() {
        if (this.getBaseFlag(EntityBaseFlag.MOBTYPE) == null) {
            return EntityType.SILVERFISH;
        }
        return EntityType.fromName((String)(this.getBaseFlag(EntityBaseFlag.MOBTYPE) + ""));
    }

    public String getSounds() {
        return (String)this.getOrDefault(EntityBaseFlag.SOUNDS);
    }

    public String getSkin(String string) {
        return this.getSkin(string, b[8]);
    }

    public boolean isSkinPack(String string) {
        return this.skinPacks.containsKey((Object)string);
    }

    public String getSkin(String string, String string2) {
        try {
            return ((SkinPack)this.skinPacks.get((Object)string2)).getSkin(string);
        }
        catch (Exception exception) {
            return b[8];
        }
    }

    public ImmutableMap<String, SkinPack> getSkinPacks() {
        return this.skinPacks;
    }

    public ImmutableMap<String, String> getSkinMap() {
        return this.getSkinMap(b[8]);
    }

    public ImmutableMap<String, String> getSkinMap(String string) {
        return ((SkinPack)this.skinPacks.get((Object)string)).getSkinMap();
    }

    private void cacheParts(FileConfiguration fileConfiguration) {
        LinkedHashMap<String, PartProperty> linkedHashMap = new LinkedHashMap<String, PartProperty>();
        int n = EntityBase.c();
        String[] stringArray = b;
        if (fileConfiguration.isConfigurationSection(stringArray[4])) {
            for (String string : Objects.requireNonNull(fileConfiguration.getConfigurationSection(stringArray[4])).getKeys(false)) {
                linkedHashMap.put(string, new PartProperty(string, Objects.requireNonNull(fileConfiguration.getConfigurationSection(b[12] + string)), this));
                if (n != 0) {
                    if (n != 0) continue;
                }
                break;
            }
        } else {
            this.parts = ImmutableMap.copyOf(linkedHashMap);
        }
    }

    private void cacheFlags(FileConfiguration fileConfiguration) {
        block2: {
            HashMap<EntityBaseFlag, EntityBaseFlagValue> hashMap = new HashMap<EntityBaseFlag, EntityBaseFlagValue>();
            int n = EntityBase.c();
            String[] stringArray = b;
            for (String string : Objects.requireNonNull(fileConfiguration.getConfigurationSection(stringArray[11])).getKeys(false)) {
                hashMap.put(EntityBaseFlag.valueOf(string.toUpperCase(Locale.ROOT)), new EntityBaseFlagValue().setValue(fileConfiguration.get(b[5] + string)));
                if (n != 0) {
                    if (n != 0) continue;
                }
                break block2;
            }
            this.baseFlags = ImmutableMap.copyOf(hashMap);
        }
    }

    public void cacheSkins(ConfigurationSection configurationSection) {
        this.cacheSkins(configurationSection, b[8]);
    }

    public void cacheSkins(ConfigurationSection configurationSection, String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n = EntityBase.c();
        String[] stringArray = b;
        if (configurationSection.isConfigurationSection(stringArray[3])) {
            for (String string2 : Objects.requireNonNull(configurationSection.getConfigurationSection(stringArray[3])).getKeys(false)) {
                hashMap.put(string2, configurationSection.getString(b[7] + string2));
                if (n != 0) continue;
            }
        }
        SkinPack skinPack = new SkinPack(string);
        skinPack.addAllSkins(hashMap);
        this.skinPacks = ImmutableMap.builder().putAll(this.skinPacks).put((Object)string, (Object)skinPack).build();
        if (AdvancedEffect.b() == null) {
            EntityBase.b(++n);
        }
    }

    public void setFile(File file) {
        this.mobFile = file;
    }

    public File getMobFile() {
        return this.mobFile;
    }

    public void reloadFile() {
        if (this.fc != null) {
            try {
                this.fc.save(this.getMobFile());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.fc = new YamlConfiguration();
        try {
            this.fc.load(this.mobFile);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public FileConfiguration getConfig() {
        return this.fc;
    }

    public boolean containsFlag(EntityBaseFlag entityBaseFlag) {
        return this.baseFlags.containsKey((Object)entityBaseFlag);
    }

    public void setHostile(boolean bl) {
        HashMap hashMap = Maps.newHashMap(this.baseFlags);
        hashMap.remove((Object)EntityBaseFlag.HOSTILE);
        this.baseFlags = ImmutableMap.builder().putAll((Map)hashMap).put((Object)EntityBaseFlag.HOSTILE, (Object)new EntityBaseFlagValue().setValue(bl)).build();
    }

    public boolean isCustomAI() {
        return this.customAI;
    }

    public void setCustomAI(boolean bl) {
        this.customAI = bl;
    }

    public double getOpd() {
        return this.outermostPartDistance;
    }

    private void updateOpd() {
        UnmodifiableIterator unmodifiableIterator = this.parts.values().iterator();
        int n = EntityBase.b();
        while (unmodifiableIterator.hasNext()) {
            PartProperty partProperty = (PartProperty)unmodifiableIterator.next();
            PartOffset partOffset = partProperty.getOffset(PartType.BODY);
            double d = Math.abs(partOffset.getX());
            double d2 = Math.abs(partOffset.getZ());
            if (d > this.outermostPartDistance) {
                this.outermostPartDistance = d;
            }
            if (d2 > this.outermostPartDistance) {
                this.outermostPartDistance = d2;
            }
            if (n == 0) continue;
        }
    }

    /*
     * Unable to fully structure code
     */
    public ItemStack getDisplayitem() {
        block27: {
            try {
                if (this.displayItem != null) {
                    return this.displayItem;
                }
            }
            catch (Exception v0) {
                throw EntityBase.b(v0);
            }
            var1_1 = null;
            try {
                block26: {
                    block25: {
                        block24: {
                            block23: {
                                block29: {
                                    block28: {
                                        var2_2 = null;
                                        if (this.getBaseFlag(EntityBaseFlag.DISPLAYITEM) != null) {
                                            var2_2 = this.getPart(this.getBaseFlag(EntityBaseFlag.DISPLAYITEM).toString()).getItem(PartArmorType.HEAD);
                                        }
                                        if (var2_2 != null) break block23;
                                        if (this.getBaseFlag(EntityBaseFlag.DISPLAYITEM) == null) ** GOTO lbl32
                                        break block28;
                                        catch (Exception v1) {
                                            throw EntityBase.b(v1);
                                        }
                                    }
                                    if (this.getBaseFlag(EntityBaseFlag.DISPLAYITEM) == null) break block23;
                                    break block29;
                                    catch (Exception v2) {
                                        throw EntityBase.b(v2);
                                    }
                                }
                                try {
                                    block30: {
                                        var4_4 = EntityBase.b;
                                        if (this.getBaseFlag(EntityBaseFlag.DISPLAYITEM).equals(var4_4[9])) break block23;
                                        break block30;
                                        catch (Exception v3) {
                                            throw EntityBase.b(v3);
                                        }
                                    }
                                    if (this.getPart((var4_4 = EntityBase.b)[9]) == null) break block23;
                                }
                                catch (Exception v4) {
                                    throw EntityBase.b(v4);
                                }
                                var4_4 = EntityBase.b;
                                var2_2 = this.getPart(var4_4[9]).getItem(PartArmorType.HEAD);
                            }
                            try {
                                if (var2_2 != null || this.getPart((var4_4 = EntityBase.b)[9]) == null) break block24;
                            }
                            catch (Exception v5) {
                                throw EntityBase.b(v5);
                            }
                            var4_4 = EntityBase.b;
                            var2_2 = this.getPart(var4_4[9]).getItem(PartArmorType.HAND);
                        }
                        try {
                            if (var2_2 != null || this.isModelEngineModel()) break block25;
                        }
                        catch (Exception v6) {
                            throw EntityBase.b(v6);
                        }
                        var1_1 = this.getParts().values().stream().filter((Predicate<PartProperty>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$getDisplayitem$0(net.advancedplugins.mobs.impl.customMobs.entityBuilders.PartProperty ), (Lnet/advancedplugins/mobs/impl/customMobs/entityBuilders/PartProperty;)Z)()).findFirst().get().getItem(PartArmorType.HEAD).getItem();
                    }
                    try {
                        if (var2_2 == null || var2_2.getItem() == null) break block26;
                    }
                    catch (Exception v7) {
                        throw EntityBase.b(v7);
                    }
                    var1_1 = var2_2.getItem();
                }
                if (var1_1 != null) break block27;
                var4_4 = EntityBase.b;
            }
            catch (Exception var2_3) {
                if (var1_1 == null) {
                    var4_5 = EntityBase.b;
                    var1_1 = ASManager.matchMaterial(var4_5[10], 1, 0);
                }
            }
            catch (Throwable var3_6) {
                if (var1_1 == null) {
                    var1_1 = ASManager.matchMaterial(EntityBase.b[10], 1, 0);
                }
                throw var3_6;
            }
            var1_1 = ASManager.matchMaterial(var4_4[10], 1, 0);
        }
        this.displayItem = var1_1;
        return var1_1;
    }

    public boolean shouldHeadFollow() {
        return (Boolean)this.getOrDefault(EntityBaseFlag.HEADFOLLOW);
    }

    public boolean isModelEngineModel() {
        return this.getBaseFlag(EntityBaseFlag.MODELENGINE) != null;
    }

    public boolean isAIEnabled() {
        return this.ai;
    }

    public void isAIActive(boolean bl) {
        this.ai = !bl;
    }

    public boolean isVanillaMob() {
        return !this.getMobType().equals((Object)EntityType.SILVERFISH);
    }

    public Double getWalkingSpeed() {
        Double d;
        block3: {
            block2: {
                int n = EntityBase.b();
                if (!this.containsFlag(EntityBaseFlag.WALKINGSPEED)) break block2;
                d = (Double)this.getBaseFlag(EntityBaseFlag.WALKINGSPEED);
                if (n == 0) break block3;
            }
            d = (Double)EntityBaseFlag.WALKINGSPEED.getDef();
        }
        return d;
    }

    public String getNiceName() {
        return ASManager.capitalize(this.name.replace("_", " "));
    }

    private static /* synthetic */ boolean lambda$getDisplayitem$0(PartProperty partProperty) {
        return partProperty.getItem(PartArmorType.HEAD) != null;
    }

    public static void b(int n) {
        a = n;
    }

    public static int b() {
        return a;
    }

    public static int c() {
        int n = EntityBase.b();
        if (n == 0) {
            return 108;
        }
        return 0;
    }

    private static Exception b(Exception exception) {
        return exception;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block10: {
            block9: {
                var5 = new String[13];
                var3_1 = 0;
                var2_2 = "V0@\u007f\u0010c\u0006\u001c z[6C\u00030\u0002K\u0005\u0000(vY*\u0005\u0003\"mC*\t\u0000&kC0YG\u0000m\u0005,\u000bJe\r\u0006\u0000(vY*\u0019\u0007\u0017&yV,[T\u0004\u001b&~S\n7\u0011^p\u0016y\u007f6\u0004X";
                var4_3 = "V0@\u007f\u0010c\u0006\u001c z[6C\u00030\u0002K\u0005\u0000(vY*\u0005\u0003\"mC*\t\u0000&kC0YG\u0000m\u0005,\u000bJe\r\u0006\u0000(vY*\u0019\u0007\u0017&yV,[T\u0004\u001b&~S\n7\u0011^p\u0016y\u007f6\u0004X".length();
                var1_4 = 6;
                var0_5 = -1;
                EntityBase.b(0);
lbl8:
                // 2 sources

                while (true) {
                    v0 = 56;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block9;
                    break;
                }
lbl14:
                // 1 sources

                while (true) {
                    var5[var3_1++] = EntityBase.a(v0, EntityBase.a(v2));
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "x^\u0013;H!?x\u0006{Z\u0015;Ra";
                    var4_3 = "x^\u0013;H!?x\u0006{Z\u0015;Ra".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl23:
                    // 2 sources

                    while (true) {
                        v0 = 64;
                        v4 = ++var0_5;
                        v2 = var2_2.substring(v4, v4 + var1_4);
                        v3 = 0;
                        break block9;
                        break;
                    }
                    break;
                }
lbl29:
                // 1 sources

                while (true) {
                    var5[var3_1++] = EntityBase.a(v0, EntityBase.a(v2));
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block10;
                    break;
                }
            }
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl40:
                // 1 sources

                ** continue;
            }
        }
        EntityBase.b = var5;
    }

    private static char[] a(String string) {
        char[] cArray = string.toCharArray();
        if (cArray.length < 2) {
            cArray = cArray;
            cArray[0] = (char)(cArray[0] ^ 0x18);
        }
        return cArray;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    private static String a(int n, char[] cArray) {
        char[] cArray2;
        block11: {
            int n2;
            int n3;
            int n4;
            block10: {
                n4 = n;
                cArray2 = cArray;
                n3 = cArray.length;
                n2 = 0;
                if (!true) break block10;
                n3 = n3;
                if (n3 <= n2) break block11;
            }
            do {
                int n5;
                n4 = n4;
                cArray2 = cArray2;
                int n6 = n2;
                switch (n2 % 7) {
                    case 0: {
                        n5 = 75;
                        break;
                    }
                    case 1: {
                        n5 = 123;
                        break;
                    }
                    case 2: {
                        n5 = 39;
                        break;
                    }
                    case 3: {
                        n5 = 15;
                        break;
                    }
                    case 4: {
                        n5 = 97;
                        break;
                    }
                    case 5: {
                        n5 = 15;
                        break;
                    }
                    default: {
                        n5 = 24;
                    }
                }
                cArray2[n6] = (char)(cArray2[n6] ^ (n4 ^ n5));
                ++n2;
                n3 = n3;
            } while (n3 > n2);
        }
        return new String(cArray2).intern();
    }
}

